package compare

import (
	"strings"
)

// StringSlice compares two string slices for equality
func StringSlice(a, b []string) bool {
	// If one is nil, the other must also be nil.
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i := range a {
		if !strings.EqualFold(a[i], b[i]) {
			return false
		}
	}
	return true
}

// StringMap compares two string maps for equality
func StringMap(a, b map[string]string) bool {
	// If one is nil, the other must also be nil.
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || !strings.EqualFold(v, w) {
			return false
		}
	}
	return true
}
