# object-copy [![NPM version](https://img.shields.io/npm/v/object-copy.svg?style=flat)](https://www.npmjs.com/package/object-copy) [![NPM monthly downloads](https://img.shields.io/npm/dm/object-copy.svg?style=flat)](https://npmjs.org/package/object-copy) [![NPM total downloads](https://img.shields.io/npm/dt/object-copy.svg?style=flat)](https://npmjs.org/package/object-copy) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/object-copy.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/object-copy)

> Copy static properties, prototype properties, and descriptors from one object to another.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save object-copy
```

## Usage

```js
var copy = require('object-copy');
```

## API

### [copy](index.js#L32)

Copy static properties, prototype properties, and descriptors from one object to another.

**Params**

* `receiver` **{Object}**
* `provider` **{Object}**
* `omit` **{String|Array}**: (optional) One or more properties to omit
* `filter` **{Function}**: (optional) Called on each key before copying the property. If the function returns false, the property will not be copied.
* `returns` **{Object}**

**Example**

```js
function App() {}
var proto = App.prototype;
App.prototype.set = function() {};
App.prototype.get = function() {};

var obj = {};
copy(obj, proto);

// filter out keys
copy(obj, proto, function(key) {
  return key !== 'index';
});
```

## About

### Related projects

* [copy-descriptor](https://www.npmjs.com/package/copy-descriptor): Copy a descriptor from object A to object B | [homepage](https://github.com/jonschlinkert/copy-descriptor "Copy a descriptor from object A to object B")
* [define-property](https://www.npmjs.com/package/define-property): Define a non-enumerable property on an object. | [homepage](https://github.com/jonschlinkert/define-property "Define a non-enumerable property on an object.")
* [kind-of](https://www.npmjs.com/package/kind-of): Get the native type of a value. | [homepage](https://github.com/jonschlinkert/kind-of "Get the native type of a value.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on June 25, 2017._