/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.List;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

public class StoreTokens {
    private StoreTokens() {
    }

    public static TokensLoader allReadableTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(StoreCursors storeCursors) {
                return neoStores.getPropertyKeyTokenStore().getAllReadableTokens(storeCursors);
            }

            public List<NamedToken> getLabelTokens(StoreCursors storeCursors) {
                return neoStores.getLabelTokenStore().getAllReadableTokens(storeCursors);
            }

            public List<NamedToken> getRelationshipTypeTokens(StoreCursors storeCursors) {
                return neoStores.getRelationshipTypeTokenStore().getAllReadableTokens(storeCursors);
            }
        };
    }

    public static TokensLoader allTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(StoreCursors storeCursors) {
                return neoStores.getPropertyKeyTokenStore().getTokens(storeCursors);
            }

            public List<NamedToken> getLabelTokens(StoreCursors storeCursors) {
                return neoStores.getLabelTokenStore().getTokens(storeCursors);
            }

            public List<NamedToken> getRelationshipTypeTokens(StoreCursors storeCursors) {
                return neoStores.getRelationshipTypeTokenStore().getTokens(storeCursors);
            }
        };
    }

    public static TokenHolders readOnlyTokenHolders(NeoStores neoStores, StoreCursors storeCursors) {
        TokenHolder propertyKeyTokens = StoreTokens.createReadOnlyTokenHolder("PropertyKey");
        TokenHolder labelTokens = StoreTokens.createReadOnlyTokenHolder("Label");
        TokenHolder relationshipTypeTokens = StoreTokens.createReadOnlyTokenHolder("RelationshipType");
        TokenHolders tokenHolders = new TokenHolders(propertyKeyTokens, labelTokens, relationshipTypeTokens);
        tokenHolders.setInitialTokens(StoreTokens.allReadableTokens(neoStores), storeCursors);
        return tokenHolders;
    }

    public static TokenHolder createReadOnlyTokenHolder(String tokenType) {
        return new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), tokenType);
    }
}

