/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public class PrettyPrinter
implements AnyValueWriter<RuntimeException> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();
    private final String quoteMark;
    private final StringBuilder builder;
    private final AnyValueWriter.EntityMode entityMode;
    private final Counter counter;

    public PrettyPrinter() {
        this(AnyValueWriter.EntityMode.FULL);
    }

    public PrettyPrinter(AnyValueWriter.EntityMode entityMode) {
        this("\"", entityMode, Integer.MAX_VALUE);
    }

    public PrettyPrinter(String quoteMark, AnyValueWriter.EntityMode entityMode) {
        this(quoteMark, entityMode, Integer.MAX_VALUE);
    }

    public PrettyPrinter(String quoteMark, AnyValueWriter.EntityMode entityMode, int maxLength) {
        this.quoteMark = quoteMark;
        this.entityMode = entityMode;
        this.counter = new Counter(maxLength);
        this.builder = new StringBuilder(64);
        this.stack.push(new ValueWriter(this.builder, quoteMark, this.counter));
    }

    @Override
    public AnyValueWriter.EntityMode entityMode() {
        return this.entityMode;
    }

    @Override
    public void writeNodeReference(long nodeId) {
        this.append("(id=");
        this.append(String.valueOf(nodeId));
        this.append(")");
    }

    @Override
    public void writeNode(long nodeId, TextArray labels, MapValue properties, boolean ignored) {
        this.append("(id=");
        this.append(String.valueOf(nodeId));
        String sep = " ";
        for (int i = 0; i < labels.length(); ++i) {
            this.append(sep);
            this.append(":");
            this.append(labels.stringValue(i));
            sep = "";
        }
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append(")");
    }

    @Override
    public void writeRelationshipReference(long relId) {
        this.append("-[id=");
        this.append(String.valueOf(relId));
        this.append("]-");
    }

    @Override
    public void writeRelationship(long relId, long startNodeId, long endNodeId, TextValue type, MapValue properties, boolean ignored) {
        this.append("-[id=");
        this.append(String.valueOf(relId));
        this.append(" :");
        this.append(type.stringValue());
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append("]-");
    }

    @Override
    public void beginMap(int size) {
        assert (!this.stack.isEmpty());
        this.stack.peek().nest();
        this.stack.push(new MapWriter(this.builder, this.quoteMark, this.counter));
    }

    @Override
    public void endMap() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
        if (!this.stack.isEmpty()) {
            this.stack.peek().next();
        }
    }

    @Override
    public void beginList(int size) {
        assert (!this.stack.isEmpty());
        this.stack.peek().nest();
        this.stack.push(new ListWriter(this.builder, this.quoteMark, this.counter));
    }

    @Override
    public void endList() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
        if (!this.stack.isEmpty()) {
            this.stack.peek().next();
        }
    }

    @Override
    public void writePathReference(long[] nodes, long[] relationships) {
        if (nodes.length == 0) {
            return;
        }
        this.writeNodeReference(nodes[0]);
        for (int i = 0; i < relationships.length; ++i) {
            this.writeRelationshipReference(relationships[i]);
            this.append(">");
            this.writeNodeReference(nodes[i + 1]);
        }
    }

    @Override
    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        if (nodes.length == 0) {
            return;
        }
        nodes[0].writeTo(this);
        for (int i = 0; i < relationships.length; ++i) {
            relationships[i].writeTo(this);
            this.append(">");
            nodes[i + 1].writeTo(this);
        }
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
        this.append("{geometry: {type: \"Point\", coordinates: ");
        this.append(Arrays.toString(coordinate));
        this.append(", crs: {type: link, properties: {href: \"");
        this.append(crs.getHref());
        this.append("\", code: ");
        this.append(Integer.toString(crs.getCode()));
        this.append("}}}}");
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
        this.append("{duration: {months: ");
        this.append(Long.toString(months));
        this.append(", days: ");
        this.append(Long.toString(days));
        this.append(", seconds: ");
        this.append(Long.toString(seconds));
        this.append(", nanos: ");
        this.append(Long.toString(nanos));
        this.append("}}");
    }

    @Override
    public void writeDate(LocalDate localDate) throws RuntimeException {
        this.append("{date: ");
        this.appendQuoted(localDate.toString());
        this.append("}");
    }

    @Override
    public void writeLocalTime(LocalTime localTime) throws RuntimeException {
        this.append("{localTime: ");
        this.appendQuoted(localTime.toString());
        this.append("}");
    }

    @Override
    public void writeTime(OffsetTime offsetTime) throws RuntimeException {
        this.append("{time: ");
        this.appendQuoted(offsetTime.toString());
        this.append("}");
    }

    @Override
    public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
        this.append("{localDateTime: ");
        this.appendQuoted(localDateTime.toString());
        this.append("}");
    }

    @Override
    public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
        this.append("{datetime: ");
        this.appendQuoted(zonedDateTime.toString());
        this.append("}");
    }

    @Override
    public void writeNull() {
        this.append("<null>");
    }

    @Override
    public void writeBoolean(boolean value) {
        this.append(Boolean.toString(value));
    }

    @Override
    public void writeInteger(byte value) {
        this.append(Byte.toString(value));
    }

    @Override
    public void writeInteger(short value) {
        this.append(Short.toString(value));
    }

    @Override
    public void writeInteger(int value) {
        this.append(Integer.toString(value));
    }

    @Override
    public void writeInteger(long value) {
        this.append(Long.toString(value));
    }

    @Override
    public void writeFloatingPoint(float value) {
        this.append(Float.toString(value));
    }

    @Override
    public void writeFloatingPoint(double value) {
        this.append(Double.toString(value));
    }

    @Override
    public void writeString(String value) {
        this.appendQuoted(value);
    }

    @Override
    public void writeString(char value) {
        this.writeString(Character.toString(value));
    }

    @Override
    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        assert (!this.stack.isEmpty());
        this.stack.peek().nest();
        this.stack.push(new ListWriter(this.builder, this.quoteMark, this.counter));
    }

    @Override
    public void endArray() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
        if (!this.stack.isEmpty()) {
            this.stack.peek().next();
        }
    }

    @Override
    public void writeByteArray(byte[] value) {
        String sep = "";
        this.append("[");
        for (byte b : value) {
            this.append(sep);
            this.append(Byte.toString(b));
            sep = ", ";
        }
        this.append("]");
    }

    public String value() {
        assert (this.stack.size() == 1);
        this.stack.getLast().done();
        return this.builder.toString();
    }

    public void valueInto(StringBuilder target) {
        assert (this.stack.size() == 1);
        this.stack.getLast().done();
        target.append((CharSequence)this.builder);
    }

    private void append(String value) {
        if (this.counter.isDone()) {
            return;
        }
        assert (!this.stack.isEmpty());
        this.stack.peek().append(value);
    }

    private void appendQuoted(String value) {
        if (this.counter.isDone()) {
            return;
        }
        assert (!this.stack.isEmpty());
        this.stack.peek().appendQuoted(value);
    }

    private static final class Counter {
        private int count;

        Counter(int count) {
            this.count = count;
        }

        void decrement(int n) {
            this.count -= n;
        }

        int remaining() {
            return this.count;
        }

        public boolean isDone() {
            return this.count <= 0;
        }
    }

    private class ListWriter
    extends BaseWriter {
        private String sep;

        ListWriter(StringBuilder builder, String quoteMark, Counter counter2) {
            super(builder, quoteMark, counter2);
            this.sep = "";
            this.write("[");
        }

        @Override
        public void append(String value) {
            this.write(this.sep);
            this.write(value);
            this.sep = ", ";
        }

        @Override
        public void appendQuoted(String value) {
            this.write(this.sep);
            this.write(PrettyPrinter.this.quoteMark);
            this.write(value);
            this.write(PrettyPrinter.this.quoteMark);
            this.sep = ", ";
        }

        @Override
        public void done() {
            this.write("]");
        }

        @Override
        public void nest() {
            this.write(this.sep);
        }
    }

    private static class MapWriter
    extends BaseWriter {
        private boolean writeKey = true;
        private String sep = "";

        MapWriter(StringBuilder builder, String quoteMark, Counter counter2) {
            super(builder, quoteMark, counter2);
            this.write("{");
        }

        @Override
        public void append(String value) {
            if (this.writeKey) {
                this.write(this.sep);
                this.write(value);
                this.write(": ");
            } else {
                this.write(value);
            }
            this.writeKey = !this.writeKey;
            this.sep = ", ";
        }

        @Override
        public void appendQuoted(String value) {
            if (this.writeKey) {
                this.append(value);
            } else {
                super.appendQuoted(value);
            }
        }

        @Override
        public void next() {
            this.writeKey = true;
        }

        @Override
        public void done() {
            this.write("}");
        }
    }

    private static class ValueWriter
    extends BaseWriter {
        private ValueWriter(StringBuilder builder, String quoteMark, Counter counter2) {
            super(builder, quoteMark, counter2);
        }

        @Override
        public void append(String value) {
            this.write(value);
        }
    }

    private static abstract class BaseWriter
    implements Writer {
        protected final StringBuilder builder;
        protected Counter counter;
        private final String quoteMark;

        protected BaseWriter(StringBuilder builder, String quoteMark, Counter counter2) {
            this.builder = builder;
            this.quoteMark = quoteMark;
            this.counter = counter2;
        }

        @Override
        public void appendQuoted(String value) {
            this.write(this.quoteMark);
            this.append(value);
            this.write(this.quoteMark);
        }

        @Override
        public void next() {
        }

        @Override
        public void done() {
        }

        @Override
        public void nest() {
        }

        protected void write(String value) {
            int remaining = this.counter.remaining();
            if (remaining <= 0) {
                return;
            }
            if (remaining < value.length()) {
                this.builder.append(value, 0, remaining).append("...");
                this.counter.decrement(remaining);
            } else {
                this.builder.append(value);
                this.counter.decrement(value.length());
            }
        }
    }

    private static interface Writer {
        public void append(String var1);

        public void appendQuoted(String var1);

        public void next();

        public void done();

        public void nest();
    }
}

