-- $Id$ 

-- array parameters

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is 
	type byte is array(7 downto 0) of bit;
	function foo(constant a : byte) return bit;
end package t;

package body t is
	function foo(constant a : byte) return bit is
	begin
		return a(0);
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	x : process
		variable x : bit;
		variable b : byte;
	begin
		b := "01100011";
		x := foo(b);
		assert(b(0) = '1')
			report "b(0) should be '1'"
			severity failure;
		assert(x = '1') 
			report "foo(x) should return 1" 
			severity failure;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
