# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-22 23:40

from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import dojo.models
import multiselectfield.db.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Alerts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=100)),
                ('description', models.CharField(max_length=2000, null=True)),
                ('url', models.URLField(max_length=2000, null=True)),
                ('source', models.CharField(default='Generic', max_length=100)),
                ('icon', models.CharField(default='icon-user-check', max_length=25)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='App_Analysis',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('confidence', models.IntegerField(blank=True, null=True, verbose_name='Confidence level')),
                ('version', models.CharField(blank=True, max_length=200, null=True, verbose_name='Version Number')),
                ('icon', models.CharField(blank=True, max_length=200, null=True)),
                ('website', models.URLField(blank=True, max_length=400, null=True)),
                ('website_found', models.URLField(blank=True, max_length=400, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Benchmark_Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('objective', models.TextField()),
                ('references', models.TextField(blank=True, null=True)),
                ('enabled', models.BooleanField(default=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Benchmark_Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pass_fail', models.BooleanField(default=False, help_text='Does the product meet the requirement?', verbose_name='Pass')),
                ('enabled', models.BooleanField(default=True, help_text='Applicable for this specific product.')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Benchmark_Product_Summary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desired_level', models.CharField(choices=[('Level 1', 'Level 1'), ('Level 2', 'Level 2'), ('Level 3', 'Level 3')], default='Level 1', max_length=15)),
                ('current_level', models.CharField(blank=True, choices=[('Level 1', 'Level 1'), ('Level 2', 'Level 2'), ('Level 3', 'Level 3')], default='None', max_length=15, null=True)),
                ('asvs_level_1_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_1_score', models.IntegerField(default=0, help_text='ASVS Level 1 Score')),
                ('asvs_level_2_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_2_score', models.IntegerField(default=0, help_text='ASVS Level 2 Score')),
                ('asvs_level_3_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_3_score', models.IntegerField(default=0, help_text='ASVS Level 3 Score')),
                ('publish', models.BooleanField(default=False, help_text='Publish score to Product.')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Benchmark_Requirement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('objective_number', models.CharField(max_length=15, null=True)),
                ('objective', models.TextField()),
                ('references', models.TextField(blank=True, null=True)),
                ('level_1', models.BooleanField(default=False)),
                ('level_2', models.BooleanField(default=False)),
                ('level_3', models.BooleanField(default=False)),
                ('enabled', models.BooleanField(default=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Benchmark_Category')),
            ],
        ),
        migrations.CreateModel(
            name='Benchmark_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('version', models.CharField(max_length=15)),
                ('benchmark_source', models.CharField(choices=[('PCI', 'PCI'), ('OWASP ASVS', 'OWASP ASVS'), ('OWASP Mobile ASVS', 'OWASP Mobile ASVS')], default='OWASP ASVS', max_length=20, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('enabled', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='BurpRawRequestResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('burpRequestBase64', models.BinaryField()),
                ('burpResponseBase64', models.BinaryField()),
            ],
        ),
        migrations.CreateModel(
            name='Check_List',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_management', models.CharField(default='none', max_length=50)),
                ('encryption_crypto', models.CharField(default='none', max_length=50)),
                ('configuration_management', models.CharField(default='', max_length=50)),
                ('authentication', models.CharField(default='none', max_length=50)),
                ('authorization_and_access_control', models.CharField(default='none', max_length=50)),
                ('data_input_sanitization_validation', models.CharField(default='none', max_length=50)),
                ('sensitive_data', models.CharField(default='none', max_length=50)),
                ('other', models.CharField(default='none', max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Child_Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('Matches', 'Matches'), ('Contains', 'Contains')], max_length=30)),
                ('model_object', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('match_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence')], max_length=200)),
                ('match_text', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254)),
                ('team', models.CharField(max_length=100)),
                ('is_admin', models.BooleanField(default=False)),
                ('is_globally_read_only', models.BooleanField(default=False)),
                ('updated', models.DateTimeField(editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Cred_Mapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_authn_provider', models.BooleanField(default=False, verbose_name='Authentication Provider')),
                ('url', models.URLField(blank=True, max_length=2000, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Cred_User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('username', models.CharField(max_length=200)),
                ('password', models.CharField(max_length=600)),
                ('role', models.CharField(max_length=200)),
                ('authentication', models.CharField(choices=[('Form', 'Form Authentication'), ('SSO', 'SSO Redirect')], default='Form', max_length=15)),
                ('http_authentication', models.CharField(blank=True, choices=[('Basic', 'Basic'), ('NTLM', 'NTLM')], max_length=15, null=True)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.URLField(max_length=2000)),
                ('login_regex', models.CharField(blank=True, max_length=200, null=True)),
                ('logout_regex', models.CharField(blank=True, max_length=200, null=True)),
                ('is_valid', models.BooleanField(default=True, verbose_name='Login is valid')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='CWE',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=1000)),
                ('description', models.CharField(max_length=2000)),
                ('number', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Development_Environment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='DojoMeta',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=120)),
                ('value', models.CharField(max_length=300)),
            ],
        ),
        migrations.CreateModel(
            name='Endpoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('protocol', models.CharField(blank=True, help_text=b"The communication protocol such as 'http', 'ftp', etc.", max_length=10, null=True)),
                ('host', models.CharField(blank=True, help_text=b"The host name or IP address, you can also include the port number. For example'127.0.0.1', '127.0.0.1:8080', 'localhost', 'yourdomain.com'.", max_length=500, null=True)),
                ('fqdn', models.CharField(blank=True, max_length=500, null=True)),
                ('port', models.IntegerField(blank=True, help_text='The network port associated with the endpoint.', null=True)),
                ('path', models.CharField(blank=True, help_text=b"The location of the resource, it should start with a '/'. For example/endpoint/420/edit", max_length=500, null=True)),
                ('query', models.CharField(blank=True, help_text=b"The query string, the question mark should be omitted.For example 'group=4&team=8'", max_length=1000, null=True)),
                ('fragment', models.CharField(blank=True, help_text=b"The fragment identifier which follows the hash mark. The hash mark should be omitted. For example 'section-13', 'paragraph-2'.", max_length=500, null=True)),
            ],
            options={
                'ordering': ['product', 'protocol', 'host', 'path', 'query', 'fragment'],
            },
        ),
        migrations.CreateModel(
            name='Endpoint_Params',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('param', models.CharField(max_length=150)),
                ('value', models.CharField(max_length=150)),
                ('method', models.CharField(choices=[('GET', 'GET'), ('POST', 'POST')], max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Engagement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=300, null=True)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('version', models.CharField(blank=True, help_text='Version of the product the engagement tested.', max_length=100, null=True)),
                ('first_contacted', models.DateField(blank=True, null=True)),
                ('target_start', models.DateField()),
                ('target_end', models.DateField()),
                ('reason', models.CharField(blank=True, max_length=2000, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('active', models.BooleanField(default=True, editable=False)),
                ('tracker', models.URLField(blank=True, help_text='Link to epic or ticket system with changes to version.', null=True)),
                ('test_strategy', models.URLField(blank=True, null=True)),
                ('threat_model', models.BooleanField(default=True)),
                ('api_test', models.BooleanField(default=True)),
                ('pen_test', models.BooleanField(default=True)),
                ('check_list', models.BooleanField(default=True)),
                ('status', models.CharField(choices=[('Not Started', 'Not Started'), ('Blocked', 'Blocked'), ('Cancelled', 'Cancelled'), ('Completed', 'Completed'), ('In Progress', 'In Progress'), ('On Hold', 'On Hold'), ('Waiting for Resource', 'Waiting for Resource')], default='', max_length=2000, null=True)),
                ('progress', models.CharField(default='threat_model', editable=False, max_length=100)),
                ('tmodel_path', models.CharField(blank=True, default='none', editable=False, max_length=1000, null=True)),
                ('risk_path', models.CharField(blank=True, default='none', editable=False, max_length=1000, null=True)),
                ('done_testing', models.BooleanField(default=False, editable=False)),
                ('engagement_type', models.CharField(choices=[('Interactive', 'Interactive'), ('CI/CD', 'CI/CD')], default='Interactive', max_length=30, null=True)),
                ('build_id', models.CharField(blank=True, help_text='Build ID of the product the engagement tested.', max_length=150, null=True, verbose_name='Build ID')),
                ('commit_hash', models.CharField(blank=True, help_text='Commit hash from repo', max_length=150, null=True, verbose_name='Commit Hash')),
                ('branch_tag', models.CharField(blank=True, help_text='Tag or branch of the product the engagement tested.', max_length=150, null=True, verbose_name='Branch/Tag')),
                ('source_code_management_uri', models.CharField(blank=True, help_text='Resource link to source code', max_length=600, null=True, verbose_name='Repo')),
                ('deduplication_on_engagement', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-target_start'],
            },
        ),
        migrations.CreateModel(
            name='Engagement_Presets',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default=None, help_text='Brief description of preset.', max_length=500)),
                ('notes', models.CharField(blank=True, help_text='Description of what needs to be tested or setting up environment for testing', max_length=2000, null=True)),
                ('scope', models.CharField(blank=True, default=None, help_text=b"Scope of Engagement testing, IP's/Resources/URL's)", max_length=800)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='Engagement_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='FieldRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', models.CharField(max_length=200)),
                ('update_type', models.CharField(choices=[('Append', 'Append'), ('Replace', 'Replace')], max_length=30)),
                ('text', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Finding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('date', models.DateField(default=dojo.models.get_current_date)),
                ('cwe', models.IntegerField(blank=True, default=0, null=True)),
                ('url', models.TextField(blank=True, editable=False, null=True)),
                ('severity', models.CharField(help_text='The severity level of this flaw (Critical, High, Medium, Low, Informational)', max_length=200)),
                ('description', models.TextField()),
                ('mitigation', models.TextField()),
                ('impact', models.TextField()),
                ('steps_to_reproduce', models.TextField(blank=True, null=True)),
                ('severity_justification', models.TextField(blank=True, null=True)),
                ('references', models.TextField(blank=True, db_column='refs', null=True)),
                ('is_template', models.BooleanField(default=False)),
                ('active', models.BooleanField(default=True)),
                ('verified', models.BooleanField(default=True)),
                ('false_p', models.BooleanField(default=False, verbose_name='False Positive')),
                ('duplicate', models.BooleanField(default=False)),
                ('out_of_scope', models.BooleanField(default=False)),
                ('under_review', models.BooleanField(default=False)),
                ('under_defect_review', models.BooleanField(default=False)),
                ('thread_id', models.IntegerField(default=0, editable=False)),
                ('mitigated', models.DateTimeField(blank=True, editable=False, null=True)),
                ('numerical_severity', models.CharField(max_length=4)),
                ('last_reviewed', models.DateTimeField(editable=False, null=True)),
                ('line_number', models.CharField(blank=True, editable=False, max_length=200, null=True)),
                ('sourcefilepath', models.TextField(blank=True, editable=False, null=True)),
                ('sourcefile', models.TextField(blank=True, editable=False, null=True)),
                ('param', models.TextField(blank=True, editable=False, null=True)),
                ('payload', models.TextField(blank=True, editable=False, null=True)),
                ('hash_code', models.TextField(blank=True, null=True)),
                ('line', models.IntegerField(blank=True, null=True, verbose_name='Line number')),
                ('file_path', models.CharField(blank=True, max_length=1000, null=True)),
                ('static_finding', models.BooleanField(default=False)),
                ('dynamic_finding', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('scanner_confidence', models.IntegerField(blank=True, default=None, editable=False, help_text='Confidence level of vulnerability which is supplied by the scannner.', null=True)),
            ],
            options={
                'ordering': ('numerical_severity', '-date', 'title'),
            },
        ),
        migrations.CreateModel(
            name='Finding_Template',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('cwe', models.IntegerField(blank=True, default=None, null=True)),
                ('severity', models.CharField(blank=True, max_length=200, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('mitigation', models.TextField(blank=True, null=True)),
                ('impact', models.TextField(blank=True, null=True)),
                ('references', models.TextField(blank=True, db_column='refs', null=True)),
                ('numerical_severity', models.CharField(blank=True, editable=False, max_length=4, null=True)),
                ('template_match', models.BooleanField(default=False, help_text='Enables this template for matching remediation advice. Match will be applied to all active, verified findings by CWE.', verbose_name='Template Match Enabled')),
                ('template_match_title', models.BooleanField(default=False, help_text='Matches by title text (contains search) and CWE.', verbose_name='Match Template by Title and CWE')),
            ],
            options={
                'ordering': ['-cwe'],
            },
        ),
        migrations.CreateModel(
            name='FindingImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(null=True, upload_to='finding_images')),
            ],
        ),
        migrations.CreateModel(
            name='FindingImageAccessToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=255)),
                ('size', models.CharField(choices=[('small', 'Small'), ('medium', 'Medium'), ('large', 'Large'), ('thumbnail', 'Thumbnail'), ('original', 'Original')], default='medium', max_length=9)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.FindingImage')),
            ],
        ),
        migrations.CreateModel(
            name='IPScan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.TextField(default='none', editable=False)),
                ('services', models.CharField(max_length=800, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Clone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200)),
                ('jira_clone_id', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Conf',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(help_text='For more information how to configure Jira, read the DefectDojo documentation.', max_length=2000, verbose_name='JIRA URL')),
                ('username', models.CharField(max_length=2000)),
                ('password', models.CharField(max_length=2000)),
                ('default_issue_type', models.CharField(choices=[('Task', 'Task'), ('Story', 'Story'), ('Epic', 'Epic'), ('Spike', 'Spike'), ('Bug', 'Bug')], default='Bug', max_length=9)),
                ('epic_name_id', models.IntegerField(help_text=b"To obtain the 'Epic name id' visit https://<YOUR JIRA URL>/rest/api/2/field and search for Epic Name. Copy the number out of cf[number] and paste it here.")),
                ('open_status_key', models.IntegerField(help_text=b"Transition ID to Re-Open JIRA issues, visit https://<YOUR JIRA URL>/rest/api/latest/issue/<ANY VALID ISSUE KEY>/transitions?expand=transitions.fields to find the ID for your JIRA instance")),
                ('close_status_key', models.IntegerField(help_text=b"Transition ID to Close JIRA issues, visit https://<YOUR JIRA URL>/rest/api/latest/issue/<ANY VALID ISSUE KEY>/transitions?expand=transitions.fields to find the ID for your JIRA instance")),
                ('low_mapping_severity', models.CharField(help_text=b"Maps to the 'Priority' field in Jira. For example: Low", max_length=200)),
                ('medium_mapping_severity', models.CharField(help_text=b"Maps to the 'Priority' field in Jira. For example: Medium", max_length=200)),
                ('high_mapping_severity', models.CharField(help_text=b"Maps to the 'Priority' field in Jira. For example: High", max_length=200)),
                ('critical_mapping_severity', models.CharField(help_text=b"Maps to the 'Priority' field in Jira. For example: Critical", max_length=200)),
                ('finding_text', models.TextField(blank=True, help_text='Additional text that will be added to the finding in Jira. For example including how the finding was created or who to contact for more information.', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Details_Cache',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200)),
                ('jira_key', models.CharField(max_length=200)),
                ('jira_status', models.CharField(max_length=200)),
                ('jira_resolution', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200, unique=True)),
                ('jira_key', models.CharField(max_length=200)),
                ('engagement', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Engagement')),
                ('finding', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Finding')),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_PKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_key', models.CharField(blank=True, max_length=200)),
                ('component', models.CharField(blank=True, max_length=200)),
                ('push_all_issues', models.BooleanField(default=False)),
                ('enable_engagement_epic_mapping', models.BooleanField(default=False)),
                ('push_notes', models.BooleanField(default=False)),
                ('conf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.JIRA_Conf', verbose_name='JIRA Configuration')),
            ],
        ),
        migrations.CreateModel(
            name='Language_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=100)),
                ('color', models.CharField(max_length=7, null=True, verbose_name='HTML color')),
            ],
        ),
        migrations.CreateModel(
            name='Languages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('files', models.IntegerField(blank=True, null=True, verbose_name='Number of files')),
                ('blank', models.IntegerField(blank=True, null=True, verbose_name='Number of blank lines')),
                ('comment', models.IntegerField(blank=True, null=True, verbose_name='Number of comment lines')),
                ('code', models.IntegerField(blank=True, null=True, verbose_name='Number of code lines')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Language_Type')),
            ],
        ),
        migrations.CreateModel(
            name='Network_Locations',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('location', models.CharField(help_text='Location of network testing: Examples: VPN, Internet or Internal.', max_length=500)),
            ],
        ),
        migrations.CreateModel(
            name='Notes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('entry', models.TextField()),
                ('date', models.DateTimeField(default=dojo.models.get_current_datetime, editable=False)),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Notifications',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('engagement_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('test_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('results_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('report_created', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('jira_update', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('upcoming_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('stale_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('auto_close_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('user_mentioned', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('code_review', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('review_requested', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('other', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
            ],
        ),
        migrations.CreateModel(
            name='Objects',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('path', models.CharField(blank=True, max_length=600, null=True, verbose_name='Full file path')),
                ('folder', models.CharField(blank=True, max_length=400, null=True, verbose_name='Folder')),
                ('artifact', models.CharField(blank=True, max_length=400, null=True, verbose_name='Artifact')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Objects_Engagement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('build_id', models.CharField(max_length=150, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('full_url', models.URLField(blank=True, max_length=400, null=True)),
                ('type', models.CharField(max_length=30, null=True)),
                ('percentUnchanged', models.CharField(max_length=10, null=True)),
                ('engagement', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Engagement')),
                ('object_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Objects')),
            ],
        ),
        migrations.CreateModel(
            name='Objects_Review',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(max_length=4000)),
                ('prod_manager', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('tech_contact', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('manager', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('created', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated', models.DateTimeField(blank=True, editable=False, null=True)),
                ('tid', models.IntegerField(default=0, editable=False)),
                ('prod_numeric_grade', models.IntegerField(blank=True, null=True)),
                ('business_criticality', models.CharField(blank=True, choices=[('very high', 'Very High'), ('high', 'High'), ('medium', 'Medium'), ('low', 'Low'), ('very low', 'Very Low'), ('none', 'None')], max_length=9, null=True)),
                ('platform', models.CharField(blank=True, choices=[('web service', 'API'), ('desktop', 'Desktop'), ('iot', 'Internet of Things'), ('mobile', 'Mobile'), ('we', 'We')], max_length=11, null=True)),
                ('lifecycle', models.CharField(blank=True, choices=[('construction', 'Construction'), ('production', 'Production'), ('retirement', 'Retirement')], max_length=12, null=True)),
                ('origin', models.CharField(blank=True, choices=[('third party library', 'Third Party Library'), ('purchased', 'Purchased'), ('contractor', 'Contractor Developed'), ('internal', 'Internally Developed'), ('open source', 'Open Source'), ('outsourced', 'Outsourced')], max_length=19, null=True)),
                ('user_records', models.PositiveIntegerField(blank=True, help_text='Estimate the number of user records within the application.', null=True)),
                ('revenue', models.DecimalField(blank=True, decimal_places=2, help_text=b"Estimate the application's revenue.", max_digits=15, null=True)),
                ('external_audience', models.BooleanField(default=False, help_text='Specify if the application is used by people outside the organization.')),
                ('internet_accessible', models.BooleanField(default=False, help_text='Specify if the application is accessible from the public internet.')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Product_Line',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('description', models.CharField(max_length=2000)),
            ],
        ),
        migrations.CreateModel(
            name='Product_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('critical_product', models.BooleanField(default=False)),
                ('key_product', models.BooleanField(default=False)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Regulation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of the legislation.', max_length=128)),
                ('acronym', models.CharField(help_text='A shortened representation of the name.', max_length=20, unique=True)),
                ('category', models.CharField(choices=[('privacy', 'Privacy'), ('finance', 'Finance'), ('education', 'Education'), ('medical', 'Medical'), ('other', 'Other')], help_text='The subject of the regulation.', max_length=9)),
                ('jurisdiction', models.CharField(help_text='The territory over which the regulation applies.', max_length=64)),
                ('description', models.TextField(blank=True, help_text=b"Information about the regulation's purpose.")),
                ('reference', models.URLField(blank=True, help_text='An external URL for more information.')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Report',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('type', models.CharField(default='Finding', max_length=100)),
                ('format', models.CharField(default='AsciiDoc', max_length=15)),
                ('task_id', models.CharField(max_length=50)),
                ('file', models.FileField(null=True, upload_to='reports/%Y/%m/%d', verbose_name='Report File')),
                ('status', models.CharField(default='requested', max_length=10)),
                ('options', models.TextField()),
                ('datetime', models.DateTimeField(auto_now_add=True)),
                ('done_datetime', models.DateTimeField(null=True)),
            ],
            options={
                'ordering': ['-datetime'],
            },
        ),
        migrations.CreateModel(
            name='Report_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Risk_Acceptance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.FileField(editable=False, upload_to='risk/%Y/%m/%d', verbose_name='Risk Acceptance File')),
                ('expiration_date', models.DateTimeField(blank=True, default=None, null=True)),
                ('accepted_by', models.CharField(blank=True, default=None, help_text='The entity or person that accepts the risk.', max_length=200, null=True, verbose_name='Accepted By')),
                ('compensating_control', models.TextField(blank=True, default=None, help_text='If a compensating control exists to mitigate the finding or reduce risk, then list the compensating control(s).', null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('accepted_findings', models.ManyToManyField(to='dojo.Finding')),
                ('notes', models.ManyToManyField(editable=False, to='dojo.Notes')),
            ],
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('enabled', models.BooleanField(default=True)),
                ('text', models.TextField()),
                ('operator', models.CharField(choices=[('Matches', 'Matches'), ('Contains', 'Contains')], max_length=30)),
                ('model_object', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('match_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence')], max_length=200)),
                ('match_text', models.TextField()),
                ('application', models.CharField(choices=[('Append', 'Append'), ('Replace', 'Replace')], max_length=200)),
                ('applies_to', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('applied_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence')], max_length=200)),
                ('child_rules', models.ManyToManyField(editable=False, related_name='_rule_child_rules_+', to='dojo.Rule')),
                ('parent_rule', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Rule')),
            ],
        ),
        migrations.CreateModel(
            name='Scan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(blank=True, default=dojo.models.get_current_datetime, editable=False)),
                ('protocol', models.CharField(default='TCP', max_length=10)),
                ('status', models.CharField(default='Pending', editable=False, max_length=10)),
                ('baseline', models.BooleanField(default=False, verbose_name='Current Baseline')),
            ],
        ),
        migrations.CreateModel(
            name='ScanSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('addresses', models.TextField(default='none')),
                ('date', models.DateTimeField(blank=True, default=dojo.models.get_current_datetime, editable=False)),
                ('frequency', models.CharField(blank=True, max_length=10000, null=True)),
                ('email', models.CharField(max_length=512)),
                ('protocol', models.CharField(default='TCP', max_length=10)),
                ('product', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Product')),
            ],
        ),
        migrations.CreateModel(
            name='Stub_Finding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('date', models.DateField(default=dojo.models.get_current_date)),
                ('severity', models.CharField(blank=True, max_length=200, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ('-date', 'title'),
            },
        ),
        migrations.CreateModel(
            name='System_Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enable_deduplication', models.BooleanField(default=False, help_text='With this setting turned on, Dojo deduplicates findings by comparing endpoints, cwe fields, and titles. If two findings share a URL and have the same CWE or title, Dojo marks the less recent finding as a duplicate. When deduplication is enabled, a list of deduplicated findings is added to the engagement view.', verbose_name='Deduplicate findings')),
                ('delete_dupulicates', models.BooleanField(default=False)),
                ('max_dupes', models.IntegerField(blank=True, help_text='When enabled, if a single issue reaches the maximum number of duplicates, the oldest will be deleted.', null=True, verbose_name='Max Duplicates')),
                ('enable_jira', models.BooleanField(default=False, verbose_name='Enable JIRA integration')),
                ('enable_jira_web_hook', models.BooleanField(default=False, verbose_name='Enable JIRA web hook. Please note: It is strongly recommended to whitelist the Jira server using a proxy such as Nginx.')),
                ('jira_minimum_severity', models.CharField(blank=True, choices=[('Critical', 'Critical'), ('High', 'High'), ('Medium', 'Medium'), ('Low', 'Low')], default='None', max_length=20, null=True)),
                ('jira_labels', models.CharField(blank=True, help_text='JIRA issue labels space seperated', max_length=200, null=True)),
                ('enable_slack_notifications', models.BooleanField(default=False, verbose_name='Enable Slack notifications')),
                ('slack_channel', models.CharField(blank=True, default='', max_length=100)),
                ('slack_token', models.CharField(blank=True, default='', help_text='Token required for interacting with Slack. Get one at https://api.slack.com/tokens', max_length=100)),
                ('slack_username', models.CharField(blank=True, default='', max_length=100)),
                ('enable_hipchat_notifications', models.BooleanField(default=False, verbose_name='Enable HipChat notifications')),
                ('hipchat_site', models.CharField(blank=True, default='', help_text='The full fqdn of your hipchat site, e.g. "yoursite.hipchat.com"', max_length=100)),
                ('hipchat_channel', models.CharField(blank=True, default='', max_length=100)),
                ('hipchat_token', models.CharField(blank=True, default='', help_text='Token required for interacting with HipChat. Get one at https://patriktest.hipchat.com/addons/', max_length=100)),
                ('enable_mail_notifications', models.BooleanField(default=False)),
                ('mail_notifications_from', models.CharField(blank=True, default='from@example.com', max_length=200)),
                ('mail_notifications_to', models.CharField(blank=True, default='', max_length=200)),
                ('s_finding_severity_naming', models.BooleanField(default=False, help_text='With this setting turned on, Dojo will display S0, S1, S2, etc in most places, whereas if turned off Critical, High, Medium, etc will be displayed.')),
                ('false_positive_history', models.BooleanField(default=False, help_text='DefectDojo will automatically mark the finding as a false positive if the finding has been previously marked as a false positive.')),
                ('url_prefix', models.CharField(blank=True, default='', help_text=b"URL prefix if DefectDojo is installed in it's own virtual subdirectory.", max_length=300)),
                ('team_name', models.CharField(blank=True, default='', max_length=100)),
                ('time_zone', models.CharField(choices=[('Africa/Abidjan', 'Africa/Abidjan'), ('Africa/Accra', 'Africa/Accra'), ('Africa/Addis_Ababa', 'Africa/Addis_Ababa'), ('Africa/Algiers', 'Africa/Algiers'), ('Africa/Asmara', 'Africa/Asmara'), ('Africa/Asmera', 'Africa/Asmera'), ('Africa/Bamako', 'Africa/Bamako'), ('Africa/Bangui', 'Africa/Bangui'), ('Africa/Banjul', 'Africa/Banjul'), ('Africa/Bissau', 'Africa/Bissau'), ('Africa/Blantyre', 'Africa/Blantyre'), ('Africa/Brazzaville', 'Africa/Brazzaville'), ('Africa/Bujumbura', 'Africa/Bujumbura'), ('Africa/Cairo', 'Africa/Cairo'), ('Africa/Casablanca', 'Africa/Casablanca'), ('Africa/Ceuta', 'Africa/Ceuta'), ('Africa/Conakry', 'Africa/Conakry'), ('Africa/Dakar', 'Africa/Dakar'), ('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam'), ('Africa/Djibouti', 'Africa/Djibouti'), ('Africa/Douala', 'Africa/Douala'), ('Africa/El_Aaiun', 'Africa/El_Aaiun'), ('Africa/Freetown', 'Africa/Freetown'), ('Africa/Gaborone', 'Africa/Gaborone'), ('Africa/Harare', 'Africa/Harare'), ('Africa/Johannesburg', 'Africa/Johannesburg'), ('Africa/Juba', 'Africa/Juba'), ('Africa/Kampala', 'Africa/Kampala'), ('Africa/Khartoum', 'Africa/Khartoum'), ('Africa/Kigali', 'Africa/Kigali'), ('Africa/Kinshasa', 'Africa/Kinshasa'), ('Africa/Lagos', 'Africa/Lagos'), ('Africa/Libreville', 'Africa/Libreville'), ('Africa/Lome', 'Africa/Lome'), ('Africa/Luanda', 'Africa/Luanda'), ('Africa/Lubumbashi', 'Africa/Lubumbashi'), ('Africa/Lusaka', 'Africa/Lusaka'), ('Africa/Malabo', 'Africa/Malabo'), ('Africa/Maputo', 'Africa/Maputo'), ('Africa/Maseru', 'Africa/Maseru'), ('Africa/Mbabane', 'Africa/Mbabane'), ('Africa/Mogadishu', 'Africa/Mogadishu'), ('Africa/Monrovia', 'Africa/Monrovia'), ('Africa/Nairobi', 'Africa/Nairobi'), ('Africa/Ndjamena', 'Africa/Ndjamena'), ('Africa/Niamey', 'Africa/Niamey'), ('Africa/Nouakchott', 'Africa/Nouakchott'), ('Africa/Ouagadougou', 'Africa/Ouagadougou'), ('Africa/Porto-Novo', 'Africa/Porto-Novo'), ('Africa/Sao_Tome', 'Africa/Sao_Tome'), ('Africa/Timbuktu', 'Africa/Timbuktu'), ('Africa/Tripoli', 'Africa/Tripoli'), ('Africa/Tunis', 'Africa/Tunis'), ('Africa/Windhoek', 'Africa/Windhoek'), ('America/Adak', 'America/Adak'), ('America/Anchorage', 'America/Anchorage'), ('America/Anguilla', 'America/Anguilla'), ('America/Antigua', 'America/Antigua'), ('America/Araguaina', 'America/Araguaina'), ('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos_Aires'), ('America/Argentina/Catamarca', 'America/Argentina/Catamarca'), ('America/Argentina/ComodRivadavia', 'America/Argentina/ComodRivadavia'), ('America/Argentina/Cordoba', 'America/Argentina/Cordoba'), ('America/Argentina/Jujuy', 'America/Argentina/Jujuy'), ('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja'), ('America/Argentina/Mendoza', 'America/Argentina/Mendoza'), ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos'), ('America/Argentina/Salta', 'America/Argentina/Salta'), ('America/Argentina/San_Juan', 'America/Argentina/San_Juan'), ('America/Argentina/San_Luis', 'America/Argentina/San_Luis'), ('America/Argentina/Tucuman', 'America/Argentina/Tucuman'), ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia'), ('America/Aruba', 'America/Aruba'), ('America/Asuncion', 'America/Asuncion'), ('America/Atikokan', 'America/Atikokan'), ('America/Atka', 'America/Atka'), ('America/Bahia', 'America/Bahia'), ('America/Bahia_Banderas', 'America/Bahia_Banderas'), ('America/Barbados', 'America/Barbados'), ('America/Belem', 'America/Belem'), ('America/Belize', 'America/Belize'), ('America/Blanc-Sablon', 'America/Blanc-Sablon'), ('America/Boa_Vista', 'America/Boa_Vista'), ('America/Bogota', 'America/Bogota'), ('America/Boise', 'America/Boise'), ('America/Buenos_Aires', 'America/Buenos_Aires'), ('America/Cambridge_Bay', 'America/Cambridge_Bay'), ('America/Campo_Grande', 'America/Campo_Grande'), ('America/Cancun', 'America/Cancun'), ('America/Caracas', 'America/Caracas'), ('America/Catamarca', 'America/Catamarca'), ('America/Cayenne', 'America/Cayenne'), ('America/Cayman', 'America/Cayman'), ('America/Chicago', 'America/Chicago'), ('America/Chihuahua', 'America/Chihuahua'), ('America/Coral_Harbour', 'America/Coral_Harbour'), ('America/Cordoba', 'America/Cordoba'), ('America/Costa_Rica', 'America/Costa_Rica'), ('America/Creston', 'America/Creston'), ('America/Cuiaba', 'America/Cuiaba'), ('America/Curacao', 'America/Curacao'), ('America/Danmarkshavn', 'America/Danmarkshavn'), ('America/Dawson', 'America/Dawson'), ('America/Dawson_Creek', 'America/Dawson_Creek'), ('America/Denver', 'America/Denver'), ('America/Detroit', 'America/Detroit'), ('America/Dominica', 'America/Dominica'), ('America/Edmonton', 'America/Edmonton'), ('America/Eirunepe', 'America/Eirunepe'), ('America/El_Salvador', 'America/El_Salvador'), ('America/Ensenada', 'America/Ensenada'), ('America/Fort_Nelson', 'America/Fort_Nelson'), ('America/Fort_Wayne', 'America/Fort_Wayne'), ('America/Fortaleza', 'America/Fortaleza'), ('America/Glace_Bay', 'America/Glace_Bay'), ('America/Godtha', 'America/Godtha'), ('America/Goose_Bay', 'America/Goose_Bay'), ('America/Grand_Turk', 'America/Grand_Turk'), ('America/Grenada', 'America/Grenada'), ('America/Guadeloupe', 'America/Guadeloupe'), ('America/Guatemala', 'America/Guatemala'), ('America/Guayaquil', 'America/Guayaquil'), ('America/Guyana', 'America/Guyana'), ('America/Halifax', 'America/Halifax'), ('America/Havana', 'America/Havana'), ('America/Hermosillo', 'America/Hermosillo'), ('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis'), ('America/Indiana/Knox', 'America/Indiana/Knox'), ('America/Indiana/Marengo', 'America/Indiana/Marengo'), ('America/Indiana/Petersburg', 'America/Indiana/Petersburg'), ('America/Indiana/Tell_City', 'America/Indiana/Tell_City'), ('America/Indiana/Vevay', 'America/Indiana/Vevay'), ('America/Indiana/Vincennes', 'America/Indiana/Vincennes'), ('America/Indiana/Winamac', 'America/Indiana/Winamac'), ('America/Indianapolis', 'America/Indianapolis'), ('America/Inuvik', 'America/Inuvik'), ('America/Iqaluit', 'America/Iqaluit'), ('America/Jamaica', 'America/Jamaica'), ('America/Jujuy', 'America/Jujuy'), ('America/Juneau', 'America/Juneau'), ('America/Kentucky/Louisville', 'America/Kentucky/Louisville'), ('America/Kentucky/Monticello', 'America/Kentucky/Monticello'), ('America/Knox_IN', 'America/Knox_IN'), ('America/Kralendijk', 'America/Kralendijk'), ('America/La_Paz', 'America/La_Paz'), ('America/Lima', 'America/Lima'), ('America/Los_Angeles', 'America/Los_Angeles'), ('America/Louisville', 'America/Louisville'), ('America/Lower_Princes', 'America/Lower_Princes'), ('America/Maceio', 'America/Maceio'), ('America/Managua', 'America/Managua'), ('America/Manaus', 'America/Manaus'), ('America/Marigot', 'America/Marigot'), ('America/Martinique', 'America/Martinique'), ('America/Matamoros', 'America/Matamoros'), ('America/Mazatlan', 'America/Mazatlan'), ('America/Mendoza', 'America/Mendoza'), ('America/Menominee', 'America/Menominee'), ('America/Merida', 'America/Merida'), ('America/Metlakatla', 'America/Metlakatla'), ('America/Mexico_City', 'America/Mexico_City'), ('America/Miquelon', 'America/Miquelon'), ('America/Moncton', 'America/Moncton'), ('America/Monterrey', 'America/Monterrey'), ('America/Montevideo', 'America/Montevideo'), ('America/Montreal', 'America/Montreal'), ('America/Montserrat', 'America/Montserrat'), ('America/Nassau', 'America/Nassau'), ('America/New_York', 'America/New_York'), ('America/Nipigon', 'America/Nipigon'), ('America/Nome', 'America/Nome'), ('America/Noronha', 'America/Noronha'), ('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah'), ('America/North_Dakota/Center', 'America/North_Dakota/Center'), ('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem'), ('America/Ojinaga', 'America/Ojinaga'), ('America/Panama', 'America/Panama'), ('America/Pangnirtung', 'America/Pangnirtung'), ('America/Paramaribo', 'America/Paramaribo'), ('America/Phoenix', 'America/Phoenix'), ('America/Port-au-Prince', 'America/Port-au-Prince'), ('America/Port_of_Spain', 'America/Port_of_Spain'), ('America/Porto_Acre', 'America/Porto_Acre'), ('America/Porto_Velho', 'America/Porto_Velho'), ('America/Puerto_Rico', 'America/Puerto_Rico'), ('America/Punta_Arenas', 'America/Punta_Arenas'), ('America/Rainy_River', 'America/Rainy_River'), ('America/Rankin_Inlet', 'America/Rankin_Inlet'), ('America/Recife', 'America/Recife'), ('America/Regina', 'America/Regina'), ('America/Resolute', 'America/Resolute'), ('America/Rio_Branco', 'America/Rio_Branco'), ('America/Rosario', 'America/Rosario'), ('America/Santa_Isabel', 'America/Santa_Isabel'), ('America/Santarem', 'America/Santarem'), ('America/Santiago', 'America/Santiago'), ('America/Santo_Domingo', 'America/Santo_Domingo'), ('America/Sao_Paulo', 'America/Sao_Paulo'), ('America/Scoresbysund', 'America/Scoresbysund'), ('America/Shiprock', 'America/Shiprock'), ('America/Sitka', 'America/Sitka'), ('America/St_Barthelemy', 'America/St_Barthelemy'), ('America/St_Johns', 'America/St_Johns'), ('America/St_Kitts', 'America/St_Kitts'), ('America/St_Lucia', 'America/St_Lucia'), ('America/St_Thomas', 'America/St_Thomas'), ('America/St_Vincent', 'America/St_Vincent'), ('America/Swift_Current', 'America/Swift_Current'), ('America/Tegucigalpa', 'America/Tegucigalpa'), ('America/Thule', 'America/Thule'), ('America/Thunder_Bay', 'America/Thunder_Bay'), ('America/Tijuana', 'America/Tijuana'), ('America/Toronto', 'America/Toronto'), ('America/Tortola', 'America/Tortola'), ('America/Vancouver', 'America/Vancouver'), ('America/Virgin', 'America/Virgin'), ('America/Whitehorse', 'America/Whitehorse'), ('America/Winnipeg', 'America/Winnipeg'), ('America/Yakutat', 'America/Yakutat'), ('America/Yellowknife', 'America/Yellowknife'), ('Antarctica/Casey', 'Antarctica/Casey'), ('Antarctica/Davis', 'Antarctica/Davis'), ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville'), ('Antarctica/Macquarie', 'Antarctica/Macquarie'), ('Antarctica/Mawson', 'Antarctica/Mawson'), ('Antarctica/McMurdo', 'Antarctica/McMurdo'), ('Antarctica/Palmer', 'Antarctica/Palmer'), ('Antarctica/Rothera', 'Antarctica/Rothera'), ('Antarctica/South_Pole', 'Antarctica/South_Pole'), ('Antarctica/Syowa', 'Antarctica/Syowa'), ('Antarctica/Troll', 'Antarctica/Troll'), ('Antarctica/Vostok', 'Antarctica/Vostok'), ('Arctic/Longyearbyen', 'Arctic/Longyearbyen'), ('Asia/Aden', 'Asia/Aden'), ('Asia/Almaty', 'Asia/Almaty'), ('Asia/Amman', 'Asia/Amman'), ('Asia/Anadyr', 'Asia/Anadyr'), ('Asia/Aqtau', 'Asia/Aqtau'), ('Asia/Aqtobe', 'Asia/Aqtobe'), ('Asia/Ashgabat', 'Asia/Ashgabat'), ('Asia/Ashkhabad', 'Asia/Ashkhabad'), ('Asia/Atyrau', 'Asia/Atyrau'), ('Asia/Baghdad', 'Asia/Baghdad'), ('Asia/Bahrain', 'Asia/Bahrain'), ('Asia/Baku', 'Asia/Baku'), ('Asia/Bangkok', 'Asia/Bangkok'), ('Asia/Barnaul', 'Asia/Barnaul'), ('Asia/Beirut', 'Asia/Beirut'), ('Asia/Bishkek', 'Asia/Bishkek'), ('Asia/Brunei', 'Asia/Brunei'), ('Asia/Calcutta', 'Asia/Calcutta'), ('Asia/Chita', 'Asia/Chita'), ('Asia/Choibalsan', 'Asia/Choibalsan'), ('Asia/Chongqing', 'Asia/Chongqing'), ('Asia/Chungking', 'Asia/Chungking'), ('Asia/Colombo', 'Asia/Colombo'), ('Asia/Dacca', 'Asia/Dacca'), ('Asia/Damascus', 'Asia/Damascus'), ('Asia/Dhaka', 'Asia/Dhaka'), ('Asia/Dili', 'Asia/Dili'), ('Asia/Dubai', 'Asia/Dubai'), ('Asia/Dushanbe', 'Asia/Dushanbe'), ('Asia/Famagusta', 'Asia/Famagusta'), ('Asia/Gaza', 'Asia/Gaza'), ('Asia/Harbin', 'Asia/Harbin'), ('Asia/Hebron', 'Asia/Hebron'), ('Asia/Ho_Chi_Minh', 'Asia/Ho_Chi_Minh'), ('Asia/Hong_Kong', 'Asia/Hong_Kong'), ('Asia/Hovd', 'Asia/Hovd'), ('Asia/Irkutsk', 'Asia/Irkutsk'), ('Asia/Istanbul', 'Asia/Istanbul'), ('Asia/Jakarta', 'Asia/Jakarta'), ('Asia/Jayapura', 'Asia/Jayapura'), ('Asia/Jerusalem', 'Asia/Jerusalem'), ('Asia/Kabul', 'Asia/Kabul'), ('Asia/Kamchatka', 'Asia/Kamchatka'), ('Asia/Karachi', 'Asia/Karachi'), ('Asia/Kashgar', 'Asia/Kashgar'), ('Asia/Kathmandu', 'Asia/Kathmandu'), ('Asia/Katmandu', 'Asia/Katmandu'), ('Asia/Khandyga', 'Asia/Khandyga'), ('Asia/Kolkata', 'Asia/Kolkata'), ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk'), ('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur'), ('Asia/Kuching', 'Asia/Kuching'), ('Asia/Kuwait', 'Asia/Kuwait'), ('Asia/Macao', 'Asia/Macao'), ('Asia/Macau', 'Asia/Macau'), ('Asia/Magadan', 'Asia/Magadan'), ('Asia/Makassar', 'Asia/Makassar'), ('Asia/Manila', 'Asia/Manila'), ('Asia/Muscat', 'Asia/Muscat'), ('Asia/Nicosia', 'Asia/Nicosia'), ('Asia/Novokuznetsk', 'Asia/Novokuznetsk'), ('Asia/Novosibirsk', 'Asia/Novosibirsk'), ('Asia/Omsk', 'Asia/Omsk'), ('Asia/Oral', 'Asia/Oral'), ('Asia/Phnom_Penh', 'Asia/Phnom_Penh'), ('Asia/Pontianak', 'Asia/Pontianak'), ('Asia/Pyongyang', 'Asia/Pyongyang'), ('Asia/Qatar', 'Asia/Qatar'), ('Asia/Qyzylorda', 'Asia/Qyzylorda'), ('Asia/Rangoon', 'Asia/Rangoon'), ('Asia/Riyadh', 'Asia/Riyadh'), ('Asia/Saigon', 'Asia/Saigon'), ('Asia/Sakhalin', 'Asia/Sakhalin'), ('Asia/Samarkand', 'Asia/Samarkand'), ('Asia/Seoul', 'Asia/Seoul'), ('Asia/Shanghai', 'Asia/Shanghai'), ('Asia/Singapore', 'Asia/Singapore'), ('Asia/Srednekolymsk', 'Asia/Srednekolymsk'), ('Asia/Taipei', 'Asia/Taipei'), ('Asia/Tashkent', 'Asia/Tashkent'), ('Asia/Tbilisi', 'Asia/Tbilisi'), ('Asia/Tehran', 'Asia/Tehran'), ('Asia/Tel_Aviv', 'Asia/Tel_Aviv'), ('Asia/Thimbu', 'Asia/Thimbu'), ('Asia/Thimphu', 'Asia/Thimphu'), ('Asia/Tokyo', 'Asia/Tokyo'), ('Asia/Tomsk', 'Asia/Tomsk'), ('Asia/Ujung_Pandang', 'Asia/Ujung_Pandang'), ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar'), ('Asia/Ulan_Bator', 'Asia/Ulan_Bator'), ('Asia/Urumqi', 'Asia/Urumqi'), ('Asia/Ust-Nera', 'Asia/Ust-Nera'), ('Asia/Vientiane', 'Asia/Vientiane'), ('Asia/Vladivostok', 'Asia/Vladivostok'), ('Asia/Yakutsk', 'Asia/Yakutsk'), ('Asia/Yangon', 'Asia/Yangon'), ('Asia/Yekaterinburg', 'Asia/Yekaterinburg'), ('Asia/Yerevan', 'Asia/Yerevan'), ('Atlantic/Azores', 'Atlantic/Azores'), ('Atlantic/Bermuda', 'Atlantic/Bermuda'), ('Atlantic/Canary', 'Atlantic/Canary'), ('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde'), ('Atlantic/Faeroe', 'Atlantic/Faeroe'), ('Atlantic/Faroe', 'Atlantic/Faroe'), ('Atlantic/Jan_Mayen', 'Atlantic/Jan_Mayen'), ('Atlantic/Madeira', 'Atlantic/Madeira'), ('Atlantic/Reykjavik', 'Atlantic/Reykjavik'), ('Atlantic/South_Georgia', 'Atlantic/South_Georgia'), ('Atlantic/St_Helena', 'Atlantic/St_Helena'), ('Atlantic/Stanley', 'Atlantic/Stanley'), ('Australia/ACT', 'Australia/ACT'), ('Australia/Adelaide', 'Australia/Adelaide'), ('Australia/Brisbane', 'Australia/Brisbane'), ('Australia/Broken_Hill', 'Australia/Broken_Hill'), ('Australia/Canberra', 'Australia/Canberra'), ('Australia/Currie', 'Australia/Currie'), ('Australia/Darwin', 'Australia/Darwin'), ('Australia/Eucla', 'Australia/Eucla'), ('Australia/Hobart', 'Australia/Hobart'), ('Australia/LHI', 'Australia/LHI'), ('Australia/Lindeman', 'Australia/Lindeman'), ('Australia/Lord_Howe', 'Australia/Lord_Howe'), ('Australia/Melbourne', 'Australia/Melbourne'), ('Australia/NSW', 'Australia/NSW'), ('Australia/North', 'Australia/North'), ('Australia/Perth', 'Australia/Perth'), ('Australia/Queensland', 'Australia/Queensland'), ('Australia/South', 'Australia/South'), ('Australia/Sydney', 'Australia/Sydney'), ('Australia/Tasmania', 'Australia/Tasmania'), ('Australia/Victoria', 'Australia/Victoria'), ('Australia/West', 'Australia/West'), ('Australia/Yancowinna', 'Australia/Yancowinna'), ('Brazil/Acre', 'Brazil/Acre'), ('Brazil/DeNoronha', 'Brazil/DeNoronha'), ('Brazil/East', 'Brazil/East'), ('Brazil/West', 'Brazil/West'), ('CET', 'CET'), ('CST6CDT', 'CST6CDT'), ('Canada/Atlantic', 'Canada/Atlantic'), ('Canada/Central', 'Canada/Central'), ('Canada/Eastern', 'Canada/Eastern'), ('Canada/Mountain', 'Canada/Mountain'), ('Canada/Newfoundland', 'Canada/Newfoundland'), ('Canada/Pacific', 'Canada/Pacific'), ('Canada/Saskatchewan', 'Canada/Saskatchewan'), ('Canada/Yukon', 'Canada/Yukon'), ('Chile/Continental', 'Chile/Continental'), ('Chile/EasterIsland', 'Chile/EasterIsland'), ('Cuba', 'Cuba'), ('EET', 'EET'), ('EST', 'EST'), ('EST5EDT', 'EST5EDT'), ('Egypt', 'Egypt'), ('Eire', 'Eire'), ('Etc/GMT', 'Etc/GMT'), ('Etc/GMT+0', 'Etc/GMT+0'), ('Etc/GMT+1', 'Etc/GMT+1'), ('Etc/GMT+10', 'Etc/GMT+10'), ('Etc/GMT+11', 'Etc/GMT+11'), ('Etc/GMT+12', 'Etc/GMT+12'), ('Etc/GMT+2', 'Etc/GMT+2'), ('Etc/GMT+3', 'Etc/GMT+3'), ('Etc/GMT+4', 'Etc/GMT+4'), ('Etc/GMT+5', 'Etc/GMT+5'), ('Etc/GMT+6', 'Etc/GMT+6'), ('Etc/GMT+7', 'Etc/GMT+7'), ('Etc/GMT+8', 'Etc/GMT+8'), ('Etc/GMT+9', 'Etc/GMT+9'), ('Etc/GMT-0', 'Etc/GMT-0'), ('Etc/GMT-1', 'Etc/GMT-1'), ('Etc/GMT-10', 'Etc/GMT-10'), ('Etc/GMT-11', 'Etc/GMT-11'), ('Etc/GMT-12', 'Etc/GMT-12'), ('Etc/GMT-13', 'Etc/GMT-13'), ('Etc/GMT-14', 'Etc/GMT-14'), ('Etc/GMT-2', 'Etc/GMT-2'), ('Etc/GMT-3', 'Etc/GMT-3'), ('Etc/GMT-4', 'Etc/GMT-4'), ('Etc/GMT-5', 'Etc/GMT-5'), ('Etc/GMT-6', 'Etc/GMT-6'), ('Etc/GMT-7', 'Etc/GMT-7'), ('Etc/GMT-8', 'Etc/GMT-8'), ('Etc/GMT-9', 'Etc/GMT-9'), ('Etc/GMT0', 'Etc/GMT0'), ('Etc/Greenwich', 'Etc/Greenwich'), ('Etc/UCT', 'Etc/UCT'), ('Etc/UTC', 'Etc/UTC'), ('Etc/Universal', 'Etc/Universal'), ('Etc/Zulu', 'Etc/Zulu'), ('Europe/Amsterdam', 'Europe/Amsterdam'), ('Europe/Andorra', 'Europe/Andorra'), ('Europe/Astrakhan', 'Europe/Astrakhan'), ('Europe/Athens', 'Europe/Athens'), ('Europe/Belfast', 'Europe/Belfast'), ('Europe/Belgrade', 'Europe/Belgrade'), ('Europe/Berlin', 'Europe/Berlin'), ('Europe/Bratislava', 'Europe/Bratislava'), ('Europe/Brussels', 'Europe/Brussels'), ('Europe/Bucharest', 'Europe/Bucharest'), ('Europe/Budapest', 'Europe/Budapest'), ('Europe/Busingen', 'Europe/Busingen'), ('Europe/Chisinau', 'Europe/Chisinau'), ('Europe/Copenhagen', 'Europe/Copenhagen'), ('Europe/Dublin', 'Europe/Dublin'), ('Europe/Gibraltar', 'Europe/Gibraltar'), ('Europe/Guernsey', 'Europe/Guernsey'), ('Europe/Helsinki', 'Europe/Helsinki'), ('Europe/Isle_of_Man', 'Europe/Isle_of_Man'), ('Europe/Istanbul', 'Europe/Istanbul'), ('Europe/Jersey', 'Europe/Jersey'), ('Europe/Kaliningrad', 'Europe/Kaliningrad'), ('Europe/Kiev', 'Europe/Kiev'), ('Europe/Kirov', 'Europe/Kirov'), ('Europe/Lisbon', 'Europe/Lisbon'), ('Europe/Ljubljana', 'Europe/Ljubljana'), ('Europe/London', 'Europe/London'), ('Europe/Luxembourg', 'Europe/Luxembourg'), ('Europe/Madrid', 'Europe/Madrid'), ('Europe/Malta', 'Europe/Malta'), ('Europe/Mariehamn', 'Europe/Mariehamn'), ('Europe/Minsk', 'Europe/Minsk'), ('Europe/Monaco', 'Europe/Monaco'), ('Europe/Moscow', 'Europe/Moscow'), ('Europe/Nicosia', 'Europe/Nicosia'), ('Europe/Oslo', 'Europe/Oslo'), ('Europe/Paris', 'Europe/Paris'), ('Europe/Podgorica', 'Europe/Podgorica'), ('Europe/Prague', 'Europe/Prague'), ('Europe/Riga', 'Europe/Riga'), ('Europe/Rome', 'Europe/Rome'), ('Europe/Samara', 'Europe/Samara'), ('Europe/San_Marino', 'Europe/San_Marino'), ('Europe/Sarajevo', 'Europe/Sarajevo'), ('Europe/Saratov', 'Europe/Saratov'), ('Europe/Simferopol', 'Europe/Simferopol'), ('Europe/Skopje', 'Europe/Skopje'), ('Europe/Sofia', 'Europe/Sofia'), ('Europe/Stockholm', 'Europe/Stockholm'), ('Europe/Tallinn', 'Europe/Tallinn'), ('Europe/Tirane', 'Europe/Tirane'), ('Europe/Tiraspol', 'Europe/Tiraspol'), ('Europe/Ulyanovsk', 'Europe/Ulyanovsk'), ('Europe/Uzhgorod', 'Europe/Uzhgorod'), ('Europe/Vaduz', 'Europe/Vaduz'), ('Europe/Vatican', 'Europe/Vatican'), ('Europe/Vienna', 'Europe/Vienna'), ('Europe/Vilnius', 'Europe/Vilnius'), ('Europe/Volgograd', 'Europe/Volgograd'), ('Europe/Warsaw', 'Europe/Warsaw'), ('Europe/Zagre', 'Europe/Zagre'), ('Europe/Zaporozhye', 'Europe/Zaporozhye'), ('Europe/Zurich', 'Europe/Zurich'), ('G', 'G'), ('GB-Eire', 'GB-Eire'), ('GMT', 'GMT'), ('GMT+0', 'GMT+0'), ('GMT-0', 'GMT-0'), ('GMT0', 'GMT0'), ('Greenwich', 'Greenwich'), ('HST', 'HST'), ('Hongkong', 'Hongkong'), ('Iceland', 'Iceland'), ('Indian/Antananarivo', 'Indian/Antananarivo'), ('Indian/Chagos', 'Indian/Chagos'), ('Indian/Christmas', 'Indian/Christmas'), ('Indian/Cocos', 'Indian/Cocos'), ('Indian/Comoro', 'Indian/Comoro'), ('Indian/Kerguelen', 'Indian/Kerguelen'), ('Indian/Mahe', 'Indian/Mahe'), ('Indian/Maldives', 'Indian/Maldives'), ('Indian/Mauritius', 'Indian/Mauritius'), ('Indian/Mayotte', 'Indian/Mayotte'), ('Indian/Reunion', 'Indian/Reunion'), ('Iran', 'Iran'), ('Israel', 'Israel'), ('Jamaica', 'Jamaica'), ('Japan', 'Japan'), ('Kwajalein', 'Kwajalein'), ('Libya', 'Libya'), ('MET', 'MET'), ('MST', 'MST'), ('MST7MDT', 'MST7MDT'), ('Mexico/BajaNorte', 'Mexico/BajaNorte'), ('Mexico/BajaSur', 'Mexico/BajaSur'), ('Mexico/General', 'Mexico/General'), ('NZ', 'NZ'), ('NZ-CHAT', 'NZ-CHAT'), ('Navajo', 'Navajo'), ('PRC', 'PRC'), ('PST8PDT', 'PST8PDT'), ('Pacific/Apia', 'Pacific/Apia'), ('Pacific/Auckland', 'Pacific/Auckland'), ('Pacific/Bougainville', 'Pacific/Bougainville'), ('Pacific/Chatham', 'Pacific/Chatham'), ('Pacific/Chuuk', 'Pacific/Chuuk'), ('Pacific/Easter', 'Pacific/Easter'), ('Pacific/Efate', 'Pacific/Efate'), ('Pacific/Enderbury', 'Pacific/Enderbury'), ('Pacific/Fakaofo', 'Pacific/Fakaofo'), ('Pacific/Fiji', 'Pacific/Fiji'), ('Pacific/Funafuti', 'Pacific/Funafuti'), ('Pacific/Galapagos', 'Pacific/Galapagos'), ('Pacific/Gambier', 'Pacific/Gambier'), ('Pacific/Guadalcanal', 'Pacific/Guadalcanal'), ('Pacific/Guam', 'Pacific/Guam'), ('Pacific/Honolulu', 'Pacific/Honolulu'), ('Pacific/Johnston', 'Pacific/Johnston'), ('Pacific/Kiritimati', 'Pacific/Kiritimati'), ('Pacific/Kosrae', 'Pacific/Kosrae'), ('Pacific/Kwajalein', 'Pacific/Kwajalein'), ('Pacific/Majuro', 'Pacific/Majuro'), ('Pacific/Marquesas', 'Pacific/Marquesas'), ('Pacific/Midway', 'Pacific/Midway'), ('Pacific/Nauru', 'Pacific/Nauru'), ('Pacific/Niue', 'Pacific/Niue'), ('Pacific/Norfolk', 'Pacific/Norfolk'), ('Pacific/Noumea', 'Pacific/Noumea'), ('Pacific/Pago_Pago', 'Pacific/Pago_Pago'), ('Pacific/Palau', 'Pacific/Palau'), ('Pacific/Pitcairn', 'Pacific/Pitcairn'), ('Pacific/Pohnpei', 'Pacific/Pohnpei'), ('Pacific/Ponape', 'Pacific/Ponape'), ('Pacific/Port_Moresby', 'Pacific/Port_Moresby'), ('Pacific/Rarotonga', 'Pacific/Rarotonga'), ('Pacific/Saipan', 'Pacific/Saipan'), ('Pacific/Samoa', 'Pacific/Samoa'), ('Pacific/Tahiti', 'Pacific/Tahiti'), ('Pacific/Tarawa', 'Pacific/Tarawa'), ('Pacific/Tongatapu', 'Pacific/Tongatapu'), ('Pacific/Truk', 'Pacific/Truk'), ('Pacific/Wake', 'Pacific/Wake'), ('Pacific/Wallis', 'Pacific/Wallis'), ('Pacific/Yap', 'Pacific/Yap'), ('Poland', 'Poland'), ('Portugal', 'Portugal'), ('ROC', 'ROC'), ('ROK', 'ROK'), ('Singapore', 'Singapore'), ('Turkey', 'Turkey'), ('UCT', 'UCT'), ('US/Alaska', 'US/Alaska'), ('US/Aleutian', 'US/Aleutian'), ('US/Arizona', 'US/Arizona'), ('US/Central', 'US/Central'), ('US/East-Indiana', 'US/East-Indiana'), ('US/Eastern', 'US/Eastern'), ('US/Hawaii', 'US/Hawaii'), ('US/Indiana-Starke', 'US/Indiana-Starke'), ('US/Michigan', 'US/Michigan'), ('US/Mountain', 'US/Mountain'), ('US/Pacific', 'US/Pacific'), ('US/Pacific-New', 'US/Pacific-New'), ('US/Samoa', 'US/Samoa'), ('UTC', 'UTC'), ('Universal', 'Universal'), ('W-SU', 'W-SU'), ('WET', 'WET'), ('Zulu', 'Zulu')], default='UTC', max_length=50)),
                ('display_endpoint_uri', models.BooleanField(default=False, help_text='Displays the full endpoint URI in the endpoint view.', verbose_name='Display Endpoint Full URI')),
                ('enable_product_grade', models.BooleanField(default=False, help_text='Displays a grade letter next to a product to show the overall health.', verbose_name='Enable Product Grading')),
                ('product_grade', models.CharField(blank=True, max_length=800)),
                ('product_grade_a', models.IntegerField(default=90, help_text=b"Percentage score for an 'A' >=", verbose_name='Grade A')),
                ('product_grade_b', models.IntegerField(default=80, help_text=b"Percentage score for a '' >=", verbose_name='Grade ')),
                ('product_grade_c', models.IntegerField(default=70, help_text=b"Percentage score for a 'C' >=", verbose_name='Grade C')),
                ('product_grade_d', models.IntegerField(default=60, help_text=b"Percentage score for a 'D' >=", verbose_name='Grade D')),
                ('product_grade_f', models.IntegerField(default=59, help_text=b"Percentage score for an 'F' <=", verbose_name='Grade F')),
                ('enable_benchmark', models.BooleanField(default=True, help_text='Enables Benchmarks such as the OWASP ASVS (Application Security Verification Standard)', verbose_name='Enable Benchmarks')),
                ('enable_template_match', models.BooleanField(default=False, help_text='Enables global remediation advice and matching on CWE and Title. The text will be replaced for mitigation, impact and references on a finding. Useful for providing consistent impact and remediation advice regardless of the scanner.', verbose_name='Enable Remediation Advice')),
                ('engagement_auto_close', models.BooleanField(default=False, help_text='Closes an engagement after 3 days (default) past due date including last update.', verbose_name='Enable Engagement Auto-Close')),
                ('engagement_auto_close_days', models.IntegerField(default=3, help_text='Closes an engagement after the specified number of days past due date including last update.', verbose_name='Engagement Auto-Close Days')),
                ('enable_finding_sla', models.BooleanField(default=True, help_text=b"Enables Finding SLA's for time to remediate.", verbose_name=b"Enable Finding SLA's")),
                ('sla_critical', models.IntegerField(default=7, help_text='# of days to remediate a critical finding.', verbose_name='Critical Finding SLA Days')),
                ('sla_high', models.IntegerField(default=30, help_text='# of days to remediate a high finding.', verbose_name='High Finding SLA Days')),
                ('sla_medium', models.IntegerField(default=90, help_text='# of days to remediate a medium finding.', verbose_name='Medium Finding SLA Days')),
                ('sla_low', models.IntegerField(default=120, help_text='# of days to remediate a low finding.', verbose_name='Low Finding SLA Days')),
            ],
        ),
        migrations.CreateModel(
            name='Test',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(blank=True, null=True)),
                ('target_start', models.DateTimeField()),
                ('target_end', models.DateTimeField()),
                ('estimated_time', models.TimeField(blank=True, editable=False, null=True)),
                ('actual_time', models.TimeField(blank=True, editable=False, null=True)),
                ('percent_complete', models.IntegerField(blank=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('engagement', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Engagement')),
                ('environment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Development_Environment')),
            ],
        ),
        migrations.CreateModel(
            name='Test_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True)),
                ('static_tool', models.BooleanField(default=False)),
                ('dynamic_tool', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Testing_Guide',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(blank=True, help_text='Test Unique Identifier', max_length=20, null=True)),
                ('name', models.CharField(help_text='Name of the test', max_length=400)),
                ('summary', models.CharField(help_text='Summary of the test', max_length=800)),
                ('objective', models.CharField(help_text='Objective of the test', max_length=800)),
                ('how_to_test', models.TextField(default=None, help_text='How to test the objective')),
                ('results_expected', models.CharField(help_text='What the results look like for a test', max_length=800)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Testing_Guide_Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Tool_Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.CharField(max_length=2000, null=True)),
                ('authentication_type', models.CharField(blank=True, choices=[('API', 'API Key'), ('Password', 'Username/Password'), ('SSH', 'SSH')], max_length=15, null=True)),
                ('username', models.CharField(blank=True, max_length=200, null=True)),
                ('password', models.CharField(blank=True, max_length=600, null=True)),
                ('auth_title', models.CharField(blank=True, max_length=200, null=True, verbose_name='Title for SSH/API Key')),
                ('ssh', models.CharField(blank=True, max_length=6000, null=True)),
                ('api_key', models.CharField(blank=True, max_length=600, null=True, verbose_name='API Key')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tool_Product_History',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_scan', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('succesfull', models.BooleanField(default=True, verbose_name='Succesfully')),
                ('configuration_details', models.CharField(blank=True, max_length=2000, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Tool_Product_Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.CharField(blank=True, max_length=2000, null=True)),
                ('tool_project_id', models.CharField(blank=True, max_length=200, null=True)),
                ('notes', models.ManyToManyField(blank=True, editable=False, to='dojo.Notes')),
                ('product', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Product')),
                ('tool_configuration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_configuration', to='dojo.Tool_Configuration')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tool_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=2000, null=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='UserContactInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=150, null=True)),
                ('phone_number', models.CharField(blank=True, help_text=b"Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", max_length=15, validators=[django.core.validators.RegexValidator(message=b"Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('cell_number', models.CharField(blank=True, help_text=b"Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", max_length=15, validators=[django.core.validators.RegexValidator(message=b"Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('twitter_username', models.CharField(blank=True, max_length=150, null=True)),
                ('github_username', models.CharField(blank=True, max_length=150, null=True)),
                ('slack_username', models.CharField(blank=True, help_text='Email address associated with your slack account', max_length=150, null=True, verbose_name='Slack Email Address')),
                ('slack_user_id', models.CharField(blank=True, max_length=25, null=True)),
                ('hipchat_username', models.CharField(blank=True, max_length=150, null=True)),
                ('block_execution', models.BooleanField(default=False, help_text=b"Instead of async deduping a finding the findings will be deduped synchronously and will 'block' the user until completion.")),
            ],
        ),
        migrations.CreateModel(
            name='VA',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.TextField(default='none', editable=False)),
                ('status', models.BooleanField(default=False, editable=False)),
                ('start', models.CharField(max_length=100)),
                ('result', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Test')),
            ],
        ),
        migrations.CreateModel(
            name='Dojo_User',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'ordering': ['first_name'],
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.AddField(
            model_name='va',
            name='user',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='usercontactinfo',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='tool_product_history',
            name='product',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Tool_Product_Settings'),
        ),
        migrations.AddField(
            model_name='tool_configuration',
            name='tool_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_type', to='dojo.Tool_Type'),
        ),
        migrations.AddField(
            model_name='testing_guide',
            name='testing_guide_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Testing_Guide_Category'),
        ),
        migrations.AddField(
            model_name='test',
            name='lead',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='test',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='test',
            name='test_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Test_Type'),
        ),
        migrations.AddField(
            model_name='stub_finding',
            name='reporter',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='stub_finding',
            name='test',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Test'),
        ),
        migrations.AddField(
            model_name='scansettings',
            name='user',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='scan',
            name='scan_settings',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.ScanSettings'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='reporter',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='report',
            name='requester',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='product',
            name='authorized_users',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='product',
            name='prod_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='prod_type', to='dojo.Product_Type'),
        ),
        migrations.AddField(
            model_name='product',
            name='product_manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product_manager', to='dojo.Dojo_User'),
        ),
        migrations.AddField(
            model_name='product',
            name='regulations',
            field=models.ManyToManyField(blank=True, to='dojo.Regulation'),
        ),
        migrations.AddField(
            model_name='product',
            name='team_manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='team_manager', to='dojo.Dojo_User'),
        ),
        migrations.AddField(
            model_name='product',
            name='technical_contact',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='technical_contact', to='dojo.Dojo_User'),
        ),
        migrations.AddField(
            model_name='objects',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='objects',
            name='review_status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Objects_Review'),
        ),
        migrations.AddField(
            model_name='notifications',
            name='user',
            field=models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='notes',
            name='author',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='languages',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='languages',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='jira_pkey',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='ipscan',
            name='scan',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Scan'),
        ),
        migrations.AddField(
            model_name='findingimageaccesstoken',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='defect_review_requested_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='defect_review_requested_by', to='dojo.Dojo_User'),
        ),
        migrations.AddField(
            model_name='finding',
            name='duplicate_finding',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='original_finding', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='finding',
            name='duplicate_list',
            field=models.ManyToManyField(blank=True, editable=False, related_name='_finding_duplicate_list_+', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='finding',
            name='endpoints',
            field=models.ManyToManyField(blank=True, to='dojo.Endpoint'),
        ),
        migrations.AddField(
            model_name='finding',
            name='found_by',
            field=models.ManyToManyField(editable=False, to='dojo.Test_Type'),
        ),
        migrations.AddField(
            model_name='finding',
            name='images',
            field=models.ManyToManyField(blank=True, to='dojo.FindingImage'),
        ),
        migrations.AddField(
            model_name='finding',
            name='last_reviewed_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='last_reviewed_by', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='mitigated_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mitigated_by', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='finding',
            name='reporter',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='reporter', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='review_requested_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='review_requested_by', to='dojo.Dojo_User'),
        ),
        migrations.AddField(
            model_name='finding',
            name='reviewers',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='test',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.Test'),
        ),
        migrations.AddField(
            model_name='engagement_presets',
            name='network_locations',
            field=models.ManyToManyField(blank=True, default=None, to='dojo.Network_Locations'),
        ),
        migrations.AddField(
            model_name='engagement_presets',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='engagement_presets',
            name='test_type',
            field=models.ManyToManyField(blank=True, default=None, to='dojo.Test_Type'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='build_server',
            field=models.ForeignKey(blank=True, help_text='Build server responsible for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='build_server', to='dojo.Tool_Configuration', verbose_name='Build Server'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='eng_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Engagement_Type'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='lead',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='engagement',
            name='orchestration_engine',
            field=models.ForeignKey(blank=True, help_text='Orchestration service responsible for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orchestration', to='dojo.Tool_Configuration', verbose_name='Orchestration Engine'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='preset',
            field=models.ForeignKey(blank=True, help_text='Settings and notes for performing this engagement.', null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Engagement_Presets'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='report_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Report_Type'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='requester',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Contact'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='risk_acceptance',
            field=models.ManyToManyField(blank=True, default=None, editable=False, to='dojo.Risk_Acceptance'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='source_code_management_server',
            field=models.ForeignKey(blank=True, help_text='Source code server for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='source_code_management_server', to='dojo.Tool_Configuration', verbose_name='SCM Server'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='endpoint_params',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Endpoint_Params'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='product',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='dojometa',
            name='endpoint',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='endpoint_meta', to='dojo.Endpoint'),
        ),
        migrations.AddField(
            model_name='dojometa',
            name='product',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product_meta', to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='cred_user',
            name='environment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Development_Environment'),
        ),
        migrations.AddField(
            model_name='cred_user',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='cred_mapping',
            name='cred_id',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cred_user', to='dojo.Cred_User', verbose_name='Credential'),
        ),
        migrations.AddField(
            model_name='cred_mapping',
            name='engagement',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='engagement', to='dojo.Engagement'),
        ),
        migrations.AddField(
            model_name='cred_mapping',
            name='finding',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='finding', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='cred_mapping',
            name='product',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product', to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='cred_mapping',
            name='test',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='test', to='dojo.Test'),
        ),
        migrations.AddField(
            model_name='child_rule',
            name='parent_rule',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Rule'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='auth_issues',
            field=models.ManyToManyField(blank=True, related_name='auth_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='author_issues',
            field=models.ManyToManyField(blank=True, related_name='author_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='config_issues',
            field=models.ManyToManyField(blank=True, related_name='config_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='crypto_issues',
            field=models.ManyToManyField(blank=True, related_name='crypto_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='data_issues',
            field=models.ManyToManyField(blank=True, related_name='data_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='engagement',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='eng_for_check', to='dojo.Engagement'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='other_issues',
            field=models.ManyToManyField(blank=True, related_name='other_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='sensitive_issues',
            field=models.ManyToManyField(blank=True, related_name='sensitive_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='check_list',
            name='session_issues',
            field=models.ManyToManyField(blank=True, related_name='session_issues', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='burprawrequestresponse',
            name='finding',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='benchmark_requirement',
            name='cwe_mapping',
            field=models.ManyToManyField(blank=True, to='dojo.CWE'),
        ),
        migrations.AddField(
            model_name='benchmark_requirement',
            name='testing_guide',
            field=models.ManyToManyField(blank=True, to='dojo.Testing_Guide'),
        ),
        migrations.AddField(
            model_name='benchmark_product_summary',
            name='benchmark_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Benchmark_Type'),
        ),
        migrations.AddField(
            model_name='benchmark_product_summary',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='benchmark_product',
            name='control',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Benchmark_Requirement'),
        ),
        migrations.AddField(
            model_name='benchmark_product',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='benchmark_product',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='benchmark_category',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Benchmark_Type', verbose_name='Benchmark Type'),
        ),
        migrations.AddField(
            model_name='app_analysis',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.Product'),
        ),
        migrations.AddField(
            model_name='app_analysis',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='alerts',
            name='user_id',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='languages',
            unique_together=set([('language', 'product')]),
        ),
        migrations.AlterUniqueTogether(
            name='dojometa',
            unique_together=set([('product', 'name'), ('endpoint', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='benchmark_product_summary',
            unique_together=set([('product', 'benchmark_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='benchmark_product',
            unique_together=set([('product', 'control')]),
        ),
    ]
