/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class CustomSashForm
extends SashForm {
    private static final Log log = Log.getLog(CustomSashForm.class);
    public static final int NO_HIDE_LEFT = 1;
    public static final int NO_HIDE_UP = 1;
    public static final int NO_HIDE_RIGHT = 2;
    public static final int NO_HIDE_DOWN = 2;
    private static final int NO_WEIGHT = -1;
    private static final int NO_ARROW = -1;
    protected Color arrowColor;
    public static final Color DEFAULT_BORDER_COLOR = new Color(153, 180, 209, 255);
    protected SashInfo currentSashInfo = null;
    protected boolean inMouseClick = false;
    private boolean[] sashBorders;
    private boolean showBorders = false;
    protected boolean noHideUp;
    protected boolean noHideDown;
    protected List<ICustomSashFormListener> customSashFormListeners = null;
    protected static final int UP_RESTORE_ARROW = 0;
    protected static final int UP_HIDE_ARROW = 1;
    protected static final int DOWN_RESTORE_ARROW = 2;
    protected static final int DOWN_HIDE_ARROW = 3;
    protected static final int HIDE_ARROWS = 4;
    protected static final int ARROW_TYPE_INDEX = 0;
    protected static final int ARROW_DRAWN_INDEX = 1;
    protected static final int X_INDEX = 2;
    protected static final int Y_INDEX = 3;
    protected static final int WIDTH_INDEX = 4;
    protected static final int HEIGHT_INDEX = 5;
    protected static final int ARROW_WIDTH = 12;
    protected static final int ARROW_HEIGHT = 5;
    protected static final int ARROW_MARGIN = 5;
    private static final int NOT_SLAMMED = 1;
    private static final int SLAMMED_TO_BOTTOM = 2;
    private static final int SLAMMED_TO_TOP = 3;

    public CustomSashForm(Composite parent, int style) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                CustomSashForm.this.layout(true);
                CustomSashForm.this.removeListener(11, this);
            }
        });
        this.sashBorders = new boolean[]{true, true};
        this.SASH_WIDTH = 10;
        this.arrowColor = DEFAULT_BORDER_COLOR;
    }

    public boolean isShowBorders() {
        return this.showBorders;
    }

    public void setShowBorders(boolean showBorders) {
        this.showBorders = showBorders;
    }

    public void setNoHideUp(boolean bHide) {
        this.noHideUp = bHide;
    }

    public void setNoHideDown(boolean bHide) {
        this.noHideDown = bHide;
    }

    public void setNoHideLeft(boolean bHide) {
        this.setNoHideUp(bHide);
    }

    public void setNoHideRight(boolean bHide) {
        this.setNoHideDown(bHide);
    }

    public void hideUp() {
        if (this.noHideUp) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.upHideClicked(this.currentSashInfo);
    }

    public void hideLeft() {
        this.hideUp();
    }

    public void hideDown() {
        if (this.noHideDown) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.downHideClicked();
    }

    public boolean isDownHidden() {
        if (this.currentSashInfo == null || this.currentSashInfo.restoreWeight <= 0) {
            return false;
        }
        int[] weights = this.getWeights();
        return weights.length == 2 && weights[1] == 0;
    }

    public void showDown() {
        if (this.currentSashInfo == null || this.currentSashInfo.restoreWeight <= 0) {
            this.hideDown();
        }
        this.downRestoreClicked(this.currentSashInfo);
    }

    public void hideRight() {
        this.hideDown();
    }

    public void setSashBorders(boolean[] sashBorders) {
        int[] weights = this.getWeights();
        if (weights.length != 2 || sashBorders != null && sashBorders.length != 2) {
            SWT.error((int)5);
        }
        this.sashBorders = sashBorders;
    }

    public void layout(boolean changed) {
        super.layout(changed);
        if (this.noHideUp && this.noHideDown) {
            return;
        }
        if (this.getMaximizedControl() != null) {
            return;
        }
        Control[] children = this.getChildren();
        Sash newSash = null;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Sash) {
                if (newSash == null) {
                    newSash = (Sash)child;
                } else {
                    if (this.currentSashInfo != null) {
                        this.currentSashInfo.enabled = false;
                    }
                    return;
                }
            }
            ++n2;
        }
        if (newSash == null) {
            return;
        }
        if (this.currentSashInfo == null || this.currentSashInfo.sash == null) {
            if (this.currentSashInfo == null) {
                this.currentSashInfo = new SashInfo(newSash);
            } else {
                this.currentSashInfo.sash = newSash;
            }
            newSash.addPaintListener(e -> {
                GC gc = e.gc;
                Color oldFg = gc.getForeground();
                Color oldBg = gc.getBackground();
                boolean isTwoArrows = this.currentSashInfo.sashLocs.length > 1;
                this.drawArrow(gc, this.currentSashInfo.sashLocs[0], this.currentSashInfo.cursorOver == 0, isTwoArrows);
                if (isTwoArrows) {
                    this.drawArrow(gc, this.currentSashInfo.sashLocs[1], this.currentSashInfo.cursorOver == 1, isTwoArrows);
                }
                this.drawSashBorder(gc, this.currentSashInfo);
                gc.setForeground(oldFg);
                gc.setBackground(oldBg);
            });
            newSash.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    CustomSashForm.this.recomputeSashInfo();
                    if (CustomSashForm.this.currentSashInfo != null) {
                        CustomSashForm.this.currentSashInfo.sash.redraw();
                    }
                }

                public void controlResized(ControlEvent e) {
                    CustomSashForm.this.recomputeSashInfo();
                    CustomSashForm.this.currentSashInfo.sash.redraw();
                }
            });
            newSash.addDisposeListener(e -> {
                this.currentSashInfo = null;
            });
            newSash.addMouseMoveListener(e -> {
                int x = e.x;
                int y = e.y;
                int i = 0;
                while (i < this.currentSashInfo.sashLocs.length) {
                    int sizeIndex;
                    int[] locs = this.currentSashInfo.sashLocs[i];
                    boolean vertical = this.getOrientation() == 512;
                    int loc = vertical ? x : y;
                    int locIndex = vertical ? 2 : 3;
                    int n = sizeIndex = vertical ? 4 : 5;
                    if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                        if (this.currentSashInfo.cursorOver == -1) {
                            this.currentSashInfo.sash.setCursor(this.getDisplay().getSystemCursor(21));
                        }
                        if (this.currentSashInfo.cursorOver != i) {
                            this.currentSashInfo.cursorOver = i;
                            switch (locs[0]) {
                                case 0: 
                                case 2: {
                                    this.currentSashInfo.sash.setToolTipText(UIMessages.tooltip_restore);
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    this.currentSashInfo.sash.setToolTipText(UIMessages.tooltip_hide);
                                    break;
                                }
                            }
                        }
                        return;
                    }
                    ++i;
                }
                if (this.currentSashInfo.cursorOver != -1) {
                    this.currentSashInfo.sash.setCursor(null);
                    this.currentSashInfo.cursorOver = -1;
                    this.currentSashInfo.sash.setToolTipText(null);
                }
            });
            newSash.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    if (CustomSashForm.this.currentSashInfo.cursorOver != -1) {
                        CustomSashForm.this.currentSashInfo.sash.setCursor(null);
                        CustomSashForm.this.currentSashInfo.cursorOver = -1;
                        CustomSashForm.this.currentSashInfo.sash.setToolTipText(null);
                    }
                }
            });
            newSash.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    CustomSashForm.this.inMouseClick = true;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CustomSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CustomSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            CustomSashForm.this.currentSashInfo.sash.redraw();
                            break;
                        }
                        ++i;
                    }
                }

                public void mouseUp(MouseEvent e) {
                    CustomSashForm.this.inMouseClick = false;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CustomSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CustomSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            switch (locs[0]) {
                                case 0: {
                                    CustomSashForm.this.upRestoreClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 1: {
                                    CustomSashForm.this.upHideClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 2: {
                                    CustomSashForm.this.downRestoreClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 3: {
                                    CustomSashForm.this.downHideClicked();
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                    CustomSashForm.this.currentSashInfo.sash.redraw();
                    CustomSashForm.this.fireDividerMoved();
                }
            });
            this.recomputeSashInfo();
        }
    }

    protected void recomputeSashInfo() {
        int[] drawArrows;
        int[] addArrows;
        if (this.inMouseClick && this.currentSashInfo.cursorOver != -1) {
            return;
        }
        int[] weights = this.getWeights();
        Rectangle sashBounds = this.currentSashInfo.sash.getBounds();
        Rectangle clientArea = this.getClientArea();
        boolean vertical = this.getOrientation() == 512;
        int slammed = 1;
        if (weights[1] == 0) {
            slammed = 2;
        } else if (weights[0] == 0) {
            slammed = 3;
        } else if (vertical) {
            if (this.currentSashInfo.restoreWeight != -1 && sashBounds.y <= 20) {
                slammed = 3;
            } else if (this.currentSashInfo.restoreWeight != -1 && sashBounds.y + sashBounds.height >= clientArea.height - 20) {
                slammed = 2;
            }
        } else if (this.currentSashInfo.restoreWeight != -1 && sashBounds.x <= 20) {
            slammed = 3;
        } else if (this.currentSashInfo.restoreWeight != -1 && sashBounds.x + sashBounds.width >= clientArea.width - 20) {
            slammed = 2;
        }
        if (this.noHideUp) {
            if (slammed == 2) {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 0;
                drawArrows[0] = 0;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null && this.sashBorders[0];
                this.currentSashInfo.sashBorderRight = false;
            } else {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 3;
                drawArrows[0] = 2;
                this.currentSashInfo.restoreWeight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null && this.sashBorders[0];
                this.currentSashInfo.sashBorderRight = this.sashBorders != null && this.sashBorders[1];
            }
        } else if (this.noHideDown) {
            if (slammed == 3) {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 2;
                drawArrows[0] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null && this.sashBorders[1];
            } else {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 1;
                drawArrows[0] = 0;
                this.currentSashInfo.restoreWeight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null && this.sashBorders[0];
                this.currentSashInfo.sashBorderRight = this.sashBorders != null && this.sashBorders[1];
            }
        } else if (slammed == 3) {
            addArrows = new int[1];
            drawArrows = new int[1];
            addArrows[0] = 2;
            drawArrows[0] = 2;
            this.currentSashInfo.sashBorderLeft = false;
            this.currentSashInfo.sashBorderRight = this.sashBorders != null && this.sashBorders[1];
        } else if (slammed == 2) {
            addArrows = new int[1];
            drawArrows = new int[1];
            addArrows[0] = 0;
            drawArrows[0] = 0;
            this.currentSashInfo.sashBorderLeft = this.sashBorders != null && this.sashBorders[0];
            this.currentSashInfo.sashBorderRight = false;
        } else {
            addArrows = new int[2];
            drawArrows = new int[2];
            addArrows[0] = 1;
            drawArrows[0] = 0;
            addArrows[1] = 3;
            drawArrows[1] = 2;
            this.currentSashInfo.restoreWeight = -1;
            this.currentSashInfo.sashBorderLeft = this.sashBorders != null && this.sashBorders[0];
            this.currentSashInfo.sashBorderRight = this.sashBorders != null && this.sashBorders[1];
        }
        this.getNewSashArray(this.currentSashInfo, addArrows, drawArrows);
    }

    protected void upRestoreClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.restoreWeight;
        weights[1] = sashinfo.restoreWeight;
        sashinfo.restoreWeight = -1;
        try {
            this.setWeights(weights);
        }
        catch (SWTError sWTError) {}
        this.fireDividerMoved();
    }

    protected void upHideClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        if (weights.length != 2) {
            return;
        }
        if (this.currentSashInfo.restoreWeight == -1) {
            this.currentSashInfo.restoreWeight = weights[1];
            this.saveChildControlSizes();
        }
        weights[0] = 0;
        weights[1] = 1000;
        Control[] children = this.getChildren();
        boolean upperFocus = this.isFocusAncestorA(children[0]);
        try {
            this.setWeights(weights);
        }
        catch (SWTError e) {
            log.debug((Object)e);
        }
        this.setWeights(weights);
        if (upperFocus) {
            children[1].setFocus();
        }
        this.fireDividerMoved();
    }

    protected void downRestoreClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.restoreWeight;
        weights[1] = sashinfo.restoreWeight;
        sashinfo.restoreWeight = -1;
        this.setWeights(weights);
        this.fireDividerMoved();
    }

    protected void downHideClicked() {
        int[] weights = this.getWeights();
        if (this.currentSashInfo.restoreWeight == -1) {
            this.currentSashInfo.restoreWeight = weights[1];
            this.saveChildControlSizes();
        }
        weights[0] = 1000;
        weights[1] = 0;
        Control[] children = this.getChildren();
        boolean lowerFocus = this.isFocusAncestorA(children[1]);
        this.setWeights(weights);
        if (lowerFocus) {
            children[0].setFocus();
        }
        this.fireDividerMoved();
    }

    private void saveChildControlSizes() {
        Control[] children = this.getChildren();
        int iChildToSave = 0;
        int i = 0;
        while (i < children.length && iChildToSave < 2) {
            Control child = children[i];
            if (!(child instanceof Sash)) {
                this.currentSashInfo.savedSizes[iChildToSave] = child.getSize();
                ++iChildToSave;
            }
            ++i;
        }
    }

    protected boolean isFocusAncestorA(Control control) {
        Display display = this.getDisplay();
        Control focusControl = display.getFocusControl();
        while (focusControl != null && focusControl != control) {
            focusControl = focusControl.getParent();
        }
        return control == focusControl;
    }

    protected void getNewSashArray(SashInfo sashInfo, int[] addArrowTypes, int[] drawArrowTypes) {
        int height;
        int width;
        int y;
        int x;
        int start;
        int[][] thisSash = sashInfo.sashLocs = (int[][])new int[addArrowTypes.length][];
        int aSize = 12;
        int tSize = aSize + 10;
        int neededSize = tSize * addArrowTypes.length;
        boolean vertical = this.getOrientation() == 512;
        Point s = sashInfo.sash.getSize();
        if (vertical) {
            x = start = (s.x - neededSize) / 2;
            y = (s.y - 5) / 2;
            width = tSize;
            height = aSize;
        } else {
            y = start = (s.y - neededSize) / 2;
            x = (s.x - 5) / 2;
            width = aSize;
            height = tSize;
        }
        int j = 0;
        while (j < addArrowTypes.length) {
            if (thisSash[j] == null) {
                thisSash[j] = new int[]{addArrowTypes[j], drawArrowTypes[j], x, y, width, height};
            } else {
                thisSash[j][0] = addArrowTypes[j];
                thisSash[j][1] = drawArrowTypes[j];
                thisSash[j][2] = x;
                thisSash[j][3] = y;
                thisSash[j][4] = width;
                thisSash[j][5] = height;
            }
            if (vertical) {
                x += tSize;
            } else {
                y += tSize;
            }
            ++j;
        }
    }

    protected void drawSashBorder(GC gc, SashInfo sashInfo) {
        gc.setForeground(this.arrowColor);
        gc.setLineStyle(1);
        Point s = sashInfo.sash.getSize();
        int[][] sashLocs = sashInfo.sashLocs;
        int lastLocIndex = sashLocs.length - 1;
        int sashDim = this.getSashWidth();
        if (this.getOrientation() == 512) {
            int leftArrowPos = sashLocs[0][2] - 5;
            int rightArrowPos = sashLocs[lastLocIndex][2] + sashLocs[lastLocIndex][5] + 15;
            gc.drawLine(0, sashDim / 2, leftArrowPos, sashDim / 2);
            gc.drawLine(rightArrowPos, sashDim / 2, s.x - 1, sashDim / 2);
            gc.drawRoundRectangle(leftArrowPos, 0, rightArrowPos - leftArrowPos, sashDim - 1, 3, 3);
        } else {
            int topArrowPos = sashLocs[0][3] - 5;
            int bottomArrowPos = sashLocs[lastLocIndex][3] + sashLocs[lastLocIndex][4] + 15;
            gc.drawLine(sashDim / 2, 0, sashDim / 2, topArrowPos);
            gc.drawLine(sashDim / 2, bottomArrowPos, sashDim / 2, s.y - 1);
            gc.drawRoundRectangle(0, topArrowPos, sashDim - 1, bottomArrowPos - topArrowPos, 3, 3);
        }
    }

    protected void drawArrow(GC gc, int[] sashLoc, boolean selected, boolean isSlammed) {
        int oldAntialias = gc.getAntialias();
        gc.setAntialias(1);
        int indent = 0;
        if (selected) {
            if (!this.inMouseClick) {
                Color highlightShadow = this.getDisplay().getSystemColor(20);
                this.getDisplay().getSystemColor(18);
                gc.setForeground(highlightShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
            } else {
                indent = 1;
                this.getDisplay().getSystemColor(20);
                Color normalShadow = this.getDisplay().getSystemColor(18);
                gc.setForeground(normalShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
            }
        }
        if (this.getOrientation() == 512) {
            switch (sashLoc[1]) {
                case 0: 
                case 3: {
                    this.drawUpArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: 
                case 2: {
                    this.drawDownArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        } else {
            switch (sashLoc[1]) {
                case 0: 
                case 3: {
                    this.drawLeftArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: 
                case 2: {
                    this.drawRightArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        }
        if (oldAntialias != 1) {
            gc.setAntialias(oldAntialias);
        }
    }

    protected void drawUpArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.setBackground(this.arrowColor);
        int[] triangle = new int[]{x + 5, y + 5 - 1, x + 5 + 12, y + 5 - 1, x + 5 + 6, y + 1};
        gc.drawPolygon(triangle);
        gc.fillPolygon(triangle);
    }

    protected void drawDownArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.setBackground(this.arrowColor);
        int[] triangle = new int[]{x + 5 - 1, y + 1, x + 5 + 12 - 1, y + 1, x + 5 + 6 - 1, y + 5 - 1};
        gc.drawPolygon(triangle);
        gc.fillPolygon(triangle);
    }

    protected void drawLeftArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.setBackground(this.arrowColor);
        int[] triangle = new int[]{x + 5 - 1, y + 5, x + 5 - 1, y + 5 + 12, x + 1, y + 5 + 6};
        gc.drawPolygon(triangle);
        gc.fillPolygon(triangle);
    }

    protected void drawRightArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.setBackground(this.arrowColor);
        int[] triangle = new int[]{x + 1, y + 5, x + 1, y + 5 + 12, x + 5 - 1, y + 5 + 6};
        gc.drawPolygon(triangle);
        gc.fillPolygon(triangle);
    }

    public int getRestoreWeight() {
        if (this.currentSashInfo != null) {
            return this.currentSashInfo.restoreWeight;
        }
        return -1;
    }

    public void setRestoreWeight(int weight) {
        if (weight >= 0 && this.currentSashInfo != null) {
            this.currentSashInfo.restoreWeight = weight;
        }
    }

    public Point[] getSavedSizes() {
        if (this.currentSashInfo != null) {
            return this.currentSashInfo.savedSizes;
        }
        return null;
    }

    public void addCustomSashFormListener(ICustomSashFormListener listener) {
        if (this.customSashFormListeners == null) {
            this.customSashFormListeners = new ArrayList<ICustomSashFormListener>();
        }
        this.customSashFormListeners.add(listener);
    }

    protected void fireDividerMoved() {
        int[] weights;
        if (this.customSashFormListeners != null && this.customSashFormListeners.size() > 0 && (weights = this.getWeights()) != null && weights.length == 2) {
            int firstControlWeight = weights[0];
            int secondControlWeight = weights[1];
            for (ICustomSashFormListener listener : this.customSashFormListeners) {
                listener.dividerMoved(firstControlWeight, secondControlWeight);
            }
        }
    }

    public static interface ICustomSashFormListener {
        public void dividerMoved(int var1, int var2);
    }

    private static class SashInfo {
        public Sash sash;
        public boolean enabled;
        public int restoreWeight = -1;
        public int cursorOver = -1;
        public boolean sashBorderLeft;
        public boolean sashBorderRight;
        public int[][] sashLocs;
        public Point[] savedSizes = new Point[2];

        public SashInfo(Sash sash) {
            this.sash = sash;
        }
    }
}

