/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePolicy;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreTablePolicyManager
extends SQLObjectEditor<PostgreTablePolicy, PostgreTable>
implements DBEObjectRenamer<PostgreTablePolicy> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTablePolicy> getObjectsCache(PostgreTablePolicy object) {
        return object.getParentObject().getPolicyCache();
    }

    protected PostgreTablePolicy createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreTable table = (PostgreTable)container;
        return new PostgreTablePolicy(table, DBUtils.makeNewObjectName((DBRProgressMonitor)monitor, (String)"Policy{0}", (DBSObject)table, PostgreTablePolicy.class, PostgreTable::getPolicy, (DBECommandContext)context));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        PostgreTablePolicy policy = (PostgreTablePolicy)command.getObject();
        StringJoiner sql = new StringJoiner("\n\t");
        sql.add("CREATE POLICY " + PostgreTablePolicyManager.getNameClause(policy));
        sql.add("AS " + (Object)((Object)policy.getType()));
        sql.add("FOR " + (Object)((Object)policy.getEvent()));
        if (policy.getRole() != null) {
            sql.add("TO " + DBUtils.getQuotedIdentifier((DBSObject)policy.getRole()));
        }
        if (CommonUtils.isNotEmpty((String)policy.getUsing())) {
            sql.add("USING (" + policy.getUsing() + ")");
        }
        if (CommonUtils.isNotEmpty((String)policy.getCheck())) {
            sql.add("WITH CHECK (" + policy.getCheck() + ")");
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create policy", sql.toString()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreTablePolicy policy = (PostgreTablePolicy)command.getObject();
        StringJoiner sql = new StringJoiner("\n\t");
        sql.add("ALTER POLICY " + PostgreTablePolicyManager.getNameClause(policy));
        if (command.hasProperty((Object)"role")) {
            sql.add("TO " + (policy.getRole() != null ? DBUtils.getQuotedIdentifier((DBSObject)policy.getRole()) : "PUBLIC"));
        }
        if (command.hasProperty((Object)"using")) {
            sql.add("USING (" + policy.getUsing() + ")");
        }
        if (command.hasProperty((Object)"check")) {
            sql.add("WITH CHECK (" + policy.getCheck() + ")");
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter policy", sql.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop policy", "DROP POLICY " + PostgreTablePolicyManager.getNameClause((PostgreTablePolicy)command.getObject())));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        DBPDataSource dataSource = ((PostgreTablePolicy)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename policy", "ALTER POLICY " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " ON " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)((PostgreTablePolicy)command.getObject()).getParentObject().getName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTablePolicy object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    @NotNull
    private static String getNameClause(@NotNull PostgreTablePolicy policy) {
        DBPDataSource dataSource = policy.getDataSource();
        return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)policy.getName())) + " ON " + DBUtils.getObjectFullName((DBPNamedObject)policy.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DDL);
    }
}

