/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.sql.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.osgi.framework.Bundle;

public class LSMDialectRegistry {
    static final String EXTENSION_ID = "org.jkiss.dbeaver.lsm.dialectSyntax";
    private static final Log log = Log.getLog(LSMDialectRegistry.class);
    private static LSMDialectRegistry instance = null;
    private final Map<Class<? extends SQLDialect>, LSMAnalyzer> knownLsmAnalyzerByDialects = new HashMap<Class<? extends SQLDialect>, LSMAnalyzer>();

    public static synchronized LSMDialectRegistry getInstance() {
        if (instance == null) {
            instance = new LSMDialectRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private LSMDialectRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID);
        Stream.of(extConfigs).filter(e -> "lsmDialect".equals(e.getName())).forEach(this::registerLsmDialect);
    }

    private void registerLsmDialect(IConfigurationElement dialectElt) {
        Bundle bundle = Platform.getBundle((String)dialectElt.getContributor().getName());
        try {
            LSMAnalyzer analyzer = (LSMAnalyzer)dialectElt.createExecutableExtension("analyzerClass");
            IConfigurationElement[] iConfigurationElementArray = dialectElt.getChildren("appliesTo");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement sqlDialectRef = iConfigurationElementArray[n2];
                String dialectClassName = sqlDialectRef.getAttribute("dialectClass");
                Class dialectType = AbstractDescriptor.getObjectClass((Bundle)bundle, (String)dialectClassName, SQLDialect.class);
                this.knownLsmAnalyzerByDialects.put(dialectType, analyzer);
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)("Failed to register LSM dialect " + dialectElt.getAttribute("analyzerClass")), (Throwable)e);
        }
    }

    public LSMAnalyzer getAnalyzerForDialect(SQLDialect dialect) {
        LSMAnalyzer analyzer;
        Class<?> dialectClass = dialect.getClass();
        do {
            analyzer = this.knownLsmAnalyzerByDialects.get(dialectClass);
            dialectClass = dialectClass.getSuperclass();
        } while (analyzer == null && dialectClass != null);
        return analyzer;
    }
}

