/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;

public class TextWithOpen
extends Composite {
    private final Text text;
    private final ToolBar toolbar;

    public TextWithOpen(Composite parent) {
        super(parent, 0);
        ToolItem toolItem;
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        boolean useTextEditor = this.isShowFileContentEditor();
        this.text = new Text((Composite)this, 0x800 | (useTextEditor ? 514 : 4));
        GridData gd = new GridData(772);
        if (useTextEditor) {
            gd.heightHint = this.text.getLineHeight();
        }
        this.text.setLayoutData((Object)gd);
        this.toolbar = new ToolBar((Composite)this, 0x800000);
        if (useTextEditor) {
            toolItem = new ToolItem(this.toolbar, 0);
            toolItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TEXTFIELD));
            toolItem.setToolTipText("Edit text");
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newText = EditTextDialog.editText(TextWithOpen.this.getShell(), "Edit text", TextWithOpen.this.getText());
                    if (newText != null) {
                        TextWithOpen.this.setText(newText);
                    }
                }
            });
        }
        toolItem = new ToolItem(this.toolbar, 0);
        toolItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        toolItem.setToolTipText("Browse");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextWithOpen.this.openBrowser();
            }
        });
        if (!useTextEditor && !this.isBinaryContents()) {
            ToolItem editItem = new ToolItem(this.toolbar, 0);
            editItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EDIT));
            editItem.setToolTipText("Edit file");
            editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String filePath = TextWithOpen.this.text.getText();
                    IFileStore store = EFS.getLocalFileSystem().getStore(Path.of(filePath, new String[0]).toUri());
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFileStore)store);
                    }
                    catch (Exception ex) {
                        DBWorkbench.getPlatformUI().showError("File open error", null, (Throwable)ex);
                    }
                }
            });
            this.text.addModifyListener(e -> {
                Path targetFile = Path.of(this.text.getText().trim(), new String[0]).toAbsolutePath();
                editItem.setEnabled(Files.exists(targetFile, new LinkOption[0]) && !Files.isDirectory(targetFile, new LinkOption[0]));
            });
            editItem.setEnabled(false);
        }
        gd = new GridData(66);
        this.toolbar.setLayoutData((Object)gd);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    protected boolean isShowFileContentEditor() {
        return false;
    }

    protected boolean isBinaryContents() {
        return false;
    }

    protected void openBrowser() {
    }

    public Text getTextControl() {
        return this.text;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.toolbar.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

