/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.ExternalContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueEditorPersistent;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.TextViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ContentInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ContentValueManager
extends BaseValueManager {
    private static final Log log = Log.getLog(ContentValueManager.class);
    public static final String PROP_CATEGORY_CONTENT = "CONTENT";

    public static void contributeContentActions(@NotNull IContributionManager manager, final @NotNull IValueController controller, final IValueEditor activeEditor) throws DBCException {
        if (controller.getValue() instanceof DBDContent) {
            if (!((DBDContent)controller.getValue()).isNull()) {
                manager.add((IAction)new Action(ResultSetMessages.model_jdbc_save_to_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_AS)){

                    public void run() {
                        ContentValueManager.saveToFile(controller);
                    }
                });
            }
            manager.add((IAction)new Action("Open in external editor", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILE)){

                public void run() {
                    try {
                        Object value = controller.getValue();
                        if (value == null) {
                            DBWorkbench.getPlatformUI().showError("Data is empty", "Can not save null data value");
                        }
                        if (value instanceof DBDContent) {
                            Path externalFilePath;
                            boolean isExternalFileOpened = false;
                            IStreamValueEditor<Control> streamEditor = ((ContentPanelEditor)activeEditor).getStreamEditor();
                            if (streamEditor instanceof IStreamValueEditorPersistent && (externalFilePath = ((IStreamValueEditorPersistent)streamEditor).getExternalFilePath(activeEditor.getControl())) != null) {
                                isExternalFileOpened = ContentValueManager.openExternalFile(externalFilePath);
                            }
                            if (!isExternalFileOpened) {
                                ContentValueManager.getDBDContent(value);
                            }
                        } else {
                            String str = controller.getValueHandler().getValueDisplayString(controller.getValueType(), controller.getValue(), DBDDisplayFormat.EDIT);
                            String charset = DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)controller.getExecutionContext().getDataSource());
                            byte[] bytes = str.getBytes(charset);
                            ContentValueManager.openOctetStream(bytes);
                        }
                    }
                    catch (IOException e) {
                        DBWorkbench.getPlatformUI().showError("Open content", "Error while trying to open the value", (Throwable)e);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error", "Unexpected error while trying to open the selected value", (Throwable)e);
                    }
                }
            });
            manager.add((IAction)new Action(ResultSetMessages.model_jdbc_load_from_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LOAD)){

                public void run() {
                    if (ContentValueManager.loadFromFile(controller) && activeEditor != null) {
                        try {
                            activeEditor.primeEditorValue(controller.getValue());
                        }
                        catch (DBException e) {
                            DBWorkbench.getPlatformUI().showError("Load from file", "Error loading contents from file", (Throwable)e);
                        }
                    }
                }
            });
            manager.add((IContributionItem)new Separator());
        }
    }

    private static boolean openExternalFile(@NotNull Path path) {
        return Files.exists(path, new LinkOption[0]) && ShellUtils.openExternalFile((Path)path);
    }

    private static void getDBDContent(Object value) throws IOException, DBCException {
        DBDContent content = (DBDContent)value;
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    DBDContentStorage storage = content.getContents(monitor);
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    if (storage != null) {
                        try {
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (InputStream inputStream = storage.getContentStream();){
                                ContentUtils.copyStreams((InputStream)inputStream, (long)-1L, (OutputStream)buffer, (DBRProgressMonitor)monitor);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            DBWorkbench.getPlatformUI().showError("IOException", "File exception", (Throwable)e);
                        }
                        storage.getCharset();
                    } else {
                        DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)content.getDataSource());
                    }
                    byte[] byteData = buffer.toByteArray();
                    ContentValueManager.openOctetStream(byteData);
                }
                catch (DBCException e1) {
                    DBWorkbench.getPlatformUI().showError("DBCException", "Error reading contents", (Throwable)e1);
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError("IOException", "File exception while opening", (Throwable)e);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Reading from content", "Error loading contents from file", (Throwable)e);
        }
    }

    private static void openOctetStream(byte[] data) throws IOException {
        File tmpFile = File.createTempFile("dbtmp", ".octet-stream");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        if (data == null) {
            DBWorkbench.getPlatformUI().showError("Open Content", "Raw value was null");
            fos.close();
        }
        if (data.length == 0) {
            log.info((Object)"file has no content");
            fos.close();
            tmpFile.delete();
        } else {
            fos.write(data);
            fos.close();
            if (RuntimeUtils.isWindows()) {
                UIUtils.syncExec(() -> {
                    try {
                        IFileStore store = EFS.getLocalFileSystem().getStore(tmpFile.toURI());
                        IDE.openEditorOnFileStore((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFileStore)store);
                    }
                    catch (CoreException e) {
                        log.error((Object)"Error while opening octet stream", (Throwable)e);
                    }
                });
            } else {
                ShellUtils.openExternalFile((Path)tmpFile.toPath());
            }
            tmpFile.deleteOnExit();
        }
    }

    public static IValueEditor openContentEditor(@NotNull IValueController controller) {
        Object value = controller.getValue();
        IValueController.EditType binaryEditType = IValueController.EditType.valueOf(controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getString("resultset.binary.editor"));
        if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
            return new TextViewDialog(controller);
        }
        if (binaryEditType != IValueController.EditType.EDITOR && value instanceof DBDContentCached) {
            return new TextViewDialog(controller);
        }
        if (value instanceof DBDContent) {
            return ContentEditor.openEditor(controller);
        }
        controller.showMessage(ResultSetMessages.model_jdbc_unsupported_content_value_type_, DBPMessageType.ERROR);
        return null;
    }

    public static boolean loadFromFile(IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(ResultSetMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return false;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        File openFile = DialogUtils.openFile((Shell)shell);
        if (openFile == null) {
            return false;
        }
        DBDContent value = (DBDContent)controller.getValue();
        UIUtils.runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), monitor -> {
            try {
                ExternalContentStorage storage = ContentUtils.isTextContent((DBDContent)value) ? new ExternalContentStorage(DBWorkbench.getPlatform(), openFile.toPath(), GeneralUtils.UTF8_ENCODING) : new ExternalContentStorage(DBWorkbench.getPlatform(), openFile.toPath());
                value.updateContents(monitor, (DBDContentStorage)storage);
                controller.updateValue(value, true);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        });
        return true;
    }

    public static void saveToFile(IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(ResultSetMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        File saveFile = DialogUtils.selectFileForSave((Shell)shell, (String)controller.getValueName());
        if (saveFile == null) {
            return;
        }
        DBDContent value = (DBDContent)controller.getValue();
        try {
            UIUtils.runInProgressService(monitor -> {
                block21: {
                    try {
                        DBDContentStorage storage = value.getContents(monitor);
                        if (ContentUtils.isTextContent((DBDContent)value)) {
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (Reader cr = storage.getContentReader();){
                                ContentUtils.saveContentToFile((Reader)cr, (File)saveFile, (String)GeneralUtils.UTF8_ENCODING, (DBRProgressMonitor)monitor);
                                break block21;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        Throwable throwable = null;
                        Object var5_11 = null;
                        try (InputStream cs = storage.getContentStream();){
                            ContentUtils.saveContentToFile((InputStream)cs, (File)saveFile, (DBRProgressMonitor)monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.model_jdbc_could_not_save_content, String.valueOf(ResultSetMessages.model_jdbc_could_not_save_content_to_file_) + saveFile.getAbsolutePath() + "'", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        super.contributeActions(manager, controller, activeEditor);
        ContentValueManager.contributeContentActions(manager, controller, activeEditor);
    }

    @Override
    public void contributeProperties(@NotNull DBPPropertyManager propertySource, @NotNull IValueController controller) {
        super.contributeProperties(propertySource, controller);
        try {
            Object value = controller.getValue();
            if (value instanceof DBDContent) {
                propertySource.addProperty(PROP_CATEGORY_CONTENT, "content_type", ResultSetMessages.model_jdbc_content_type, (Object)((DBDContent)value).getContentType());
                long contentLength = ((DBDContent)value).getContentLength();
                if (contentLength >= 0L) {
                    propertySource.addProperty(PROP_CATEGORY_CONTENT, "content_length", ResultSetMessages.model_jdbc_content_length, (Object)contentLength);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can't extract CONTENT value information", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: {
                Object value = controller.getValue();
                if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
                    return new StringInlineEditor(controller);
                }
                if (value instanceof DBDContentCached && ContentUtils.isTextValue((Object)((DBDContentCached)value).getCachedValue())) {
                    return new ContentInlineEditor(controller);
                }
                return null;
            }
            case EDITOR: {
                return ContentValueManager.openContentEditor(controller);
            }
            case PANEL: {
                return new ContentPanelEditor(controller);
            }
        }
        return null;
    }
}

