/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.vertica.ui.internal.VerticaUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class VerticaConnectionPageAdvanced
extends ConnectionPageAbstract {
    private Button disableCommentsReading;

    public VerticaConnectionPageAdvanced() {
        this.setTitle("Vertica");
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Group advancedSettings = new Group(group, 0);
        advancedSettings.setText(VerticaUIMessages.connection_page_group_performance);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        advancedSettings.setLayoutData((Object)gridData);
        advancedSettings.setLayout((Layout)new GridLayout(1, false));
        this.disableCommentsReading = UIUtils.createCheckbox((Composite)advancedSettings, (String)VerticaUIMessages.connection_page_group_checkbox_disable_comments, (String)VerticaUIMessages.connection_page_group_checkbox_disable_comments_tip, (boolean)false, (int)1);
        this.setControl((Control)group);
        this.loadSettings();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.disableCommentsReading.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("disable-comments-reading@")));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.disableCommentsReading != null) {
            connectionInfo.setProviderProperty("disable-comments-reading@", String.valueOf(this.disableCommentsReading.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    public boolean isComplete() {
        return true;
    }
}

