/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationConfigurator;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.fs.DBFRegistry;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskController;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.LocalConfigurationController;
import org.jkiss.dbeaver.registry.LocalFileController;
import org.jkiss.dbeaver.registry.LocalTaskController;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.registry.PluginServiceRegistry;
import org.jkiss.dbeaver.registry.datatype.DataTypeProviderRegistry;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.jobs.DataSourceMonitorJob;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.osgi.framework.Bundle;

public abstract class BasePlatformImpl
implements DBPPlatform,
DBPApplicationConfigurator {
    private static final Log log = Log.getLog(BasePlatformImpl.class);
    private static final String APP_CONFIG_FILE = "dbeaver.ini";
    private static final String ECLIPSE_CONFIG_FILE = "eclipse.ini";
    public static final String CONFIG_FOLDER = ".config";
    public static final String FILES_FOLDER = ".files";
    protected OSDescriptor localSystem;
    private DBNModel navigatorModel;
    private final List<IPluginService> activatedServices = new ArrayList<IPluginService>();
    private DBFileController localFileController;
    private DBTTaskController localTaskController;
    private DBConfigurationController defaultConfigurationController;
    private final Map<Bundle, DBConfigurationController> configurationControllerByPlugin = new HashMap<Bundle, DBConfigurationController>();

    protected void initialize() {
        log.debug((Object)"Initialize base platform...");
        DBPPreferenceStore prefsStore = this.getPreferenceStore();
        prefsStore.addPropertyChangeListener(event -> {
            for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                ((AbstractPreferenceStore)ds.getPreferenceStore()).firePropertyChangeEvent((Object)prefsStore, event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        });
        this.navigatorModel = new DBNModel((DBPPlatform)this, null);
        this.navigatorModel.setModelAuthContext(this.getWorkspace().getAuthContext());
        this.navigatorModel.initialize();
        if (!this.getApplication().isExclusiveMode()) {
            for (IPluginService pluginService : PluginServiceRegistry.getInstance().getServices()) {
                try {
                    pluginService.activateService();
                    this.activatedServices.add(pluginService);
                }
                catch (Throwable e) {
                    log.error((Object)"Error activating plugin service", e);
                }
            }
            new DataSourceMonitorJob((DBPPlatform)this).scheduleMonitor();
        }
    }

    public synchronized void dispose() {
        for (IPluginService pluginService : this.activatedServices) {
            try {
                pluginService.deactivateService();
            }
            catch (Exception e) {
                log.error((Object)"Error deactivating plugin service", (Throwable)e);
            }
        }
        this.activatedServices.clear();
        if (this.navigatorModel != null) {
            this.navigatorModel.dispose();
        }
    }

    @NotNull
    public DBDRegistry getValueHandlerRegistry() {
        return DataTypeProviderRegistry.getInstance();
    }

    @NotNull
    public DBERegistry getEditorsRegistry() {
        return ObjectManagerRegistry.getInstance();
    }

    @NotNull
    public DBFRegistry getFileSystemRegistry() {
        return FileSystemProviderRegistry.getInstance();
    }

    @NotNull
    public DBConfigurationController getConfigurationController() {
        return this.getPluginConfigurationController(null);
    }

    @NotNull
    public DBConfigurationController getProductConfigurationController() {
        return this.getConfigurationController(this.getProductPlugin().getBundle());
    }

    @NotNull
    public DBConfigurationController getPluginConfigurationController(@NotNull String pluginId) {
        return this.getConfigurationController(Platform.getBundle((String)pluginId));
    }

    private DBConfigurationController getConfigurationController(Bundle bundle) {
        DBConfigurationController controller;
        DBConfigurationController dBConfigurationController = controller = bundle == null ? this.defaultConfigurationController : this.configurationControllerByPlugin.get(bundle);
        if (controller == null) {
            controller = this.createConfigurationController(bundle);
            if (bundle == null) {
                this.defaultConfigurationController = controller;
            } else {
                this.configurationControllerByPlugin.put(bundle, controller);
            }
        }
        return controller;
    }

    @NotNull
    public DBConfigurationController createConfigurationController(@Nullable String pluginId) {
        return this.createConfigurationController(pluginId == null ? null : Platform.getBundle((String)pluginId));
    }

    @NotNull
    private DBConfigurationController createConfigurationController(@Nullable Bundle bundle) {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            String pluginBundleName = bundle == null ? null : bundle.getSymbolicName();
            return ((DBPApplicationConfigurator)application).createConfigurationController(pluginBundleName);
        }
        if (bundle == null) {
            LocalConfigurationController controller = new LocalConfigurationController(this.getWorkspace().getMetadataFolder().resolve(CONFIG_FOLDER));
            Plugin productPlugin = this.getProductPlugin();
            if (productPlugin != null && productPlugin.getStateLocation() != null) {
                controller.setLegacyConfigFolder(productPlugin.getStateLocation().toFile().toPath());
            }
            return controller;
        }
        return new LocalConfigurationController(Platform.getStateLocation((Bundle)bundle).toFile().toPath());
    }

    @NotNull
    public DBFileController getFileController() {
        if (this.localFileController == null) {
            this.localFileController = this.createFileController();
        }
        return this.localFileController;
    }

    @NotNull
    public DBFileController createFileController() {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            return ((DBPApplicationConfigurator)application).createFileController();
        }
        return new LocalFileController(this.getWorkspace().getMetadataFolder().resolve(FILES_FOLDER));
    }

    @NotNull
    public Path getLocalConfigurationFile(String fileName) {
        return this.getProductPlugin().getStateLocation().toFile().toPath().resolve(fileName);
    }

    @NotNull
    public DBTTaskController getTaskController() {
        if (this.localTaskController == null) {
            this.localTaskController = this.createTaskController();
        }
        return this.localTaskController;
    }

    public DBTTaskController createTaskController() {
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationConfigurator) {
            return ((DBPApplicationConfigurator)application).createTaskController();
        }
        return new LocalTaskController();
    }

    protected abstract Plugin getProductPlugin();

    @NotNull
    public Path getApplicationConfiguration() {
        Path configPath;
        try {
            configPath = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't detect application installation folder.", e);
        }
        Path iniFile = configPath.resolve(ECLIPSE_CONFIG_FILE);
        if (!Files.exists(iniFile, new LinkOption[0])) {
            iniFile = configPath.resolve(APP_CONFIG_FILE);
        }
        return iniFile;
    }

    @NotNull
    public OSDescriptor getLocalSystem() {
        if (this.localSystem == null) {
            this.localSystem = new OSDescriptor(Platform.getOS(), Platform.getOSArch());
        }
        return this.localSystem;
    }

    @NotNull
    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    @NotNull
    public DBPDataSourceProviderRegistry getDataSourceProviderRegistry() {
        return DataSourceProviderRegistry.getInstance();
    }
}

