/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.ui.command.EntityAddCommand;
import org.jkiss.dbeaver.erd.ui.command.EntityRemoveCommand;
import org.jkiss.dbeaver.erd.ui.figures.EntityDiagramFigure;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.layout.DelegatingLayoutManager;
import org.jkiss.dbeaver.erd.ui.layout.GraphAnimation;
import org.jkiss.dbeaver.erd.ui.layout.GraphLayoutAuto;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.part.NotePart;
import org.jkiss.dbeaver.erd.ui.part.PropertyAwarePart;
import org.jkiss.dbeaver.erd.ui.policy.DiagramContainerEditPolicy;
import org.jkiss.dbeaver.erd.ui.router.MikamiTabuchiConnectionRouter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DiagramPart
extends PropertyAwarePart {
    private final CommandStackEventListener stackListener = new CommandStackEventListener(){

        /*
         * Unable to fully structure code
         */
        public void stackChanged(CommandStackEvent commandStackEvent) {
            block2: {
                block1: {
                    if (!(DiagramPart.this.delegatingLayoutManager.getActiveLayoutManager() instanceof GraphLayoutAuto)) break block1;
                    if (GraphAnimation.captureLayout(DiagramPart.this.getFigure())) ** GOTO lbl5
                    return;
lbl-1000:
                    // 1 sources

                    {
                        DiagramPart.this.getFigure().getUpdateManager().performUpdate();
lbl5:
                        // 2 sources

                        ** while (GraphAnimation.step())
                    }
lbl6:
                    // 1 sources

                    GraphAnimation.end();
                    break block2;
                }
                DiagramPart.this.getFigure().getUpdateManager().performUpdate();
            }
        }
    };
    private DelegatingLayoutManager delegatingLayoutManager;
    private Font normalFont;
    private Font boldFont;
    private Font italicFont;
    private Font boldItalicFont;

    @Override
    public void activate() {
        super.activate();
        this.getViewer().getEditDomain().getCommandStack().addCommandStackEventListener(this.stackListener);
    }

    @Override
    protected boolean isListensModelChanges() {
        return true;
    }

    @Override
    public void deactivate() {
        this.resetFonts();
        this.getViewer().getEditDomain().getCommandStack().removeCommandStackEventListener(this.stackListener);
        super.deactivate();
    }

    public void performRequest(Request request) {
        this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
    }

    public void resetFonts() {
        UIUtils.dispose((Resource)this.boldFont);
        UIUtils.dispose((Resource)this.italicFont);
        UIUtils.dispose((Resource)this.boldItalicFont);
        this.normalFont = null;
        this.boldFont = null;
        this.italicFont = null;
        this.boldItalicFont = null;
    }

    protected IFigure createFigure() {
        EntityDiagramFigure figure = new EntityDiagramFigure(this);
        this.delegatingLayoutManager = new DelegatingLayoutManager(this);
        figure.setLayoutManager(this.delegatingLayoutManager);
        Control control = this.getViewer().getControl();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((control.getStyle() & 0x8000000) == 0) {
            cLayer.setAntialias(1);
        }
        FanRouter router = new FanRouter();
        router.setSeparation(15);
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        if (store.getString("erd.routing.type").equals("Mikami-Tabuchi (Experimental)")) {
            router.setNextRouter((ConnectionRouter)new MikamiTabuchiConnectionRouter((IFigure)figure));
        } else {
            router.setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)figure));
        }
        cLayer.setConnectionRouter((ConnectionRouter)router);
        return figure;
    }

    @Override
    @NotNull
    public EntityDiagram getDiagram() {
        return (EntityDiagram)this.getModel();
    }

    public Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.getViewer().getControl().getFont();
        }
        return this.normalFont;
    }

    public Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = UIUtils.makeBoldFont((Font)this.getNormalFont());
        }
        return this.boldFont;
    }

    public Font getItalicFont() {
        if (this.italicFont == null) {
            this.italicFont = UIUtils.modifyFont((Font)this.getNormalFont(), (int)2);
        }
        return this.italicFont;
    }

    public Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = UIUtils.modifyFont((Font)this.getNormalFont(), (int)3);
        }
        return this.boldItalicFont;
    }

    public void rearrangeDiagram() {
        for (Object part : this.getChildren()) {
            if (!(part instanceof NodePart)) continue;
            this.resetConnectionConstraints(((NodePart)part).getSourceConnections());
        }
        this.delegatingLayoutManager.rearrange(this.getFigure());
        this.getFigure().repaint();
    }

    private void resetConnectionConstraints(List sourceConnections) {
        if (!CommonUtils.isEmpty((Collection)sourceConnections)) {
            for (Object sc : sourceConnections) {
                if (!(sc instanceof AbstractConnectionEditPart)) continue;
                ((AbstractConnectionEditPart)sc).getConnectionFigure().setRoutingConstraint(null);
                if (!(sc instanceof AssociationPart)) continue;
                ((AssociationPart)sc).getAssociation().setInitBends(null);
                ((AssociationPart)sc).setConnectionRouting((PolylineConnection)((AbstractConnectionEditPart)sc).getConnectionFigure());
            }
        }
    }

    protected List<?> getModelChildren() {
        return this.getDiagram().getContents();
    }

    public boolean isSelectable() {
        return false;
    }

    protected void createEditPolicies() {
        if (!this.getEditor().isReadOnly()) {
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DiagramContainerEditPolicy());
            this.installEditPolicy("LayoutEditPolicy", null);
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public void setTableModelBounds() {
        List entityParts = this.getChildren();
        for (Object child : entityParts) {
            NodePart entityPart;
            IFigure entityFigure;
            if (!(child instanceof NodePart) || (entityFigure = (entityPart = (NodePart)child).getFigure()) == null) continue;
            Rectangle bounds = entityFigure.getBounds().getCopy();
            entityPart.setBounds(bounds);
        }
    }

    public boolean setTableFigureBounds(boolean updateConstraint) {
        List nodeParts = this.getChildren();
        for (Object child : nodeParts) {
            if (!(child instanceof NodePart)) continue;
            NodePart entityPart = (NodePart)child;
            Rectangle bounds = entityPart.getBounds();
            if (bounds == null) {
                return false;
            }
            IFigure entityFigure = entityPart.getFigure();
            if (entityFigure == null) {
                return false;
            }
            if (!updateConstraint) continue;
            this.delegatingLayoutManager.setXYLayoutConstraint(entityFigure, new Rectangle(bounds.x, bounds.y, -1, -1));
        }
        return true;
    }

    public void changeLayout() {
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        super.setLayoutConstraint(child, childFigure, constraint);
    }

    @Override
    protected void handleChildChange(PropertyChangeEvent evt) {
        super.handleChildChange(evt);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
            if (store.getBoolean("erd.grid.enabled") && store.getBoolean("erd.grid.snap")) {
                return new SnapToGrid((GraphicalEditPart)this);
            }
            return null;
        }
        return super.getAdapter(key);
    }

    @Nullable
    public NodePart getChildByObject(Object object) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodePart) || ((NodePart)child).getElement().getObject() != object) continue;
            return (NodePart)child;
        }
        return null;
    }

    @Nullable
    public EntityPart getEntityPart(ERDEntity erdEntity) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart) || ((EntityPart)child).getEntity() != erdEntity) continue;
            return (EntityPart)child;
        }
        return null;
    }

    public List<EntityPart> getEntityParts() {
        ArrayList<EntityPart> result = new ArrayList<EntityPart>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart)) continue;
            result.add((EntityPart)child);
        }
        return result;
    }

    @Nullable
    public NotePart getNotePart(ERDNote erdNote) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NotePart) || ((NotePart)child).getNote() != erdNote) continue;
            return (NotePart)child;
        }
        return null;
    }

    @NotNull
    public Command createEntityAddCommand(List<ERDEntity> entities, Point location) {
        return new EntityAddCommand(this, entities, location);
    }

    public Command createEntityDeleteCommand(EntityPart entityPart) {
        return new EntityRemoveCommand(entityPart);
    }

    public String toString() {
        return String.valueOf(ERDUIMessages.entity_diagram_) + " " + this.getDiagram().getName();
    }
}

