/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.registry.ToolGroupDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class ToolDescriptor
extends AbstractContextDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType toolType;
    private final DBPImage icon;
    private final boolean singleton;
    private final ToolGroupDescriptor group;

    public ToolDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.toolType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.singleton = CommonUtils.toBoolean((Object)config.getAttribute("singleton"));
        String groupId = config.getAttribute("group");
        this.group = CommonUtils.isEmpty((String)groupId) ? null : ToolsRegistry.getInstance().getToolGroup(groupId);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public ToolGroupDescriptor getGroup() {
        return this.group;
    }

    protected Object adaptType(DBPObject object) {
        if (object instanceof DBSObject) {
            return ((DBSObject)object).getDataSource();
        }
        return super.adaptType(object);
    }

    public IUserInterfaceTool createTool() throws DBException {
        return (IUserInterfaceTool)this.toolType.createInstance(IUserInterfaceTool.class);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.label + ")";
    }
}

