/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AttributeMetaDataProxy
implements DBCAttributeMetaData,
DBPImageProvider {
    @NotNull
    protected final DBSAttributeBase attribute;

    public AttributeMetaDataProxy(@NotNull DBSAttributeBase attribute) {
        this.attribute = attribute;
    }

    @NotNull
    public DBSAttributeBase getProxyAttribute() {
        return this.attribute;
    }

    @Override
    public int getOrdinalPosition() {
        return this.attribute.getOrdinalPosition();
    }

    @Override
    public boolean isRequired() {
        return this.attribute.isRequired();
    }

    @Override
    public boolean isAutoGenerated() {
        return this.attribute.isAutoGenerated();
    }

    @Override
    @Nullable
    public DBSObject getSource() {
        if (this.attribute instanceof DBSObject) {
            return ((DBSObject)((Object)this.attribute)).getParentObject();
        }
        return null;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.attribute.getName();
    }

    @Override
    @Nullable
    public String getEntityName() {
        DBSObject source = this.getSource();
        if (source instanceof DBSEntity) {
            return source.getName();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @Nullable
    public DBCEntityMetaData getEntityMetaData() {
        DBSAttributeBase proxyAttribute = this.getProxyAttribute();
        if (proxyAttribute instanceof DBCAttributeMetaData) {
            return ((DBCAttributeMetaData)proxyAttribute).getEntityMetaData();
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.attribute.getName();
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        return DBValueFormatting.getObjectImage(this.attribute);
    }

    @Override
    public String getTypeName() {
        return this.attribute.getTypeName();
    }

    @Override
    public String getFullTypeName() {
        return this.attribute.getFullTypeName();
    }

    @Override
    public int getTypeID() {
        return this.attribute.getTypeID();
    }

    @Override
    public DBPDataKind getDataKind() {
        return this.attribute.getDataKind();
    }

    @Override
    public Integer getScale() {
        return this.attribute.getScale();
    }

    @Override
    public Integer getPrecision() {
        return this.attribute.getPrecision();
    }

    @Override
    public long getMaxLength() {
        return this.attribute.getMaxLength();
    }

    @Override
    public long getTypeModifiers() {
        return this.attribute.getTypeModifiers();
    }

    public String toString() {
        return this.attribute.toString();
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AttributeMetaDataProxy && this.attribute.equals(((AttributeMetaDataProxy)obj).attribute);
    }
}

