/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.network;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;

public class NetworkHandlerRegistry {
    private static NetworkHandlerRegistry instance = null;
    private final List<NetworkHandlerDescriptor> descriptors = new ArrayList<NetworkHandlerDescriptor>();

    public static synchronized NetworkHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new NetworkHandlerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private NetworkHandlerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.networkHandler");
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            NetworkHandlerDescriptor formatterDescriptor = new NetworkHandlerDescriptor(ext);
            this.descriptors.add(formatterDescriptor);
            ++n2;
        }
        block1: for (NetworkHandlerDescriptor hd1 : this.descriptors) {
            for (NetworkHandlerDescriptor hd2 : this.descriptors) {
                if (!hd2.replaces(hd1)) continue;
                hd1.setReplacedBy(hd2);
                continue block1;
            }
        }
        this.descriptors.sort(Comparator.comparingInt(NetworkHandlerDescriptor::getOrder));
    }

    public List<NetworkHandlerDescriptor> getDescriptors() {
        ArrayList<NetworkHandlerDescriptor> descList = new ArrayList<NetworkHandlerDescriptor>(this.descriptors);
        descList.removeIf(nhd -> nhd.getReplacedBy() != null);
        return descList;
    }

    public NetworkHandlerDescriptor getDescriptor(String id) {
        for (NetworkHandlerDescriptor descriptor : this.descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            if (descriptor.getReplacedBy() != null) {
                return descriptor.getReplacedBy();
            }
            return descriptor;
        }
        return null;
    }

    public List<NetworkHandlerDescriptor> getDescriptors(DBPDataSourceContainer dataSource) {
        return this.getDescriptors(dataSource.getDriver());
    }

    public List<NetworkHandlerDescriptor> getDescriptors(DBPDriver driver) {
        ArrayList<NetworkHandlerDescriptor> result = new ArrayList<NetworkHandlerDescriptor>();
        for (NetworkHandlerDescriptor d : this.descriptors) {
            if ((d.getReplacedBy() != null || d.hasObjectTypes()) && !d.matches(driver)) continue;
            result.add(d);
        }
        return result;
    }
}

