/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.DCTDecode;
import com.fluendo.jheora.ExtractMVectorComponent;
import com.fluendo.jheora.ExtractMVectorComponentA;
import com.fluendo.jheora.ExtractMVectorComponentB;
import com.fluendo.jheora.HuffEntry;
import com.fluendo.jheora.MotionVector;
import com.fluendo.jheora.Playback;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Buffer;

public final class Decode {
    private static final ExtractMVectorComponent MVA = new ExtractMVectorComponentA();
    private static final ExtractMVectorComponent MVB = new ExtractMVectorComponentB();
    private static final CodingMode[][] modeAlphabet = new CodingMode[][]{{CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_INTRA, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTRA, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_INTRA, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTRA, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTRA, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTRA, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}, {CodingMode.CODE_INTER_NO_MV, CodingMode.CODE_USING_GOLDEN, CodingMode.CODE_INTER_LAST_MV, CodingMode.CODE_INTER_PRIOR_LAST, CodingMode.CODE_INTER_PLUS_MV, CodingMode.CODE_INTRA, CodingMode.CODE_GOLDEN_MV, CodingMode.CODE_INTER_FOURMV}};
    private int BlocksToDecode;
    private int EOB_Run;
    private DCTDecode dctDecode = new DCTDecode();
    private byte[] FragCoeffs;
    private MotionVector LastInterMV = new MotionVector();
    private MotionVector PriorLastInterMV = new MotionVector();
    private Playback pbi;

    public Decode(Playback playback) {
        this.FragCoeffs = new byte[playback.UnitFragments];
        this.pbi = playback;
    }

    private int longRunBitStringDecode() {
        Buffer buffer = this.pbi.opb;
        int n = buffer.readB(1);
        if (n == 0) {
            return 1;
        }
        n = buffer.readB(2);
        if ((n & 2) == 0) {
            return 2 + n;
        }
        if ((n & 1) == 0) {
            n = buffer.readB(1);
            return 4 + n;
        }
        n = buffer.readB(3);
        if ((n & 4) == 0) {
            return 6 + n;
        }
        if ((n & 2) == 0) {
            int n2 = 10 + ((n & 1) << 2);
            n = buffer.readB(2);
            return n2 + n;
        }
        if ((n & 1) == 0) {
            n = buffer.readB(4);
            return 18 + n;
        }
        n = buffer.readB(12);
        return 34 + n;
    }

    private void decodeBlockLevelQi() {
        block11: {
            boolean bl;
            int n;
            int n2;
            block10: {
                n2 = this.pbi.CodedBlockIndex;
                if (n2 <= 0) {
                    return;
                }
                if (this.pbi.frameNQIS != 1) break block10;
                int n3 = 0;
                while (n3 < n2) {
                    this.pbi.FragQs[this.pbi.CodedBlockList[n3]] = 0;
                    ++n3;
                }
                break block11;
            }
            Buffer buffer = this.pbi.opb;
            int n4 = n = buffer.readB(1);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                n6 = this.longRunBitStringDecode();
                bl = n6 >= 4129;
                do {
                    this.pbi.FragQs[this.pbi.CodedBlockList[n7++]] = (byte)n4;
                    if (n4 >= 1) continue;
                    ++n5;
                } while (--n6 > 0 && n7 < n2);
                if (bl && n7 < n2) {
                    n4 = n = buffer.readB(1);
                    continue;
                }
                int n8 = n4 = n4 != 0 ? 0 : 1;
            }
            if (this.pbi.frameNQIS != 3 || n5 >= n2) break block11;
            n7 = 0;
            n7 = 0;
            while (n7 < n2 && this.pbi.FragQs[this.pbi.CodedBlockList[n7]] == 0) {
                ++n7;
            }
            n4 = n = buffer.readB(1);
            while (n7 < n2) {
                n6 = this.longRunBitStringDecode();
                bl = n6 >= 4129;
                while (n7 < n2) {
                    if (this.pbi.FragQs[this.pbi.CodedBlockList[n7]] != 0) {
                        if (n6-- <= 0) break;
                        int n9 = this.pbi.CodedBlockList[n7];
                        this.pbi.FragQs[n9] = (byte)(this.pbi.FragQs[n9] + n4);
                    }
                    ++n7;
                }
                if (bl && n7 < n2) {
                    n4 = n = buffer.readB(1);
                    continue;
                }
                int n10 = n4 = n4 != 0 ? 0 : 1;
            }
        }
    }

    private int loadFrame() {
        int n;
        Buffer buffer = this.pbi.opb;
        this.pbi.FrameType = (byte)buffer.readB(1);
        this.pbi.frameQIS[0] = n = buffer.readB(6);
        this.pbi.frameNQIS = 1;
        int n2 = buffer.readB(1);
        if (n2 > 0) {
            this.pbi.frameQIS[1] = buffer.readB(6);
            this.pbi.frameNQIS = 2;
            n2 = buffer.readB(1);
            if (n2 > 0) {
                this.pbi.frameQIS[2] = buffer.readB(6);
                this.pbi.frameNQIS = 3;
            }
        }
        if (this.pbi.FrameType == 0) {
            this.pbi.KeyFrameType = (byte)buffer.readB(1);
            buffer.readB(2);
        }
        this.pbi.frArray.quadDecodeDisplayFragments(this.pbi);
        return 1;
    }

    private void decodeModes(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Object[] objectArray = this.pbi.FragCodingMethod;
        if (this.pbi.getFrameType() == 0) {
            MemUtils.set(objectArray, 0, CodingMode.CODE_INTRA, this.pbi.UnitFragments);
        } else {
            CodingMode[] codingModeArray;
            MemUtils.set(objectArray, 0, CodingMode.CODE_INTER_NO_MV, this.pbi.UnitFragments);
            long l = this.pbi.opb.readB(3);
            int n5 = (int)l;
            if (n5 == 0) {
                CodingMode[] codingModeArray2 = new CodingMode[8];
                int n6 = 0;
                while (n6 < 8) {
                    l = this.pbi.opb.readB(3);
                    codingModeArray2[(int)l] = CodingMode.MODES[n6];
                    ++n6;
                }
                codingModeArray = codingModeArray2;
            } else {
                codingModeArray = modeAlphabet[n5 - 1];
            }
            int n7 = 0;
            while (n7 < n) {
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = 0;
                    while (n9 < 4) {
                        int n10 = this.pbi.BlockMap.quadMapToMBTopLeft(n3, n9);
                        if (n10 >= 0 && this.pbi.MBCodedFlags[n4++] != 0) {
                            CodingMode codingMode;
                            if (n5 == 7) {
                                l = this.pbi.opb.readB(3);
                                codingMode = CodingMode.MODES[(int)l];
                            } else {
                                CodingMode codingMode2 = this.pbi.frArray.unpackMode(this.pbi.opb);
                                codingMode = codingModeArray[codingMode2.getValue()];
                            }
                            objectArray[n10] = codingMode;
                            objectArray[n10 + 1] = codingMode;
                            objectArray[n10 + this.pbi.HFragments] = codingMode;
                            objectArray[n10 + this.pbi.HFragments + 1] = codingMode;
                            int n11 = n10 / (this.pbi.HFragments * 2);
                            int n12 = n10 % this.pbi.HFragments / 2;
                            int n13 = n11 * (this.pbi.HFragments / 2) + n12;
                            objectArray[this.pbi.YPlaneFragments + n13] = codingMode;
                            objectArray[this.pbi.YPlaneFragments + this.pbi.UVPlaneFragments + n13] = codingMode;
                        }
                        ++n9;
                    }
                    ++n3;
                    ++n8;
                }
                ++n7;
            }
        }
    }

    private void decodeMVectors(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Buffer buffer = this.pbi.opb;
        if (this.pbi.getFrameType() == 0) {
            return;
        }
        this.LastInterMV.x = 0;
        this.LastInterMV.y = 0;
        this.PriorLastInterMV.x = 0;
        this.PriorLastInterMV.y = 0;
        ExtractMVectorComponent extractMVectorComponent = buffer.readB(1) == 0 ? MVA : MVB;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < 4) {
                    int n8 = this.pbi.BlockMap.quadMapToMBTopLeft(n3, n7);
                    if (n8 >= 0 && this.pbi.MBCodedFlags[n4++] != 0) {
                        CodingMode codingMode = this.pbi.FragCodingMethod[n8];
                        MotionVector motionVector = this.pbi.FragMVect[n8];
                        MotionVector motionVector2 = this.pbi.FragMVect[n8 + 1];
                        MotionVector motionVector3 = this.pbi.FragMVect[n8 + this.pbi.HFragments];
                        MotionVector motionVector4 = this.pbi.FragMVect[n8 + this.pbi.HFragments + 1];
                        int n9 = n8 / (this.pbi.HFragments * 2);
                        int n10 = n8 % this.pbi.HFragments / 2;
                        int n11 = n9 * (this.pbi.HFragments / 2) + n10;
                        MotionVector motionVector5 = this.pbi.FragMVect[this.pbi.YPlaneFragments + n11];
                        MotionVector motionVector6 = this.pbi.FragMVect[this.pbi.YPlaneFragments + this.pbi.UVPlaneFragments + n11];
                        if (codingMode == CodingMode.CODE_INTER_PLUS_MV) {
                            this.PriorLastInterMV.x = this.LastInterMV.x;
                            this.PriorLastInterMV.y = this.LastInterMV.y;
                            motionVector5.x = motionVector6.x = extractMVectorComponent.extract(buffer);
                            motionVector4.x = motionVector6.x;
                            motionVector3.x = motionVector6.x;
                            motionVector2.x = motionVector6.x;
                            motionVector.x = motionVector6.x;
                            this.LastInterMV.x = motionVector6.x;
                            motionVector5.y = motionVector6.y = extractMVectorComponent.extract(buffer);
                            motionVector4.y = motionVector6.y;
                            motionVector3.y = motionVector6.y;
                            motionVector2.y = motionVector6.y;
                            motionVector.y = motionVector6.y;
                            this.LastInterMV.y = motionVector6.y;
                        } else if (codingMode == CodingMode.CODE_GOLDEN_MV) {
                            motionVector5.x = motionVector6.x = extractMVectorComponent.extract(buffer);
                            motionVector4.x = motionVector6.x;
                            motionVector3.x = motionVector6.x;
                            motionVector2.x = motionVector6.x;
                            motionVector.x = motionVector6.x;
                            motionVector5.y = motionVector6.y = extractMVectorComponent.extract(buffer);
                            motionVector4.y = motionVector6.y;
                            motionVector3.y = motionVector6.y;
                            motionVector2.y = motionVector6.y;
                            motionVector.y = motionVector6.y;
                        } else if (codingMode == CodingMode.CODE_INTER_FOURMV) {
                            int n12;
                            int n13;
                            this.PriorLastInterMV.x = this.LastInterMV.x;
                            this.PriorLastInterMV.y = this.LastInterMV.y;
                            if (this.pbi.display_fragments[n8] != 0) {
                                n13 = motionVector.x = extractMVectorComponent.extract(buffer);
                                n12 = motionVector.y = extractMVectorComponent.extract(buffer);
                                this.LastInterMV.x = motionVector.x;
                                this.LastInterMV.y = motionVector.y;
                            } else {
                                motionVector.x = 0;
                                n13 = 0;
                                motionVector.y = 0;
                                n12 = 0;
                            }
                            if (this.pbi.display_fragments[n8 + 1] != 0) {
                                motionVector2.x = extractMVectorComponent.extract(buffer);
                                n13 += motionVector2.x;
                                motionVector2.y = extractMVectorComponent.extract(buffer);
                                n12 += motionVector2.y;
                                this.LastInterMV.x = motionVector2.x;
                                this.LastInterMV.y = motionVector2.y;
                            } else {
                                motionVector2.x = 0;
                                n13 += 0;
                                motionVector2.y = 0;
                                n12 += 0;
                            }
                            if (this.pbi.display_fragments[n8 + this.pbi.HFragments] != 0) {
                                motionVector3.x = extractMVectorComponent.extract(buffer);
                                n13 += motionVector3.x;
                                motionVector3.y = extractMVectorComponent.extract(buffer);
                                n12 += motionVector3.y;
                                this.LastInterMV.x = motionVector3.x;
                                this.LastInterMV.y = motionVector3.y;
                            } else {
                                motionVector3.x = 0;
                                n13 += 0;
                                motionVector3.y = 0;
                                n12 += 0;
                            }
                            if (this.pbi.display_fragments[n8 + this.pbi.HFragments + 1] != 0) {
                                motionVector4.x = extractMVectorComponent.extract(buffer);
                                n13 += motionVector4.x;
                                motionVector4.y = extractMVectorComponent.extract(buffer);
                                n12 += motionVector4.y;
                                this.LastInterMV.x = motionVector4.x;
                                this.LastInterMV.y = motionVector4.y;
                            } else {
                                motionVector4.x = 0;
                                n13 += 0;
                                motionVector4.y = 0;
                                n12 += 0;
                            }
                            n13 = n13 >= 0 ? (n13 + 2) / 4 : (n13 - 2) / 4;
                            motionVector5.x = n13;
                            motionVector6.x = n13;
                            n12 = n12 >= 0 ? (n12 + 2) / 4 : (n12 - 2) / 4;
                            motionVector5.y = n12;
                            motionVector6.y = n12;
                        } else if (codingMode == CodingMode.CODE_INTER_LAST_MV) {
                            motionVector5.x = motionVector6.x = this.LastInterMV.x;
                            motionVector4.x = motionVector6.x;
                            motionVector3.x = motionVector6.x;
                            motionVector2.x = motionVector6.x;
                            motionVector.x = motionVector6.x;
                            motionVector5.y = motionVector6.y = this.LastInterMV.y;
                            motionVector4.y = motionVector6.y;
                            motionVector3.y = motionVector6.y;
                            motionVector2.y = motionVector6.y;
                            motionVector.y = motionVector6.y;
                        } else if (codingMode == CodingMode.CODE_INTER_PRIOR_LAST) {
                            motionVector5.x = motionVector6.x = this.PriorLastInterMV.x;
                            motionVector4.x = motionVector6.x;
                            motionVector3.x = motionVector6.x;
                            motionVector2.x = motionVector6.x;
                            motionVector.x = motionVector6.x;
                            motionVector5.y = motionVector6.y = this.PriorLastInterMV.y;
                            motionVector4.y = motionVector6.y;
                            motionVector3.y = motionVector6.y;
                            motionVector2.y = motionVector6.y;
                            motionVector.y = motionVector6.y;
                            MotionVector motionVector7 = this.PriorLastInterMV;
                            this.PriorLastInterMV = this.LastInterMV;
                            this.LastInterMV = motionVector7;
                        } else {
                            motionVector.x = 0;
                            motionVector.y = 0;
                        }
                    }
                    ++n7;
                }
                ++n3;
                ++n6;
            }
            ++n5;
        }
    }

    private final int ExtractToken(Buffer buffer, HuffEntry huffEntry) {
        while (huffEntry.value < 0) {
            huffEntry = huffEntry.Child[buffer.readB(1)];
        }
        return huffEntry.value;
    }

    private void unpackAndExpandToken(short[] sArray, byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.ExtractToken(this.pbi.opb, this.pbi.HuffRoot_VP3x[n2]);
        if (this.pbi.ExtraBitLengths_VP3x[n4] > 0) {
            n3 = this.pbi.opb.readB(this.pbi.ExtraBitLengths_VP3x[n4]);
        }
        if (n4 >= 7) {
            this.dctDecode.ExpandToken(sArray, byArray, n, n4, n3);
            if (byArray[n] >= 64) {
                --this.BlocksToDecode;
            }
        } else {
            switch (n4) {
                case 1: {
                    this.EOB_Run = 1;
                    break;
                }
                case 2: {
                    this.EOB_Run = 2;
                    break;
                }
                case 3: {
                    this.EOB_Run = n3 + 3;
                    break;
                }
                case 4: {
                    this.EOB_Run = n3 + 7;
                    break;
                }
                case 5: {
                    this.EOB_Run = n3 + 15;
                    break;
                }
                case 6: {
                    this.EOB_Run = n3 - 1;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    return;
                }
            }
            byArray[n] = 64;
            --this.BlocksToDecode;
        }
    }

    private void unPackVideo() {
        int n;
        byte by = 1;
        if (this.pbi.DecoderErrorCode != 0) {
            return;
        }
        MemUtils.set(this.FragCoeffs, 0, 0, this.pbi.UnitFragments);
        MemUtils.set(this.pbi.FragCoefEOB, 0, 0, this.pbi.UnitFragments);
        this.BlocksToDecode = this.pbi.CodedBlockIndex;
        int n2 = this.pbi.opb.readB(4) + 0;
        int n3 = this.pbi.opb.readB(4) + 0;
        int n4 = 0;
        int n5 = this.pbi.CodedBlockIndex;
        while (n4 < n5) {
            n = this.pbi.CodedBlockList[n4];
            this.pbi.FragCoefEOB[n] = this.FragCoeffs[n];
            int n6 = n < this.pbi.YPlaneFragments ? n2 : n3;
            if (this.EOB_Run != 0) {
                this.FragCoeffs[n] = 64;
                --this.EOB_Run;
                --this.BlocksToDecode;
            } else {
                this.unpackAndExpandToken(this.pbi.QFragData[n], this.FragCoeffs, n, n6);
            }
            ++n4;
        }
        int n7 = this.pbi.opb.readB(4) + 16;
        int n8 = this.pbi.opb.readB(4) + 16;
        while (by < 64) {
            int n9;
            int n10;
            n4 = 0;
            n5 = this.pbi.CodedBlockIndex;
            if (by <= 5) {
                n10 = n7;
                n9 = n8;
            } else if (by <= 14) {
                n10 = n7 + 16;
                n9 = n8 + 16;
            } else if (by <= 27) {
                n10 = n7 + 32;
                n9 = n8 + 32;
            } else {
                n10 = n7 + 48;
                n9 = n8 + 48;
            }
            while (n4 < n5) {
                n = this.pbi.CodedBlockList[n4];
                if (this.FragCoeffs[n] <= by) {
                    this.pbi.FragCoefEOB[n] = this.FragCoeffs[n];
                    if (this.EOB_Run != 0) {
                        this.FragCoeffs[n] = 64;
                        --this.EOB_Run;
                        --this.BlocksToDecode;
                    } else {
                        int n11 = n < this.pbi.YPlaneFragments ? n10 : n9;
                        this.unpackAndExpandToken(this.pbi.QFragData[n], this.FragCoeffs, n, n11);
                    }
                }
                ++n4;
            }
            if (this.BlocksToDecode == 0) break;
            ++by;
        }
    }

    public int loadAndDecode() {
        int n = this.loadFrame();
        if (n != 0) {
            if (this.pbi.DecoderErrorCode != 0) {
                return 0;
            }
            this.EOB_Run = 0;
            this.pbi.CodedBlocksThisFrame = this.pbi.CodedBlockIndex;
            this.decodeModes(this.pbi.YSBRows, this.pbi.YSBCols);
            this.decodeMVectors(this.pbi.YSBRows, this.pbi.YSBCols);
            this.decodeBlockLevelQi();
            this.unPackVideo();
            this.dctDecode.ReconRefFrames(this.pbi);
            return 0;
        }
        return -24;
    }
}

