#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hauma - A Detective Noir Story
# send your bug reports to contact@dotslashplay.it
###

script_version=20241211.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='hauma-a-detective-noir-story'
GAME_NAME='Hauma - A Detective Noir Story'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_1_NAME='setup_hauma_-_a_detective_noir_story_1.05_(74220).exe'
ARCHIVE_BASE_1_MD5='6780baacc12416f1c53e070195c53def'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_hauma_-_a_detective_noir_story_1.05_(74220)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='abe2aeeb9b4f38ee18d47fbec2795bf1'
ARCHIVE_BASE_1_SIZE='2119600'
ARCHIVE_BASE_1_VERSION='1.05-gog74220'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/hauma_a_detective_noir_story'

ARCHIVE_BASE_0_NAME='setup_hauma_-_a_detective_noir_story_1.04_(69325).exe'
ARCHIVE_BASE_0_MD5='e6fc035ebe25667b38c3a2d7e4b37bb7'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_hauma_-_a_detective_noir_story_1.04_(69325)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='45212abd3511d32f07b5cd03a09ef370'
ARCHIVE_BASE_0_SIZE='2118754'
ARCHIVE_BASE_0_VERSION='1.04-gog69325'

ARCHIVE_BASE_DEMO_0_NAME='setup_hauma_-_a_detective_noir_story_demo_1.00_(67500).exe'
ARCHIVE_BASE_DEMO_0_MD5='1c227ca038d28e96d78d81f616536b62'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_hauma_-_a_detective_noir_story_demo_1.00_(67500)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='a6a708237c1df4de6008862d9c92fc30'
ARCHIVE_BASE_DEMO_0_SIZE='2118728'
ARCHIVE_BASE_DEMO_0_VERSION='1.00-gog67500'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/hauma_a_detective_noir_story_demo'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
settings.cfg
fmod.dll
fmodstudio.dll
libgodotfmod.windows.release.64.dll
hauma.exe'
CONTENT_GAME_DATA_FILES='
hauma.pck'
## The game crashes on launch if the Steam libraries are not available.
CONTENT_GAME0_BIN_FILES='
godotsteam.dll
steam_api64.dll'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Godot/app_userdata/Hauma'

USER_PERSISTENT_FILES='
settings.cfg'

APP_MAIN_EXE='hauma.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
