info = {
    "name": "ru",
    "date_order": "DMY",
    "january": [
        "янв",
        "январь",
        "января"
    ],
    "february": [
        "февр",
        "февраль",
        "февраля",
        "Фев"
    ],
    "march": [
        "мар",
        "март",
        "марта"
    ],
    "april": [
        "апр",
        "апрель",
        "апреля"
    ],
    "may": [
        "май",
        "мая"
    ],
    "june": [
        "июн",
        "июнь",
        "июня"
    ],
    "july": [
        "июл",
        "июль",
        "июля"
    ],
    "august": [
        "авг",
        "август",
        "августа"
    ],
    "september": [
        "сент",
        "сентябрь",
        "сентября",
        "Сен"
    ],
    "october": [
        "окт",
        "октябрь",
        "октября"
    ],
    "november": [
        "нояб",
        "ноябрь",
        "ноября",
        "Ноя"
    ],
    "december": [
        "дек",
        "декабрь",
        "декабря"
    ],
    "monday": [
        "пн",
        "понедельник",
        "пнд"
    ],
    "tuesday": [
        "вт",
        "вторник",
        "втр"
    ],
    "wednesday": [
        "ср",
        "среда",
        "срд",
        "среду"
    ],
    "thursday": [
        "четверг",
        "чт",
        "чтв"
    ],
    "friday": [
        "пт",
        "пятница",
        "птн",
        "пятницу"
    ],
    "saturday": [
        "сб",
        "суббота",
        "сбт",
        "субботу"
    ],
    "sunday": [
        "воскресенье",
        "вс",
        "воскресение",
        "вск"
    ],
    "am": [
        "дп"
    ],
    "pm": [
        "пп"
    ],
    "year": [
        "г",
        "год",
        "года",
        "году",
        "лет"
    ],
    "month": [
        "мес",
        "месяц",
        "месяца",
        "месяцев"
    ],
    "week": [
        "нед",
        "неделя",
        "недели",
        "недель",
        "неделю"
    ],
    "day": [
        "день",
        "дн",
        "дня",
        "дней",
        "сутки",
        "суток"
    ],
    "hour": [
        "ч",
        "час",
        "часа",
        "часов"
    ],
    "minute": [
        "мин",
        "минута",
        "минуты",
        "минут",
        "минуту"
    ],
    "second": [
        "с",
        "сек",
        "секунда",
        "секунды",
        "секунд",
        "секунду"
    ],
    "relative-type": {
        "0 day ago": [
            "сегодня"
        ],
        "0 hour ago": [
            "в этом часе"
        ],
        "0 minute ago": [
            "в эту минуту"
        ],
        "0 month ago": [
            "в этом месяце"
        ],
        "0 second ago": [
            "сейчас"
        ],
        "0 week ago": [
            "на этой неделе"
        ],
        "0 year ago": [
            "в этом году"
        ],
        "1 day ago": [
            "вчера"
        ],
        "1 month ago": [
            "в прошлом месяце"
        ],
        "1 week ago": [
            "на прошлой неделе"
        ],
        "1 year ago": [
            "в прошлом году"
        ],
        "in 1 day": [
            "завтра"
        ],
        "in 1 month": [
            "в следующем месяце"
        ],
        "in 1 week": [
            "на следующей неделе"
        ],
        "in 1 year": [
            "в следующем году"
        ],
        "2 day ago": [
            "позавчера"
        ],
        "in 2 day": [
            "послезавтра"
        ],
        "in 3 day": [
            "послепослезавтра"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) д назад",
            "(\\d+[.,]?\\d*) день назад",
            "(\\d+[.,]?\\d*) дн назад",
            "(\\d+[.,]?\\d*) дня назад"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) ч назад",
            "(\\d+[.,]?\\d*) час назад",
            "(\\d+[.,]?\\d*) часа назад"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) мин назад",
            "(\\d+[.,]?\\d*) минуту назад",
            "(\\d+[.,]?\\d*) минуты назад"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) мес назад",
            "(\\d+[.,]?\\d*) месяц назад",
            "(\\d+[.,]?\\d*) месяца назад"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) сек назад",
            "(\\d+[.,]?\\d*) секунду назад",
            "(\\d+[.,]?\\d*) секунды назад"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) нед назад",
            "(\\d+[.,]?\\d*) недели назад",
            "(\\d+[.,]?\\d*) неделю назад"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) г назад",
            "(\\d+[.,]?\\d*) год назад",
            "(\\d+[.,]?\\d*) года назад"
        ],
        "in \\1 day": [
            "через (\\d+[.,]?\\d*) д",
            "через (\\d+[.,]?\\d*) день",
            "через (\\d+[.,]?\\d*) дн",
            "через (\\d+[.,]?\\d*) дня"
        ],
        "in \\1 hour": [
            "через (\\d+[.,]?\\d*) ч",
            "через (\\d+[.,]?\\d*) час",
            "через (\\d+[.,]?\\d*) часа"
        ],
        "in \\1 minute": [
            "через (\\d+[.,]?\\d*) мин",
            "через (\\d+[.,]?\\d*) минуту",
            "через (\\d+[.,]?\\d*) минуты"
        ],
        "in \\1 month": [
            "через (\\d+[.,]?\\d*) мес",
            "через (\\d+[.,]?\\d*) месяц",
            "через (\\d+[.,]?\\d*) месяца"
        ],
        "in \\1 second": [
            "через (\\d+[.,]?\\d*) сек",
            "через (\\d+[.,]?\\d*) секунду",
            "через (\\d+[.,]?\\d*) секунды"
        ],
        "in \\1 week": [
            "через (\\d+[.,]?\\d*) нед",
            "через (\\d+[.,]?\\d*) недели",
            "через (\\d+[.,]?\\d*) неделю"
        ],
        "in \\1 year": [
            "через (\\d+[.,]?\\d*) г",
            "через (\\d+[.,]?\\d*) год",
            "через (\\d+[.,]?\\d*) года"
        ]
    },
    "locale_specific": {
        "ru-BY": {
            "name": "ru-BY"
        },
        "ru-KG": {
            "name": "ru-KG"
        },
        "ru-KZ": {
            "name": "ru-KZ"
        },
        "ru-MD": {
            "name": "ru-MD"
        },
        "ru-UA": {
            "name": "ru-UA",
            "am": [
                "am"
            ],
            "pm": [
                "pm"
            ]
        }
    },
    "skip": [
        "в",
        "во",
        "и",
        "около",
        "примерно",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "назад"
    ],
    "in": [
        "в течение",
        "спустя",
        "через"
    ],
    "simplifications": [
        {
            "од(ин|на|ну|ни|ной|ною|но|ного|ному|ним|нем)": "1"
        },
        {
            "перв(ой|ого|ому|ым|ом|ая|ую|ое|ые|ых|ыми)": "1"
        },
        {
            "дв(а|е|ух|ум|умя|ое)": "2"
        },
        {
            "пар(а|ы|е|у|ой|ою|ам|ами|ах)": "2"
        },
        {
            "втор(ой|ого|ому|ым|ом|ая|ую|ое|ые|ых|ыми)": "2"
        },
        {
            "тр(и|ёх|ем|ём|емя|етье)": "3"
        },
        {
            "трети(й|его|ему|им|ем|я|ей|ею|ую|е|и|их|ими)": "3"
        },
        {
            "четыр(е|ёх|ем|ём|ьмя)": "4"
        },
        {
            "четвёрт(ый|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "4"
        },
        {
            "четверт(ый|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "4"
        },
        {
            "пят(ь|и|ью)": "5"
        },
        {
            "пят(ый|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "5"
        },
        {
            "шест(ь|и|ью)": "6"
        },
        {
            "шест(ый|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "6"
        },
        {
            "сем(ь|и|ью)": "7"
        },
        {
            "седьм(ой|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "7"
        },
        {
            "восьм(и|ью|ьею)|восем(ь|ью)": "8"
        },
        {
            "восьм(ой|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "8"
        },
        {
            "девят(ь|и|ью)": "9"
        },
        {
            "девят(ый|ого|ому|ым|ом|ая|ой|ою|ую|ое|ые|ых|ыми)": "9"
        },
        {
            "десять": "10"
        },
        {
            "одиннадцать": "11"
        },
        {
            "двенадцать": "12"
        },
        {
            "пятнадцать": "15"
        },
        {
            "двадцат(ь|ое)": "20"
        },
        {
            "тридцат(ь|ое)": "30"
        },
        {
            "соро(к|ка|ковое)": "40"
        },
        {
            "пятьдесят": "50"
        },
        {
            "пятидесятое": "50"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)секунд[уы]|(?<=[^\\d]\\s+|^)секунду(?=(\\s+назад)))": "1 секунду"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)минут[уы]|(?<=[^\\d]\\s+|^)минуту(?=(\\s+назад)))": "1 минуту"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)часа?|(?<=[^\\d]\\s+|^)час(?=(\\s+назад)))": "1 час"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)(день|дня)|(?<=[^\\d]\\s+|^)день(?=(\\s+назад)))": "1 день"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)сут(ки|ок)|(?<=[^\\d]\\s+|^)сутки(?=(\\s+назад)))": "1 сутки"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)недел[юи]|(?<=[^\\d]\\s+|^)неделю(?=(\\s+назад)))": "1 неделю"
        },
        {
            "полгода": "6 месяцев"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)месяца?|(?<=[^\\d]\\s+|^)месяц(?=(\\s+назад)))": "1 месяц"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)года?|(?<=[^\\d]\\s+|^)год(?=(\\s+назад)))": "1 год"
        },
        {
            "полтора года": "18 месяцев"
        },
        {
            "полчаса": "30 минут"
        },
        {
            "несколько секунд": "44 секунды"
        },
        {
            "полтора часа": "90 минут"
        },
        {
            "(\\d{3,}1)\\s*год\\s*$": "\\1"
        },
        {
            "(\\d*[02-9])\\s*год\\b": "\\1"
        }
    ]
}
