<?php

/*
 | !!!! DO NOT EDIT THIS FILE !!!!
 |
 | You can change settings by setting them in the environment or .env
 | If there is something you need to change, but is not available as an environment setting,
 | request an environment variable to be created upstream or send a pull request.
 */

use Illuminate\Support\Str;

return [
    'default' => env('DB_CONNECTION', env('DBTEST') ? 'testing' : 'mysql'),

    'connections' => [
        'mysql' => [
            'driver' => 'mysql',
            'url' => env('DB_URL'),
            'host' => env('DB_HOST', 'localhost'),
            'port' => env('DB_PORT', '3306'),
            'database' => env('DB_DATABASE', 'librenms'),
            'username' => env('DB_USERNAME', 'librenms'),
            'password' => env('DB_PASSWORD', ''),
            'unix_socket' => env('DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => null,
            'sslmode' => env('DB_SSLMODE', 'disabled'),
            'options' => extension_loaded('pdo_mysql') ? [
                PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT => env('MYSQL_ATTR_SSL_VERIFY_SERVER_CERT', false),
            ] + array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
                PDO::MYSQL_ATTR_SSL_CERT => env('MYSQL_ATTR_SSL_CERT'),
                PDO::MYSQL_ATTR_SSL_KEY => env('MYSQL_ATTR_SSL_KEY'),
            ]) : [],
        ],

        'mysql_cluster' => [
            'read' => [
                'host' => [
                    env('DB_HOST', 'localhost'),
                    env('DB_HOST_R2', ''),
                    env('DB_HOST_R3', ''),
                    env('DB_HOST_R4', ''),
                    env('DB_HOST_R5', ''),
                    env('DB_HOST_R6', ''),
                    env('DB_HOST_R7', ''),
                    env('DB_HOST_R8', ''),
                    env('DB_HOST_R9', ''),
                ],
            ],
            'write' => [
                'host' => [
                    env('DB_HOST', 'localhost'),
                    env('DB_HOST_W2', ''),
                    env('DB_HOST_W3', ''),
                    env('DB_HOST_W4', ''),
                    env('DB_HOST_W5', ''),
                    env('DB_HOST_W6', ''),
                    env('DB_HOST_W7', ''),
                    env('DB_HOST_W8', ''),
                    env('DB_HOST_W9', ''),
                ],
            ],
            'sticky' => env('DB_STICKY', null),
            'driver' => 'mysql',
            'host' => env('DB_HOST', 'localhost'),
            'port' => env('DB_PORT', '3306'),
            'database' => env('DB_DATABASE', 'librenms'),
            'username' => env('DB_USERNAME', 'librenms'),
            'password' => env('DB_PASSWORD', ''),
            'unix_socket' => env('DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => null,
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'testing' => [
            'driver' => env('DB_TEST_DRIVER', 'mysql'),
            'host' => env('DB_TEST_HOST', 'localhost'),
            'port' => env('DB_TEST_PORT', '3306'),
            'database' => env('DB_TEST_DATABASE', 'librenms_phpunit_78hunjuybybh'),
            'username' => env('DB_TEST_USERNAME', 'root'),
            'password' => env('DB_TEST_PASSWORD', ''),
            'unix_socket' => env('DB_TEST_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'strict' => true,
            'engine' => null,
        ],

        'testing_memory' => [
            'driver' => 'sqlite',
            'database' => ':memory:',
            'prefix' => '',
            'foreign_key_constraints' => true,
        ],

        'testing_persistent' => [
            'driver' => 'sqlite',
            'database' => database_path('testing.sqlite'),
            'prefix' => '',
            'foreign_key_constraints' => true,
        ],
    ],

    'migrations' => [
        'table' => 'migrations',
        'update_date_on_publish' => false, // disable to preserve original behavior for existing applications
    ],

    'redis' => [

        'client' => env('REDIS_CLIENT', 'predis'),

        'options' => [
            'prefix' => env('REDIS_PREFIX', Str::slug(env('APP_NAME', 'laravel'), '_') . '_database_'),
        ],

        'default' => [
            'scheme' => env('REDIS_SCHEME', 'tcp'),

            'url' => env('REDIS_URL'),
            'host' => env('REDIS_HOST', '127.0.0.1'),
            'username' => env('REDIS_USERNAME'),
            'password' => env('REDIS_PASSWORD'),
            'port' => env('REDIS_PORT', '6379'),
            'database' => env('REDIS_DB', '0'),
        ],

        'cache' => [
            'scheme' => env('REDIS_SCHEME', 'tcp'),
            'url' => env('REDIS_URL'),
            'host' => env('REDIS_HOST', '127.0.0.1'),
            'username' => env('REDIS_USERNAME'),
            'password' => env('REDIS_PASSWORD'),
            'port' => env('REDIS_PORT', '6379'),
            'database' => env('REDIS_CACHE_DB', '1'),
        ],

        'sentinel_session' => [
            ...explode(',', (string) env('REDIS_SENTINEL_HOSTS', '')),
            'options' => [
                'replication' => 'sentinel',
                'service' => env('REDIS_SENTINEL_SERVICE', 'mymaster'),
                'parameters' => [
                    'password' => env('REDIS_PASSWORD', ''),
                    'database' => env('REDIS_SESSION_DB', '0'),
                ],
            ],
        ],

        'sentinel_cache' => [
            ...explode(',', (string) env('REDIS_SENTINEL_HOSTS', '')),
            'options' => [
                'replication' => 'sentinel',
                'service' => env('REDIS_SENTINEL_SERVICE', 'mymaster'),
                'parameters' => [
                    'password' => env('REDIS_PASSWORD', ''),
                    'database' => env('REDIS_CACHE_DB', '1'),
                ],
            ],
        ],

    ],

];
