/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.multiview.EditorsAction;
import org.netbeans.core.multiview.MultiViewElementCallbackDelegate;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.multiview.MultiViewTopComponentLookup;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.multiview.SplitAction;
import org.netbeans.core.multiview.Splitable;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.Actions;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public final class MultiViewTopComponent
extends TopComponent
implements MultiViewModel.ActionRequestObserverFactory,
Splitable {
    MultiViewPeer peer = new MultiViewPeer(this, this);
    private Action[] superActions4Tests = null;

    public MultiViewTopComponent() {
        this.peer.initComponents();
        this.associateLookup(this.peer.getLookup());
        this.setName("");
        this.setFocusCycleRoot(false);
    }

    public <T extends Serializable & Lookup.Provider> void setMimeLookup(String string, T t) {
        this.peer.setMimeLookup(string, t);
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        this.peer.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        this.peer.setCloseOperationHandler(closeOperationHandler);
    }

    private void setDeserializedMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, Map map) {
        this.peer.setDeserializedMultiViewDescriptions(-1, multiViewDescriptionArray, multiViewDescription, null, map);
    }

    MultiViewModel getModel() {
        return this.peer.getModel();
    }

    public Lookup getLookup() {
        this.peer.assignLookup((MultiViewTopComponentLookup)super.getLookup());
        return super.getLookup();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.peer.peerComponentClosed();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.peer.peerComponentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.peer.peerComponentHidden();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.peer.peerComponentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.peer.peerComponentActivated();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.peer.peerComponentOpened();
    }

    public Action[] getActions() {
        Action[] actionArray = this.superActions4Tests == null ? super.getActions() : this.superActions4Tests;
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(this.peer.peerGetActions(actionArray)));
        if (!arrayList.isEmpty()) {
            arrayList.add(null);
        }
        arrayList.add(new EditorsAction());
        if (this.canSplit()) {
            arrayList.add(new SplitAction(true));
        }
        return arrayList.toArray(new Action[0]);
    }

    @Override
    public boolean canSplit() {
        return null != this.peer.model && this.peer.model.canSplit();
    }

    void setSuperActions(Action[] actionArray) {
        this.superActions4Tests = actionArray;
    }

    public MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return this.peer.getMultiViewHandlerDelegate();
    }

    public int getPersistenceType() {
        return this.peer.getPersistenceType();
    }

    protected String preferredID() {
        return this.peer.preferredID();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.peer.peerWriteExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.peer.peerReadExternal(objectInput);
    }

    Action[] getDefaultTCActions() {
        return super.getActions();
    }

    @Override
    public MultiViewElementCallback createElementCallback(MultiViewDescription multiViewDescription) {
        return SpiAccessor.DEFAULT.createCallback(new ActReqObserver(multiViewDescription));
    }

    public HelpCtx getHelpCtx() {
        return this.peer.getHelpCtx();
    }

    public String toString() {
        return "MultiViewTopComponent[name=" + this.getDisplayName() + ", peer=" + this.peer + "]";
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.peer.peerGetUndoRedo();
        if (undoRedo == null) {
            undoRedo = super.getUndoRedo();
        }
        return undoRedo;
    }

    public boolean canClose() {
        return this.peer.canClose();
    }

    public boolean requestFocusInWindow() {
        return this.peer.requestFocusInWindow();
    }

    public void requestFocus() {
        this.peer.requestFocus();
    }

    public TopComponent.SubComponent[] getSubComponents() {
        return MultiViewTopComponent.getSubComponents(this.peer);
    }

    static TopComponent.SubComponent[] getSubComponents(final MultiViewPeer multiViewPeer) {
        MultiViewModel multiViewModel = multiViewPeer.getModel();
        MultiViewPerspective[] multiViewPerspectiveArray = multiViewModel.getPerspectives();
        ArrayList<TopComponent.SubComponent> arrayList = new ArrayList<TopComponent.SubComponent>(multiViewPerspectiveArray.length);
        for (int i = 0; i < multiViewPerspectiveArray.length; ++i) {
            ContextAwareDescription contextAwareDescription;
            final MultiViewPerspective multiViewPerspective = multiViewPerspectiveArray[i];
            MultiViewDescription multiViewDescription = Accessor.DEFAULT.extractDescription(multiViewPerspective);
            if (multiViewDescription instanceof ContextAwareDescription && (contextAwareDescription = (ContextAwareDescription)multiViewDescription).isSplitDescription() && !multiViewPeer.tabs.isShowing(multiViewDescription)) continue;
            contextAwareDescription = multiViewDescription == null ? multiViewPeer.getLookup() : (multiViewModel.getElementForDescription(multiViewDescription, false) == null ? multiViewPeer.getLookup() : multiViewModel.getElementForDescription(multiViewDescription, false).getLookup());
            boolean bl = multiViewPeer.tabs.isShowing(multiViewDescription);
            arrayList.add(new TopComponent.SubComponent(Actions.cutAmpersand((String)multiViewPerspective.getDisplayName()), null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    multiViewPeer.getMultiViewHandlerDelegate().requestActive(multiViewPerspective);
                }
            }, multiViewPerspective == multiViewModel.getSelectedPerspective(), (Lookup)contextAwareDescription, bl));
        }
        return arrayList.toArray(new TopComponent.SubComponent[0]);
    }

    @Override
    public TopComponent splitComponent(int n, int n2) {
        this.peer.peerSplitComponent(n, n2);
        return this;
    }

    @Override
    public TopComponent clearSplit(int n) {
        this.peer.peerClearSplit(n);
        return this;
    }

    @Override
    public int getSplitOrientation() {
        return this.peer.getSplitOrientation();
    }

    class ActReqObserver
    implements Serializable,
    MultiViewElementCallbackDelegate {
        private static final long serialVersionUID = -3126744916624172415L;
        private MultiViewDescription description;

        ActReqObserver(MultiViewDescription multiViewDescription) {
            this.description = multiViewDescription;
        }

        @Override
        public void requestActive() {
            boolean bl = MultiViewTopComponent.this.peer.isActivated();
            if (!bl) {
                MultiViewTopComponent.this.requestActive();
            }
            if (MultiViewTopComponent.this.peer.model.getActiveDescription() != this.description) {
                MultiViewTopComponent.this.peer.tabs.changeActiveManually(this.description);
                if (bl) {
                    MultiViewTopComponent.this.peer.model.getActiveElement().componentActivated();
                }
            }
        }

        @Override
        public void requestVisible() {
            MultiViewTopComponent.this.peer.tabs.changeVisibleManually(this.description);
        }

        @Override
        public Action[] createDefaultActions() {
            return MultiViewTopComponent.this.getDefaultTCActions();
        }

        @Override
        public void updateTitle(String string) {
            MultiViewTopComponent.this.setDisplayName(string);
        }

        public Object writeReplace() throws ObjectStreamException {
            return null;
        }

        public Object readResolve() throws ObjectStreamException {
            return null;
        }

        @Override
        public boolean isSelectedElement() {
            return this.description.equals(MultiViewTopComponent.this.peer.model.getActiveDescription());
        }

        @Override
        public TopComponent getTopComponent() {
            return MultiViewTopComponent.this;
        }
    }
}

