/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.BaseRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.RelativeRenderer;

public class BarRenderer
extends BaseRenderer
implements RelativeRenderer {
    private static final Color COLOR_POS = new Color(225, 130, 130);
    private static final Color COLOR_NEG = new Color(130, 225, 130);
    private static final int X_MARGIN = 2;
    private static final int Y_MARGIN = 3;
    private static final Rectangle BAR_RECT = new Rectangle();
    private long maxValue = 100L;
    private float value = 0.0f;
    protected boolean renderingDiff;
    private static final double FACTOR = 0.55;

    public BarRenderer() {
        this.setOpaque(true);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setValue(Object value, int row) {
        this.value = value == null ? 0.0f : (this.maxValue == 0L ? 0.0f : ((Number)value).floatValue() / (float)this.maxValue);
    }

    @Override
    public void setDiffMode(boolean diffMode) {
        this.renderingDiff = diffMode;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        BarRenderer.BAR_RECT.x = this.location.x + 2;
        BarRenderer.BAR_RECT.y = this.location.y + 3;
        BarRenderer.BAR_RECT.height = this.size.height - 6;
        int width = this.size.width - 4;
        if (this.renderingDiff) {
            Color color = this.value < 0.0f ? COLOR_NEG : COLOR_POS;
            int width2 = width / 2;
            if (this.value <= -1.0f) {
                g.setColor(color);
                g.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, width2, BarRenderer.BAR_RECT.height);
                g.setColor(BarRenderer.alternate(color));
                g.fillRect(BarRenderer.BAR_RECT.x + width2, BarRenderer.BAR_RECT.y, width - width2, BarRenderer.BAR_RECT.height);
            } else if (this.value >= 1.0f) {
                g.setColor(BarRenderer.alternate(color));
                g.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, width2, BarRenderer.BAR_RECT.height);
                g.setColor(color);
                g.fillRect(BarRenderer.BAR_RECT.x + width2, BarRenderer.BAR_RECT.y, width - width2, BarRenderer.BAR_RECT.height);
            } else {
                g.setColor(BarRenderer.alternate(color));
                g.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, width, BarRenderer.BAR_RECT.height);
                BarRenderer.BAR_RECT.width = (int)((float)width2 * Math.min(Math.abs(this.value), 1.0f));
                if (BarRenderer.BAR_RECT.width > 0) {
                    g.setColor(color);
                    if (this.value < 0.0f) {
                        g.fillRect(BarRenderer.BAR_RECT.x + width2 - BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
                    } else {
                        g.fillRect(BarRenderer.BAR_RECT.x + width2, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
                    }
                }
            }
        } else {
            BarRenderer.BAR_RECT.width = (int)((float)width * Math.min(this.value, 1.0f));
            if (BarRenderer.BAR_RECT.width > 0) {
                g.setColor(COLOR_POS);
                g.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
            }
            if (BarRenderer.BAR_RECT.width < width) {
                BarRenderer.BAR_RECT.x += BarRenderer.BAR_RECT.width;
                BarRenderer.BAR_RECT.width = width - BarRenderer.BAR_RECT.width;
                g.setColor(BarRenderer.alternate(COLOR_POS));
                g.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
            }
        }
    }

    private static Color alternate(Color c) {
        return !UIUtils.isDarkResultsBackground() ? BarRenderer.brighter(c) : BarRenderer.darker(c);
    }

    private static Color brighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 2;
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.55), 255), Math.min((int)((double)g / 0.55), 255), Math.min((int)((double)b / 0.55), 255));
    }

    private static Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.55), 0), Math.max((int)((double)c.getGreen() * 0.55), 0), Math.max((int)((double)c.getBlue() * 0.55), 0));
    }
}

