/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk11.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.Experimental;
import jdk.jfr.ValueDescriptor;
import org.graalvm.visualvm.jfr.jdk11.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREventType;

final class JFRJDK11EventType
extends JFREventType {
    private final EventType type;

    JFRJDK11EventType(EventType type) {
        this.type = type;
    }

    public long getId() {
        return this.type.getId();
    }

    public String getName() {
        return this.type.getName();
    }

    public String getDisplayName() {
        return this.isExperimental() ? "[Experimental] " + this.type.getLabel() : this.type.getLabel();
    }

    public String getDescription() {
        return this.type.getDescription();
    }

    public List<String> getCategory() {
        return this.type.getCategoryNames();
    }

    public boolean isExperimental() {
        return this.type.getAnnotation(Experimental.class) != null;
    }

    public List<JFRDataDescriptor> getDisplayableDataDescriptors(boolean includeExperimental) {
        ArrayList<JFRDataDescriptor> ddescriptors = new ArrayList<JFRDataDescriptor>();
        Iterator<ValueDescriptor> vdescriptors = DisplayableSupport.displayableValueDescriptors(this.type, includeExperimental);
        while (vdescriptors.hasNext()) {
            ddescriptors.add(DisplayableSupport.getDataDescriptor(vdescriptors.next()));
        }
        return ddescriptors;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRJDK11EventType ? this.type.equals(((JFRJDK11EventType)((Object)o)).type) : false;
    }
}

