/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class InstrumentMethodGroupData {
    protected int[] instrMethodClassLoaderIds;
    protected String[] instrMethodClasses;
    protected boolean[] instrMethodLeaf;
    protected byte[][] replacementClassFileBytes;
    protected int addInfo;
    protected int nClasses;
    protected int nMethods;

    public InstrumentMethodGroupData(String[] instrMethodClasses, int[] instrMethodClassLoaderIds, byte[][] replacementClassFileBytes, boolean[] instrMethodLeaf, int addInfo) {
        this.nClasses = instrMethodClasses.length;
        this.nMethods = instrMethodLeaf != null ? instrMethodLeaf.length : 0;
        this.instrMethodClasses = instrMethodClasses;
        this.instrMethodClassLoaderIds = instrMethodClassLoaderIds;
        this.replacementClassFileBytes = replacementClassFileBytes;
        this.addInfo = addInfo;
    }

    InstrumentMethodGroupData() {
    }

    public int getAddInfo() {
        return this.addInfo;
    }

    public int[] getClassLoaderIds() {
        return this.instrMethodClassLoaderIds;
    }

    public boolean[] getInstrMethodLeaf() {
        return this.instrMethodLeaf;
    }

    public String[] getMethodClasses() {
        return this.instrMethodClasses;
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public int getNMethods() {
        return this.nMethods;
    }

    public byte[][] getReplacementClassFileBytes() {
        return this.replacementClassFileBytes;
    }

    public void dump() {
        if (this.instrMethodClasses == null) {
            System.err.println("0 classes --");
            return;
        }
        if (this.instrMethodClasses[0].startsWith("*FAKE")) {
            System.err.println("Fake InstrMethodGroupBase --");
            return;
        }
        System.err.println(this.nClasses + " classes, " + this.nMethods + " methods --");
        boolean idx = false;
        for (int i = 0; i < this.nClasses; ++i) {
            System.err.print("--Class " + this.instrMethodClasses[i] + "," + this.instrMethodClassLoaderIds[i]);
            System.err.println();
        }
    }

    public String toString() {
        return (this.instrMethodClasses != null ? this.instrMethodClasses.length : 0) + " classes.";
    }

    void readObject(ObjectInputStream in) throws IOException {
        int i;
        this.nClasses = in.readInt();
        if (this.nClasses == 0) {
            return;
        }
        if (this.instrMethodClasses == null || this.nClasses > this.instrMethodClasses.length) {
            this.instrMethodClasses = new String[this.nClasses];
            this.instrMethodClassLoaderIds = new int[this.nClasses];
        }
        for (int i2 = 0; i2 < this.nClasses; ++i2) {
            this.instrMethodClasses[i2] = in.readUTF();
            this.instrMethodClassLoaderIds[i2] = in.readInt();
        }
        this.nMethods = in.readInt();
        int code = in.read();
        if (code != 0) {
            if (this.instrMethodLeaf == null || this.nMethods > this.instrMethodLeaf.length) {
                this.instrMethodLeaf = new boolean[this.nMethods];
            }
            for (i = 0; i < this.nMethods; ++i) {
                this.instrMethodLeaf[i] = in.readBoolean();
            }
        } else {
            this.instrMethodLeaf = null;
        }
        this.addInfo = in.readInt();
        if (this.replacementClassFileBytes == null || this.nClasses > this.replacementClassFileBytes.length) {
            this.replacementClassFileBytes = new byte[this.nClasses][];
        }
        for (i = 0; i < this.nClasses; ++i) {
            int len = in.readInt();
            if (len <= 0) continue;
            this.replacementClassFileBytes[i] = new byte[len];
            in.readFully(this.replacementClassFileBytes[i]);
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        if (this.instrMethodClasses == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(this.nClasses);
        for (i = 0; i < this.nClasses; ++i) {
            out.writeUTF(this.instrMethodClasses[i]);
            out.writeInt(this.instrMethodClassLoaderIds[i]);
        }
        out.writeInt(this.nMethods);
        if (this.instrMethodLeaf != null) {
            out.write(1);
            for (i = 0; i < this.nMethods; ++i) {
                out.writeBoolean(this.instrMethodLeaf[i]);
            }
        } else {
            out.write(0);
        }
        out.writeInt(this.addInfo);
        for (i = 0; i < this.nClasses; ++i) {
            if (this.replacementClassFileBytes[i] == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(this.replacementClassFileBytes[i].length);
            out.write(this.replacementClassFileBytes[i]);
        }
        this.instrMethodClasses = null;
        this.instrMethodClassLoaderIds = null;
        this.instrMethodLeaf = null;
        this.replacementClassFileBytes = null;
    }
}

