/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionFactory;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.csc.CacheConnection;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class TrackingConnectionPool
extends ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(TrackingConnectionPool.class);
    private final HostAndPort hostAndPort;
    private final JedisClientConfig clientConfig;
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final AtomicInteger numWaiters = new AtomicInteger();
    private final Set<Connection> poolTrackedObjects = ConcurrentHashMap.newKeySet();

    public static Builder builder() {
        return new Builder();
    }

    private TrackingConnectionPool(Builder builder) {
        super(TrackingConnectionPool.createfailFastFactory(builder), (GenericObjectPoolConfig<Connection>)(builder.poolConfig != null ? builder.poolConfig : new GenericObjectPoolConfig()));
        this.hostAndPort = builder.hostAndPort;
        this.clientConfig = builder.clientConfig;
        this.poolConfig = builder.poolConfig;
        this.attachAuthenticationListener(builder.clientConfig.getAuthXManager());
    }

    private static FailFastConnectionFactory createfailFastFactory(Builder poolBuilder) {
        ConnectionFactory.Builder factoryBuilder = ConnectionFactory.builder().clientConfig(poolBuilder.clientConfig).socketFactory(new DefaultJedisSocketFactory(poolBuilder.hostAndPort, poolBuilder.clientConfig));
        return new FailFastConnectionFactory(factoryBuilder, poolBuilder.clientConfig);
    }

    public static TrackingConnectionPool from(TrackingConnectionPool existing) {
        return TrackingConnectionPool.builder().hostAndPort(existing.hostAndPort).clientConfig(existing.clientConfig).poolConfig(existing.poolConfig).build();
    }

    @Override
    public Connection getResource() {
        try {
            this.numWaiters.incrementAndGet();
            Connection conn = super.getResource();
            this.poolTrackedObjects.add(conn);
            Connection connection = conn;
            return connection;
        }
        catch (Exception e) {
            if (this.isClosed()) {
                throw new JedisConnectionException("Pool is closed!", e);
            }
            throw e;
        }
        finally {
            this.numWaiters.decrementAndGet();
        }
    }

    @Override
    public void returnResource(Connection resource) {
        super.returnResource(resource);
        this.poolTrackedObjects.remove(resource);
    }

    @Override
    public void returnBrokenResource(Connection resource) {
        super.returnBrokenResource(resource);
        this.poolTrackedObjects.remove(resource);
    }

    public void forceDisconnect() {
        this.close();
        ((FailFastConnectionFactory)this.getFactory()).failFast = true;
        int numOfConnected = this.poolTrackedObjects.size();
        while (this.numWaiters.get() > 0 || numOfConnected > 0) {
            this.clear();
            ((FailFastConnectionFactory)this.getFactory()).forceDisconnect();
            numOfConnected = 0;
            for (Connection connection : this.poolTrackedObjects) {
                try {
                    if (connection.isConnected()) {
                        ++numOfConnected;
                    }
                    connection.forceDisconnect();
                }
                catch (Exception e) {
                    log.warn("Error while force disconnecting connection: " + connection.toIdentityString(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ((FailFastConnectionFactory)this.getFactory()).failFast = false;
    }

    @Override
    public void close() {
        this.destroy();
        this.detachAuthenticationListener();
    }

    public static class Builder {
        private HostAndPort hostAndPort;
        private JedisClientConfig clientConfig;
        private GenericObjectPoolConfig<Connection> poolConfig;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder clientConfig(JedisClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder poolConfig(GenericObjectPoolConfig<Connection> poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public TrackingConnectionPool build() {
            this.applyDefaults();
            return new TrackingConnectionPool(this);
        }

        private void applyDefaults() {
            if (this.clientConfig == null) {
                this.clientConfig = DefaultJedisClientConfig.builder().build();
            }
            if (this.poolConfig == null) {
                this.poolConfig = new GenericObjectPoolConfig();
            }
        }
    }

    private static class FailFastConnectionFactory
    extends ConnectionFactory {
        private volatile boolean failFast = false;
        private final Set<Connection> factoryTrackedObjects = ConcurrentHashMap.newKeySet();

        public FailFastConnectionFactory(ConnectionFactory.Builder factoryBuilder, JedisClientConfig clientConfig) {
            super(factoryBuilder.connectionBuilder(FailFastConnectionFactory.createCustomConnectionBuilder(factoryBuilder, clientConfig)));
        }

        private static Connection.Builder createCustomConnectionBuilder(ConnectionFactory.Builder factoryBuilder, JedisClientConfig clientConfig) {
            Connection.Builder connBuilder = factoryBuilder.getCache() == null ? Connection.builder() : CacheConnection.builder(factoryBuilder.getCache());
            return connBuilder.socketFactory(factoryBuilder.getJedisSocketFactory()).clientConfig(clientConfig);
        }

        @Override
        public PooledObject<Connection> makeObject() throws Exception {
            if (this.failFast) {
                throw new JedisConnectionException("Failed to create connection!");
            }
            try {
                PooledObject<Connection> object = super.makeObject();
                this.factoryTrackedObjects.add((Connection)object.getObject());
                try {
                    ((Connection)object.getObject()).initializeFromClientConfig();
                }
                finally {
                    this.factoryTrackedObjects.remove(object.getObject());
                }
                if (this.failFast) {
                    ((Connection)object.getObject()).close();
                    throw new JedisConnectionException("Failed to create connection!");
                }
                return object;
            }
            catch (JedisConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JedisConnectionException(e);
            }
        }

        public void forceDisconnect() {
            for (Connection connection : this.factoryTrackedObjects) {
                try {
                    connection.forceDisconnect();
                }
                catch (Exception e) {
                    log.warn("Error while force disconnecting connection: " + connection.toIdentityString(), (Throwable)e);
                }
            }
        }
    }
}

