/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataConsumer {
    default public void setColumns(@NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(0);
        }
        if (columns == null) {
            DataConsumer.$$$reportNull$$$0(1);
        }
        this.setColumns(context, 0, 0, columns, 0);
    }

    default public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(2);
        }
        if (columns == null) {
            DataConsumer.$$$reportNull$$$0(3);
        }
    }

    default public void setInReference(@NotNull GridDataRequest.Context context, @NotNull Object reference) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(4);
        }
        if (reference == null) {
            DataConsumer.$$$reportNull$$$0(5);
        }
    }

    default public void updateColumns(@NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(6);
        }
        if (columns == null) {
            DataConsumer.$$$reportNull$$$0(7);
        }
    }

    default public void setOutReferences(@NotNull GridDataRequest.Context context, @NotNull Set<Object> references) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(8);
        }
        if (references == null) {
            DataConsumer.$$$reportNull$$$0(9);
        }
    }

    default public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(10);
        }
        if (rows == null) {
            DataConsumer.$$$reportNull$$$0(11);
        }
    }

    default public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/DataConsumer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumns";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setInReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateColumns";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setOutReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addRows";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "afterLastRowAdded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Composite
    implements DataConsumer {
        private final List<DataConsumer> delegates;

        public Composite(List<DataConsumer> delegates) {
            this.delegates = delegates;
        }

        public Composite(DataConsumer ... delegates) {
            this.delegates = Arrays.asList(delegates);
        }

        @Override
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                Composite.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                Composite.$$$reportNull$$$0(1);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setColumns(context, subQueryIndex, resultSetIndex, columns, firstRowNum);
            }
        }

        @Override
        public void setInReference(@NotNull GridDataRequest.Context context, @NotNull Object reference) {
            if (context == null) {
                Composite.$$$reportNull$$$0(2);
            }
            if (reference == null) {
                Composite.$$$reportNull$$$0(3);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setInReference(context, reference);
            }
        }

        @Override
        public void updateColumns(@NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
            if (context == null) {
                Composite.$$$reportNull$$$0(4);
            }
            if (columns == null) {
                Composite.$$$reportNull$$$0(5);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.updateColumns(context, columns);
            }
        }

        @Override
        public void setOutReferences(@NotNull GridDataRequest.Context context, @NotNull Set<Object> references) {
            if (context == null) {
                Composite.$$$reportNull$$$0(6);
            }
            if (references == null) {
                Composite.$$$reportNull$$$0(7);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setOutReferences(context, references);
            }
        }

        @Override
        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            if (context == null) {
                Composite.$$$reportNull$$$0(8);
            }
            if (rows == null) {
                Composite.$$$reportNull$$$0(9);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            if (context == null) {
                Composite.$$$reportNull$$$0(10);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.afterLastRowAdded(context, total);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Composite";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setInReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOutReferences";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Column
    implements JdbcGridColumn {
        private final Set<ColumnDescriptor.Attribute> attributes;
        private final int columnNum;
        private final int type;
        private final String name;
        private final String typeName;
        private final String clazz;
        private final int precision;
        private final int scale;
        private final String catalog;
        private final String schema;
        private final String table;

        public Column(int columnNum, String name, int type, @Nullable String typeName, @Nullable String clazz) {
            this(columnNum, name, type, typeName, clazz, -1, -1, null, null, null);
        }

        public Column(int columnNum, String name, int type, @Nullable String typeName, @Nullable String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table) {
            this(columnNum, name, type, typeName, clazz, precision, scale, catalog, schema, table, Collections.emptySet());
        }

        public Column(int columnNum, String name, int type, @Nullable String typeName, @Nullable String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table, @NotNull Set<ColumnDescriptor.Attribute> attributes) {
            if (attributes == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.columnNum = columnNum;
            this.name = name;
            this.type = type;
            this.typeName = typeName;
            this.clazz = clazz;
            this.precision = precision;
            this.scale = scale;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.attributes = attributes;
        }

        @Override
        @Nullable
        public String getJavaClassName() {
            return this.clazz;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        public String toString() {
            return "Column" + this.getColumnNumber() + "{name='" + this.getName() + "', type=" + this.getType() + ", typeName='" + this.getTypeName() + "', clazz='" + this.clazz + "', table='" + this.catalog + "'.'" + this.schema + "'.'" + this.table + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (this.getColumnNumber() != column.getColumnNumber()) {
                return false;
            }
            if (this.precision != column.precision) {
                return false;
            }
            if (this.scale != column.scale) {
                return false;
            }
            if (this.getType() != column.getType()) {
                return false;
            }
            if (!Objects.equals(this.catalog, column.catalog)) {
                return false;
            }
            if (!Objects.equals(this.clazz, column.clazz)) {
                return false;
            }
            if (!Objects.equals(this.getName(), column.getName())) {
                return false;
            }
            if (!Objects.equals(this.schema, column.schema)) {
                return false;
            }
            if (!Objects.equals(this.table, column.table)) {
                return false;
            }
            if (!Objects.equals(this.getTypeName(), column.getTypeName())) {
                return false;
            }
            return this.attributes.equals(column.attributes);
        }

        public int hashCode() {
            int result = this.getColumnNumber();
            result = 31 * result + this.getType();
            result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
            result = 31 * result + (this.getTypeName() != null ? this.getTypeName().hashCode() : 0);
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + this.precision;
            result = 31 * result + this.scale;
            result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
            result = 31 * result + this.attributes.hashCode();
            return result;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public int getSize() {
            return this.precision;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNum;
        }

        @Override
        @NotNull
        public Set<ColumnDescriptor.Attribute> getAttributes() {
            Set<ColumnDescriptor.Attribute> set = this.attributes;
            if (set == null) {
                Column.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        @Nullable
        public String getTable() {
            return this.table;
        }

        @Override
        @Nullable
        public String getSchema() {
            return this.schema;
        }

        @Override
        @Nullable
        public String getCatalog() {
            return this.catalog;
        }

        public static Column copy(@NotNull GridColumn column, int idx) {
            if (column == null) {
                Column.$$$reportNull$$$0(2);
            }
            return Column.copy(column, idx, column.getName(), column.getType(), column.getTypeName());
        }

        public static Column copy(@NotNull GridColumn column, int idx, @NotNull String name, int type, @Nullable String typeName) {
            Column consumerColumn;
            if (column == null) {
                Column.$$$reportNull$$$0(3);
            }
            if (name == null) {
                Column.$$$reportNull$$$0(4);
            }
            return (consumerColumn = (Column)ObjectUtils.tryCast((Object)column, Column.class)) == null ? new Column(idx, name, type, typeName, null) : new Column(idx, name, type, typeName, consumerColumn.getJavaClassName(), consumerColumn.getSize(), consumerColumn.getScale(), consumerColumn.getCatalog(), consumerColumn.getSchema(), consumerColumn.getTable(), consumerColumn.getAttributes());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class Row
    implements GridRow {
        @Deprecated(forRemoval=true)
        public final int rowNum;
        @Deprecated(forRemoval=true)
        public final Object[] values;

        protected Row(int rowNum, Object[] values) {
            this.rowNum = rowNum;
            this.values = values;
        }

        public static Row create(int realIdx, Object[] values) {
            return new Row(realIdx + 1, values);
        }

        @Override
        public void setValue(int i, @Nullable Object object) {
            this.values[i] = object;
        }

        @Override
        public Object getValue(int columnNum) {
            return columnNum < this.values.length ? this.values[columnNum] : ReservedCellValue.UNSET;
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public int getRowNum() {
            return this.rowNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GridRow)) {
                return false;
            }
            return GridRow.equals(this, (GridRow)o);
        }

        public int hashCode() {
            int result = this.getRowNum();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String toString() {
            return "Row{rowNum=" + this.rowNum + ", values=" + Arrays.toString(this.values) + "}";
        }
    }
}

