/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (false ? false : false) => false
 * (false ? false : true) => true
 * (false ? true : false) => false
 * (false ? true : true) => true
 * (true ? false : false) => false
 * (true ? false : true) => false
 * (true ? true : false) => true
 * (true ? true : true) => true
 */
#version 150

void main()
{
  float[(false ? false : false) == false ? 1 : -1] array0;
  float[(false ? false : true) == true ? 1 : -1] array1;
  float[(false ? true : false) == false ? 1 : -1] array2;
  float[(false ? true : true) == true ? 1 : -1] array3;
  float[(true ? false : false) == false ? 1 : -1] array4;
  float[(true ? false : true) == false ? 1 : -1] array5;
  float[(true ? true : false) == true ? 1 : -1] array6;
  float[(true ? true : true) == true ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
