/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

import java.time.Duration;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.Cron;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.CronType;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.definition.CronDefinitionBuilder;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.time.ExecutionTime;
import org.opensearch.jobscheduler.repackage.com.cronutils.parser.CronParser;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;

public class CronUtil {
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public CronValidationResult validateCron(String cronExpression) {
        if (cronExpression.equals("") || cronExpression == null) {
            return new CronValidationResult(false, "cron expression cannot be null or empty");
        }
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
        try {
            cronParser.parse(cronExpression);
        }
        catch (IllegalArgumentException e) {
            return new CronValidationResult(false, "failed to parse cron expression. For more information check out https://en.wikipedia.org/wiki/Cron. For example, \"12 * * * *\"");
        }
        ZonedDateTime now = ZonedDateTime.now();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cronExpression));
        ZonedDateTime nextExecution = (ZonedDateTime)executionTime.nextExecution(now).get();
        ZonedDateTime nextNextExecution = (ZonedDateTime)executionTime.nextExecution(nextExecution).get();
        Duration interval = Duration.between(nextExecution, nextNextExecution);
        if (interval.toSeconds() < this.settingsAccessor.getScheduledExperimentsMinimumInterval().getSeconds()) {
            return new CronValidationResult(false, "The interval between scheduled experiment runs is too short.");
        }
        return new CronValidationResult(true, null);
    }

    @Generated
    public CronUtil(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }

    public static class CronValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public CronValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

