/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentAction;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.ParserUtils;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutExperimentAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestPutExperimentAction.class);
    private static final String PUT_EXPERIMENT_ACTION = "put_experiment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return PUT_EXPERIMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_search_relevance/experiments"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ExperimentType experimentType;
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String querySetId = (String)source.get("querySetId");
        List<String> searchConfigurationList = ParserUtils.convertObjToList(source, "searchConfigurationList");
        int size = (Integer)source.get("size");
        List<String> judgmentList = ParserUtils.convertObjToList(source, "judgmentList");
        String typeString = (String)source.get("type");
        try {
            experimentType = ExperimentType.valueOf(typeString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Invalid or missing experiment type");
        }
        if (searchConfigurationList == null || searchConfigurationList.isEmpty()) {
            throw new IllegalArgumentException("searchConfigurationList cannot be null or empty");
        }
        switch (experimentType) {
            case PAIRWISE_COMPARISON: {
                if (searchConfigurationList.size() != 2) {
                    throw new SearchRelevanceException("PAIRWISE_COMPARISON requires exactly 2 search configurations", RestStatus.BAD_REQUEST);
                }
                if (!searchConfigurationList.get(0).equals(searchConfigurationList.get(1))) break;
                throw new SearchRelevanceException("PAIRWISE_COMPARISON requires distinct search configurations", RestStatus.BAD_REQUEST);
            }
            case POINTWISE_EVALUATION: {
                if (searchConfigurationList.size() == 1) break;
                throw new SearchRelevanceException("POINTWISE_EVALUATION requires exactly 1 search configuration", RestStatus.BAD_REQUEST);
            }
            case HYBRID_OPTIMIZER: {
                if (searchConfigurationList.size() == 1) break;
                throw new SearchRelevanceException("HYBRID_OPTIMIZER requires exactly 1 search configuration", RestStatus.BAD_REQUEST);
            }
            default: {
                throw new IllegalArgumentException("Unsupported experiment type: " + String.valueOf((Object)experimentType));
            }
        }
        PutExperimentRequest createRequest = new PutExperimentRequest(experimentType, null, querySetId, searchConfigurationList, judgmentList, size);
        return channel -> client.execute((ActionType)PutExperimentAction.INSTANCE, (ActionRequest)createRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("experiment_id", response.getId());
                    builder.field("experiment_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestPutExperimentAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

