/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model.builder;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.experiment.QuerySourceUtil;

public class SearchRequestBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchRequestBuilder.class);
    private static volatile NamedXContentRegistry NAMED_XCONTENT_REGISTRY;
    private static final String SIZE_FIELD_NAME = "size";
    private static final String QUERY_FIELD_NAME = "query";

    public static void initialize(NamedXContentRegistry registry) {
        NAMED_XCONTENT_REGISTRY = registry;
        log.debug("SearchRequestBuilder initialized with NamedXContentRegistry");
    }

    private static XContentParser newParserWithRegistry(String json) throws IOException {
        if (NAMED_XCONTENT_REGISTRY == null) {
            throw new IllegalStateException("SearchRequestBuilder is not initialized with NamedXContentRegistry. Ensure SearchRelevancePlugin.createComponents calls SearchRequestBuilder.initialize(xContentRegistry).");
        }
        return JsonXContent.jsonXContent.createParser(NAMED_XCONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, json);
    }

    public static SearchRequest buildSearchRequest(String index, String query, String queryText, String searchPipeline, int size) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        try {
            int querySize;
            String processedQuery = query.replace("%SearchText%", queryText);
            XContentParser tempParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, processedQuery);
            Map fullQueryMap = tempParser.map();
            Object queryObject = fullQueryMap.remove(QUERY_FIELD_NAME);
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.map(fullQueryMap);
            XContentParser parser = JsonXContent.jsonXContent.createParser(NAMED_XCONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, builder.toString());
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
            if (queryObject != null) {
                builder = JsonXContent.contentBuilder();
                builder.value(queryObject);
                String queryBody = builder.toString();
                sourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryBody));
            }
            if (fullQueryMap.containsKey(SIZE_FIELD_NAME) && (querySize = ((Number)fullQueryMap.get(SIZE_FIELD_NAME)).intValue()) != size) {
                log.debug("Size mismatch detected. Query size: {}, Search Configuration Input size: {}. Using Search Configuration Input size.", (Object)querySize, (Object)size);
            }
            sourceBuilder.size(size);
            if (searchPipeline != null && !searchPipeline.isEmpty()) {
                searchRequest.pipeline(searchPipeline);
            }
            searchRequest.source(sourceBuilder);
            return searchRequest;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to build search request", ex);
        }
    }

    public static SearchRequest buildRequestForHybridSearch(String index, String query, Map<String, Object> temporarySearchPipeline, String queryText, int size) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        try {
            int querySize;
            String processedQuery = query.replace("%SearchText%", queryText);
            XContentParser tempParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, processedQuery);
            Map fullQueryMap = tempParser.map();
            QuerySourceUtil.validateHybridQuery(fullQueryMap);
            Object queryObject = fullQueryMap.remove(QUERY_FIELD_NAME);
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.map(fullQueryMap);
            XContentParser parser = JsonXContent.jsonXContent.createParser(NAMED_XCONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, builder.toString());
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
            if (queryObject != null) {
                builder = JsonXContent.contentBuilder();
                builder.value(queryObject);
                String queryBody = builder.toString();
                sourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryBody));
            }
            if (Objects.nonNull(sourceBuilder.searchPipelineSource()) && !sourceBuilder.searchPipelineSource().isEmpty()) {
                log.error("query in search configuration does have temporary search pipeline in its source");
                throw new IllegalArgumentException("search pipeline is not allowed in search request");
            }
            if (!temporarySearchPipeline.isEmpty()) {
                sourceBuilder.searchPipelineSource(temporarySearchPipeline);
            } else {
                log.debug("no temporary search pipeline");
            }
            if (fullQueryMap.containsKey(SIZE_FIELD_NAME) && (querySize = ((Number)fullQueryMap.get(SIZE_FIELD_NAME)).intValue()) != size) {
                log.debug("Size mismatch detected. Query size: {}, Search Configuration Input size: {}. Using Search Configuration Input size.", (Object)querySize, (Object)size);
            }
            sourceBuilder.size(size);
            searchRequest.source(sourceBuilder);
            return searchRequest;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to build search request", ex);
        }
    }
}

