/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.parser.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParser;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParserBaseVisitor;
import org.opensearch.sql.sql.parser.AstExpressionBuilder;
import org.opensearch.sql.sql.parser.ParserUtils;

public class QuerySpecification {
    private final List<UnresolvedExpression> selectItems = new ArrayList<UnresolvedExpression>();
    private final Map<String, UnresolvedExpression> selectItemsByAlias = new HashMap<String, UnresolvedExpression>();
    private final Set<UnresolvedExpression> aggregators = new LinkedHashSet<UnresolvedExpression>();
    private final List<UnresolvedExpression> groupByItems = new ArrayList<UnresolvedExpression>();
    private final List<UnresolvedExpression> orderByItems = new ArrayList<UnresolvedExpression>();
    private final List<Sort.SortOption> orderByOptions = new ArrayList<Sort.SortOption>();

    public void collect(OpenSearchSQLParser.QuerySpecificationContext query, String queryString) {
        query.accept(new QuerySpecificationCollector(queryString));
    }

    public UnresolvedExpression replaceIfAliasOrOrdinal(UnresolvedExpression expr) {
        if (this.isIntegerLiteral(expr)) {
            return this.getSelectItemByOrdinal(expr);
        }
        if (this.isSelectAlias(expr)) {
            return this.getSelectItemByAlias(expr);
        }
        return expr;
    }

    private boolean isIntegerLiteral(UnresolvedExpression expr) {
        if (!(expr instanceof Literal)) {
            return false;
        }
        if (((Literal)expr).getType() != DataType.INTEGER) {
            throw new SemanticCheckException(StringUtils.format("Non-integer constant [%s] found in ordinal", expr));
        }
        return true;
    }

    private UnresolvedExpression getSelectItemByOrdinal(UnresolvedExpression expr) {
        int ordinal = (Integer)((Literal)expr).getValue();
        if (ordinal <= 0 || ordinal > this.selectItems.size()) {
            throw new SemanticCheckException(StringUtils.format("Ordinal [%d] is out of bound of select item list", ordinal));
        }
        return this.selectItems.get(ordinal - 1);
    }

    public boolean isSelectAlias(UnresolvedExpression expr) {
        return expr instanceof QualifiedName && this.selectItemsByAlias.containsKey(expr.toString());
    }

    public UnresolvedExpression getSelectItemByAlias(UnresolvedExpression expr) {
        return this.selectItemsByAlias.get(expr.toString());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification other = (QuerySpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedExpression> this$selectItems = this.getSelectItems();
        List<UnresolvedExpression> other$selectItems = other.getSelectItems();
        if (this$selectItems == null ? other$selectItems != null : !((Object)this$selectItems).equals(other$selectItems)) {
            return false;
        }
        Map<String, UnresolvedExpression> this$selectItemsByAlias = this.getSelectItemsByAlias();
        Map<String, UnresolvedExpression> other$selectItemsByAlias = other.getSelectItemsByAlias();
        if (this$selectItemsByAlias == null ? other$selectItemsByAlias != null : !((Object)this$selectItemsByAlias).equals(other$selectItemsByAlias)) {
            return false;
        }
        Set<UnresolvedExpression> this$aggregators = this.getAggregators();
        Set<UnresolvedExpression> other$aggregators = other.getAggregators();
        if (this$aggregators == null ? other$aggregators != null : !((Object)this$aggregators).equals(other$aggregators)) {
            return false;
        }
        List<UnresolvedExpression> this$groupByItems = this.getGroupByItems();
        List<UnresolvedExpression> other$groupByItems = other.getGroupByItems();
        if (this$groupByItems == null ? other$groupByItems != null : !((Object)this$groupByItems).equals(other$groupByItems)) {
            return false;
        }
        List<UnresolvedExpression> this$orderByItems = this.getOrderByItems();
        List<UnresolvedExpression> other$orderByItems = other.getOrderByItems();
        if (this$orderByItems == null ? other$orderByItems != null : !((Object)this$orderByItems).equals(other$orderByItems)) {
            return false;
        }
        List<Sort.SortOption> this$orderByOptions = this.getOrderByOptions();
        List<Sort.SortOption> other$orderByOptions = other.getOrderByOptions();
        return !(this$orderByOptions == null ? other$orderByOptions != null : !((Object)this$orderByOptions).equals(other$orderByOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuerySpecification;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedExpression> $selectItems = this.getSelectItems();
        result = result * 59 + ($selectItems == null ? 43 : ((Object)$selectItems).hashCode());
        Map<String, UnresolvedExpression> $selectItemsByAlias = this.getSelectItemsByAlias();
        result = result * 59 + ($selectItemsByAlias == null ? 43 : ((Object)$selectItemsByAlias).hashCode());
        Set<UnresolvedExpression> $aggregators = this.getAggregators();
        result = result * 59 + ($aggregators == null ? 43 : ((Object)$aggregators).hashCode());
        List<UnresolvedExpression> $groupByItems = this.getGroupByItems();
        result = result * 59 + ($groupByItems == null ? 43 : ((Object)$groupByItems).hashCode());
        List<UnresolvedExpression> $orderByItems = this.getOrderByItems();
        result = result * 59 + ($orderByItems == null ? 43 : ((Object)$orderByItems).hashCode());
        List<Sort.SortOption> $orderByOptions = this.getOrderByOptions();
        result = result * 59 + ($orderByOptions == null ? 43 : ((Object)$orderByOptions).hashCode());
        return result;
    }

    @Generated
    public List<UnresolvedExpression> getSelectItems() {
        return this.selectItems;
    }

    @Generated
    public Map<String, UnresolvedExpression> getSelectItemsByAlias() {
        return this.selectItemsByAlias;
    }

    @Generated
    public Set<UnresolvedExpression> getAggregators() {
        return this.aggregators;
    }

    @Generated
    public List<UnresolvedExpression> getGroupByItems() {
        return this.groupByItems;
    }

    @Generated
    public List<UnresolvedExpression> getOrderByItems() {
        return this.orderByItems;
    }

    @Generated
    public List<Sort.SortOption> getOrderByOptions() {
        return this.orderByOptions;
    }

    @Generated
    public String toString() {
        return "QuerySpecification(selectItems=" + String.valueOf(this.getSelectItems()) + ", selectItemsByAlias=" + String.valueOf(this.getSelectItemsByAlias()) + ", aggregators=" + String.valueOf(this.getAggregators()) + ", groupByItems=" + String.valueOf(this.getGroupByItems()) + ", orderByItems=" + String.valueOf(this.getOrderByItems()) + ", orderByOptions=" + String.valueOf(this.getOrderByOptions()) + ")";
    }

    private class QuerySpecificationCollector
    extends OpenSearchSQLParserBaseVisitor<Void> {
        private final AstExpressionBuilder expressionBuilder = new AstExpressionBuilder();
        private final String queryString;

        public QuerySpecificationCollector(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public Void visitSubqueryAsRelation(OpenSearchSQLParser.SubqueryAsRelationContext ctx) {
            return null;
        }

        @Override
        public Void visitWindowFunctionClause(OpenSearchSQLParser.WindowFunctionClauseContext ctx) {
            return null;
        }

        @Override
        public Void visitSelectClause(OpenSearchSQLParser.SelectClauseContext ctx) {
            super.visitSelectClause(ctx);
            if (this.isDistinct(ctx.selectSpec())) {
                QuerySpecification.this.groupByItems.addAll(QuerySpecification.this.selectItems);
            }
            return null;
        }

        @Override
        public Void visitSelectElement(OpenSearchSQLParser.SelectElementContext ctx) {
            UnresolvedExpression expr = this.visitAstExpression((ParseTree)ctx.expression());
            QuerySpecification.this.selectItems.add(expr);
            if (ctx.alias() != null) {
                String alias = StringUtils.unquoteIdentifier(ctx.alias().getText());
                QuerySpecification.this.selectItemsByAlias.put(alias, expr);
            }
            return (Void)super.visitSelectElement(ctx);
        }

        @Override
        public Void visitGroupByElement(OpenSearchSQLParser.GroupByElementContext ctx) {
            QuerySpecification.this.groupByItems.add(this.visitAstExpression((ParseTree)ctx));
            return (Void)super.visitGroupByElement(ctx);
        }

        @Override
        public Void visitOrderByElement(OpenSearchSQLParser.OrderByElementContext ctx) {
            QuerySpecification.this.orderByItems.add(this.visitAstExpression((ParseTree)ctx.expression()));
            QuerySpecification.this.orderByOptions.add(ParserUtils.createSortOption(ctx));
            return (Void)super.visitOrderByElement(ctx);
        }

        @Override
        public Void visitAggregateFunctionCall(OpenSearchSQLParser.AggregateFunctionCallContext ctx) {
            QuerySpecification.this.aggregators.add(AstDSL.alias(ParserUtils.getTextInQuery(ctx, this.queryString), this.visitAstExpression((ParseTree)ctx)));
            return (Void)super.visitAggregateFunctionCall(ctx);
        }

        @Override
        public Void visitFilteredAggregationFunctionCall(OpenSearchSQLParser.FilteredAggregationFunctionCallContext ctx) {
            UnresolvedExpression aggregateFunction = this.visitAstExpression((ParseTree)ctx);
            QuerySpecification.this.aggregators.add(AstDSL.alias(ParserUtils.getTextInQuery(ctx, this.queryString), aggregateFunction));
            return (Void)super.visitFilteredAggregationFunctionCall(ctx);
        }

        private boolean isDistinct(OpenSearchSQLParser.SelectSpecContext ctx) {
            return ctx != null && ctx.DISTINCT() != null;
        }

        private UnresolvedExpression visitAstExpression(ParseTree tree) {
            return (UnresolvedExpression)this.expressionBuilder.visit(tree);
        }
    }
}

