/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.UnresolvedPlanHelper;

public class ArgumentFactory {
    public static List<Argument> getArgumentList(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return Collections.singletonList(ctx.fieldsCommandBody().MINUS() != null ? new Argument("exclude", new Literal(true, DataType.BOOLEAN)) : new Argument("exclude", new Literal(false, DataType.BOOLEAN)));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.StatsCommandContext ctx, Settings settings) {
        OpenSearchPPLParser.StatsArgsContext ctx1 = ctx.statsArgs();
        OpenSearchPPLParser.DedupSplitArgContext ctx2 = ctx.dedupSplitArg();
        Argument[] argumentArray = new Argument[4];
        argumentArray[0] = ctx1.partitionsArg() != null && !ctx1.partitionsArg().isEmpty() ? new Argument("partitions", ArgumentFactory.getArgumentValue(ctx1.partitionsArg((int)0).partitions)) : new Argument("partitions", Literal.ONE);
        argumentArray[1] = ctx1.allnumArg() != null && !ctx1.allnumArg().isEmpty() ? new Argument("allnum", ArgumentFactory.getArgumentValue(ctx1.allnumArg((int)0).allnum)) : new Argument("allnum", Literal.FALSE);
        Argument argument = argumentArray[2] = ctx1.delimArg() != null && !ctx1.delimArg().isEmpty() ? new Argument("delim", ArgumentFactory.getArgumentValue(ctx1.delimArg((int)0).delim)) : new Argument("delim", new Literal(" ", DataType.STRING));
        argumentArray[3] = ctx1.bucketNullableArg() != null && !ctx1.bucketNullableArg().isEmpty() ? new Argument("bucket_nullable", ArgumentFactory.getArgumentValue(ctx1.bucketNullableArg((int)0).bucket_nullable)) : new Argument("bucket_nullable", UnresolvedPlanHelper.legacyPreferred(settings) ? Literal.TRUE : Literal.FALSE);
        ArrayList<Argument> list = new ArrayList<Argument>(Arrays.asList(argumentArray));
        if (ctx2 != null) {
            list.add(new Argument("dedupsplit", ArgumentFactory.getArgumentValue(ctx2.dedupsplit)));
        } else {
            list.add(new Argument("dedupsplit", Literal.FALSE));
        }
        return list;
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.StreamstatsCommandContext ctx, Settings settings) {
        Argument[] argumentArray = new Argument[4];
        argumentArray[0] = ctx.streamstatsArgs().currentArg() != null && !ctx.streamstatsArgs().currentArg().isEmpty() ? new Argument("current", ArgumentFactory.getArgumentValue(ctx.streamstatsArgs().currentArg((int)0).current)) : new Argument("current", new Literal(true, DataType.BOOLEAN));
        argumentArray[1] = ctx.streamstatsArgs().windowArg() != null && !ctx.streamstatsArgs().windowArg().isEmpty() ? new Argument("window", ArgumentFactory.getArgumentValue(ctx.streamstatsArgs().windowArg((int)0).window)) : new Argument("window", new Literal(0, DataType.INTEGER));
        Argument argument = argumentArray[2] = ctx.streamstatsArgs().globalArg() != null && !ctx.streamstatsArgs().globalArg().isEmpty() ? new Argument("global", ArgumentFactory.getArgumentValue(ctx.streamstatsArgs().globalArg((int)0).global)) : new Argument("global", new Literal(true, DataType.BOOLEAN));
        argumentArray[3] = ctx.streamstatsArgs().bucketNullableArg() != null && !ctx.streamstatsArgs().bucketNullableArg().isEmpty() ? new Argument("bucket_nullable", ArgumentFactory.getArgumentValue(ctx.streamstatsArgs().bucketNullableArg((int)0).bucket_nullable)) : new Argument("bucket_nullable", UnresolvedPlanHelper.legacyPreferred(settings) ? Literal.TRUE : Literal.FALSE);
        return Arrays.asList(argumentArray);
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.EventstatsCommandContext ctx, Settings settings) {
        return Collections.singletonList(ctx.bucketNullableArg() != null && !ctx.bucketNullableArg().isEmpty() ? new Argument("bucket_nullable", ArgumentFactory.getArgumentValue(ctx.bucketNullableArg().bucket_nullable)) : new Argument("bucket_nullable", UnresolvedPlanHelper.legacyPreferred(settings) ? Literal.TRUE : Literal.FALSE));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.DedupCommandContext ctx) {
        return Arrays.asList(ctx.number != null ? new Argument("number", ArgumentFactory.getArgumentValue(ctx.number)) : new Argument("number", new Literal(1, DataType.INTEGER)), ctx.keepempty != null ? new Argument("keepempty", ArgumentFactory.getArgumentValue(ctx.keepempty)) : new Argument("keepempty", new Literal(false, DataType.BOOLEAN)), ctx.consecutive != null ? new Argument("consecutive", ArgumentFactory.getArgumentValue(ctx.consecutive)) : new Argument("consecutive", new Literal(false, DataType.BOOLEAN)));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.SortFieldContext ctx) {
        if (ctx instanceof OpenSearchPPLParser.PrefixSortFieldContext) {
            return ArgumentFactory.getArgumentList((OpenSearchPPLParser.PrefixSortFieldContext)ctx);
        }
        if (ctx instanceof OpenSearchPPLParser.SuffixSortFieldContext) {
            return ArgumentFactory.getArgumentList((OpenSearchPPLParser.SuffixSortFieldContext)ctx);
        }
        return ArgumentFactory.getArgumentList((OpenSearchPPLParser.DefaultSortFieldContext)ctx);
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.PrefixSortFieldContext ctx) {
        return Arrays.asList(ctx.MINUS() != null ? new Argument("asc", new Literal(false, DataType.BOOLEAN)) : new Argument("asc", new Literal(true, DataType.BOOLEAN)), ArgumentFactory.getTypeArgument(ctx.sortFieldExpression()));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.SuffixSortFieldContext ctx) {
        return Arrays.asList(ctx.DESC() != null || ctx.D() != null ? new Argument("asc", new Literal(false, DataType.BOOLEAN)) : new Argument("asc", new Literal(true, DataType.BOOLEAN)), ArgumentFactory.getTypeArgument(ctx.sortFieldExpression()));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.DefaultSortFieldContext ctx) {
        return Arrays.asList(new Argument("asc", new Literal(true, DataType.BOOLEAN)), ArgumentFactory.getTypeArgument(ctx.sortFieldExpression()));
    }

    private static Argument getTypeArgument(OpenSearchPPLParser.SortFieldExpressionContext ctx) {
        if (ctx.AUTO() != null) {
            return new Argument("type", new Literal("auto", DataType.STRING));
        }
        if (ctx.IP() != null) {
            return new Argument("type", new Literal("ip", DataType.STRING));
        }
        if (ctx.NUM() != null) {
            return new Argument("type", new Literal("num", DataType.STRING));
        }
        if (ctx.STR() != null) {
            return new Argument("type", new Literal("str", DataType.STRING));
        }
        return new Argument("type", new Literal(null, DataType.NULL));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.ChartCommandContext ctx) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        for (OpenSearchPPLParser.ChartOptionsContext optionCtx : ctx.chartOptions()) {
            if (optionCtx.LIMIT() != null) {
                Literal limit = optionCtx.integerLiteral() != null ? ArgumentFactory.getArgumentValue(optionCtx.integerLiteral()) : AstDSL.intLiteral(Integer.parseInt((optionCtx.TOP_K() != null ? optionCtx.TOP_K() : optionCtx.BOTTOM_K()).getText().replaceAll("[^0-9-]", "")));
                arguments.add(new Argument("limit", limit));
                arguments.add(new Argument("top", AstDSL.booleanLiteral(optionCtx.BOTTOM_K() == null)));
                continue;
            }
            if (optionCtx.USEOTHER() != null) {
                arguments.add(new Argument("useother", ArgumentFactory.getArgumentValue(optionCtx.booleanLiteral())));
                continue;
            }
            if (optionCtx.OTHERSTR() != null) {
                arguments.add(new Argument("otherstr", ArgumentFactory.getArgumentValue(optionCtx.stringLiteral())));
                continue;
            }
            if (optionCtx.USENULL() != null) {
                arguments.add(new Argument("usenull", ArgumentFactory.getArgumentValue(optionCtx.booleanLiteral())));
                continue;
            }
            if (optionCtx.NULLSTR() == null) continue;
            arguments.add(new Argument("nullstr", ArgumentFactory.getArgumentValue(optionCtx.stringLiteral())));
        }
        return arguments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Argument> getArgumentList(OpenSearchPPLParser.TimechartCommandContext timechartCtx, AstExpressionBuilder expressionBuilder) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        for (OpenSearchPPLParser.TimechartParameterContext ctx : timechartCtx.timechartParameter()) {
            if (ctx.SPAN() != null) {
                arguments.add(new Argument("spanliteral", (Literal)expressionBuilder.visit((ParseTree)ctx.spanLiteral())));
                continue;
            }
            if (ctx.LIMIT() != null) {
                Literal limit = ArgumentFactory.getArgumentValue(ctx.integerLiteral());
                if ((Integer)limit.getValue() < 0) {
                    throw new IllegalArgumentException("Limit must be a non-negative number");
                }
                arguments.add(new Argument("limit", limit));
                continue;
            }
            if (ctx.USEOTHER() != null) {
                Literal useOther;
                if (ctx.booleanLiteral() != null) {
                    useOther = ArgumentFactory.getArgumentValue(ctx.booleanLiteral());
                } else {
                    if (ctx.ident() == null) throw new IllegalArgumentException("value for useOther must be a boolean or identifier");
                    String identLiteral = expressionBuilder.visitIdentifiers(List.of(ctx.ident())).toString();
                    if ("true".equalsIgnoreCase(identLiteral) || "t".equalsIgnoreCase(identLiteral)) {
                        useOther = AstDSL.booleanLiteral(true);
                    } else {
                        if (!"false".equalsIgnoreCase(identLiteral) && !"f".equalsIgnoreCase(identLiteral)) throw new IllegalArgumentException("Invalid useOther value: " + ctx.ident().getText() + ". Expected true/false or t/f");
                        useOther = AstDSL.booleanLiteral(false);
                    }
                }
                arguments.add(new Argument("useother", useOther));
                continue;
            }
            if (ctx.TIMEFIELD() == null) throw new IllegalArgumentException(String.format("A parameter of timechart must be a span, limit, useother, or timefield, got %s", new Object[]{ctx}));
            Literal timeField = ctx.ident() != null ? AstDSL.stringLiteral(expressionBuilder.visitIdentifiers(List.of(ctx.ident())).toString()) : ArgumentFactory.getArgumentValue(ctx.stringLiteral());
            arguments.add(new Argument("timefield", timeField));
        }
        return arguments;
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.RareTopCommandContext ctx, Settings settings) {
        ArrayList<Argument> list = new ArrayList<Argument>();
        Optional<OpenSearchPPLParser.RareTopOptionContext> opt = ctx.rareTopOption().stream().filter(op -> op.countField != null).findFirst();
        list.add(new Argument(RareTopN.Option.countField.name(), opt.isPresent() ? ArgumentFactory.getArgumentValue(opt.get().countField) : new Literal("count", DataType.STRING)));
        opt = ctx.rareTopOption().stream().filter(op -> op.showCount != null).findFirst();
        list.add(new Argument(RareTopN.Option.showCount.name(), opt.isPresent() ? ArgumentFactory.getArgumentValue(opt.get().showCount) : Literal.TRUE));
        opt = ctx.rareTopOption().stream().filter(op -> op.useNull != null).findFirst();
        list.add(new Argument(RareTopN.Option.useNull.name(), opt.isPresent() ? ArgumentFactory.getArgumentValue(opt.get().useNull) : (UnresolvedPlanHelper.legacyPreferred(settings) ? Literal.TRUE : Literal.FALSE)));
        return list;
    }

    private static Literal getArgumentValue(ParserRuleContext ctx) {
        if (ctx instanceof OpenSearchPPLParser.IntegerLiteralContext) {
            return new Literal(Integer.parseInt(ctx.getText()), DataType.INTEGER);
        }
        if (ctx instanceof OpenSearchPPLParser.DecimalLiteralContext) {
            return new Literal(Double.parseDouble(ctx.getText()), DataType.DOUBLE);
        }
        if (ctx instanceof OpenSearchPPLParser.BooleanLiteralContext) {
            return new Literal(Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
        }
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    public static Argument getArgumentValue(OpenSearchPPLParser.JoinTypeContext ctx) {
        Join.JoinType type = ArgumentFactory.getJoinType(ctx);
        return new Argument("type", new Literal(type.name(), DataType.STRING));
    }

    public static Join.JoinType getJoinType(OpenSearchPPLParser.SqlLikeJoinTypeContext ctx) {
        if (ctx == null) {
            return Join.JoinType.INNER;
        }
        if (ctx.INNER() != null) {
            return Join.JoinType.INNER;
        }
        if (ctx.SEMI() != null) {
            return Join.JoinType.SEMI;
        }
        if (ctx.ANTI() != null) {
            return Join.JoinType.ANTI;
        }
        if (ctx.LEFT() != null) {
            return Join.JoinType.LEFT;
        }
        if (ctx.RIGHT() != null) {
            return Join.JoinType.RIGHT;
        }
        if (ctx.CROSS() != null) {
            return Join.JoinType.CROSS;
        }
        if (ctx.FULL() != null) {
            return Join.JoinType.FULL;
        }
        if (ctx.OUTER() != null) {
            return Join.JoinType.LEFT;
        }
        throw new SemanticCheckException(String.format("Unsupported join type %s", ctx.getText()));
    }

    public static Join.JoinType getJoinType(OpenSearchPPLParser.JoinTypeContext ctx) {
        if (ctx == null) {
            return Join.JoinType.INNER;
        }
        if (ctx.INNER() != null) {
            return Join.JoinType.INNER;
        }
        if (ctx.SEMI() != null) {
            return Join.JoinType.SEMI;
        }
        if (ctx.ANTI() != null) {
            return Join.JoinType.ANTI;
        }
        if (ctx.LEFT() != null) {
            return Join.JoinType.LEFT;
        }
        if (ctx.RIGHT() != null) {
            return Join.JoinType.RIGHT;
        }
        if (ctx.CROSS() != null) {
            return Join.JoinType.CROSS;
        }
        if (ctx.FULL() != null) {
            return Join.JoinType.FULL;
        }
        if (ctx.OUTER() != null) {
            return Join.JoinType.LEFT;
        }
        throw new SemanticCheckException(String.format("Unsupported join type %s", ctx.getText()));
    }

    public static Join.JoinType getJoinType(Argument.ArgumentMap argumentMap) {
        Join.JoinType joinType;
        String type = argumentMap.get("type").toString();
        if (type.equalsIgnoreCase(Join.JoinType.INNER.name())) {
            joinType = Join.JoinType.INNER;
        } else if (type.equalsIgnoreCase(Join.JoinType.SEMI.name())) {
            joinType = Join.JoinType.SEMI;
        } else if (type.equalsIgnoreCase(Join.JoinType.ANTI.name())) {
            joinType = Join.JoinType.ANTI;
        } else if (type.equalsIgnoreCase(Join.JoinType.LEFT.name())) {
            joinType = Join.JoinType.LEFT;
        } else if (type.equalsIgnoreCase(Join.JoinType.RIGHT.name())) {
            joinType = Join.JoinType.RIGHT;
        } else if (type.equalsIgnoreCase(Join.JoinType.CROSS.name())) {
            joinType = Join.JoinType.CROSS;
        } else if (type.equalsIgnoreCase(Join.JoinType.FULL.name())) {
            joinType = Join.JoinType.FULL;
        } else if (type.equalsIgnoreCase("OUTER")) {
            joinType = Join.JoinType.LEFT;
        } else {
            throw new SemanticCheckException(String.format("Supported join type %s", type));
        }
        return joinType;
    }
}

