/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.PathSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;

public class CryptoItem {
    private final List<PathSegment> key;
    private final StructuredDataTerminal data;
    private final CryptoAction action;

    protected CryptoItem(BuilderImpl builder) {
        this.key = builder.key();
        this.data = builder.data();
        this.action = builder.action();
    }

    public List<PathSegment> key() {
        return this.key;
    }

    public StructuredDataTerminal data() {
        return this.data;
    }

    public CryptoAction action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<PathSegment> key;
        protected StructuredDataTerminal data;
        protected CryptoAction action;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CryptoItem model) {
            this.key = model.key();
            this.data = model.data();
            this.action = model.action();
        }

        @Override
        public Builder key(List<PathSegment> key) {
            this.key = key;
            return this;
        }

        @Override
        public List<PathSegment> key() {
            return this.key;
        }

        @Override
        public Builder data(StructuredDataTerminal data) {
            this.data = data;
            return this;
        }

        @Override
        public StructuredDataTerminal data() {
            return this.data;
        }

        @Override
        public Builder action(CryptoAction action) {
            this.action = action;
            return this;
        }

        @Override
        public CryptoAction action() {
            return this.action;
        }

        @Override
        public CryptoItem build() {
            if (Objects.isNull(this.key())) {
                throw new IllegalArgumentException("Missing value for required field `key`");
            }
            if (Objects.isNull(this.data())) {
                throw new IllegalArgumentException("Missing value for required field `data`");
            }
            if (Objects.isNull((Object)this.action())) {
                throw new IllegalArgumentException("Missing value for required field `action`");
            }
            return new CryptoItem(this);
        }
    }

    public static interface Builder {
        public Builder key(List<PathSegment> var1);

        public List<PathSegment> key();

        public Builder data(StructuredDataTerminal var1);

        public StructuredDataTerminal data();

        public Builder action(CryptoAction var1);

        public CryptoAction action();

        public CryptoItem build();
    }
}

