/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;

public class BasicEncryptionParametersResolver
extends AbstractSecurityParametersResolver<EncryptionParameters>
implements EncryptionParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicEncryptionParametersResolver.class);
    @Nullable
    private AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    private boolean autoGenerateDataEncryptionCredential;

    @Nonnull
    public AlgorithmRegistry getAlgorithmRegistry() {
        if (this.algorithmRegistry == null) {
            return AlgorithmSupport.ensureGlobalAlgorithmRegistry();
        }
        assert (this.algorithmRegistry != null);
        return this.algorithmRegistry;
    }

    public void setAlgorithmRegistry(@Nonnull AlgorithmRegistry registry) {
        this.algorithmRegistry = Constraint.isNotNull(registry, "AlgorithmRegistry was null");
    }

    public boolean isAutoGenerateDataEncryptionCredential() {
        return this.autoGenerateDataEncryptionCredential;
    }

    public void setAutoGenerateDataEncryptionCredential(boolean flag) {
        this.autoGenerateDataEncryptionCredential = flag;
    }

    @Override
    @Nonnull
    public Iterable<EncryptionParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        EncryptionParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList(params);
        }
        return CollectionSupport.emptyList();
    }

    @Override
    @Nullable
    public EncryptionParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (criteria == null) {
            this.log.debug("CriteriaSet was null");
            return null;
        }
        Constraint.isNotNull(criteria.get(EncryptionConfigurationCriterion.class), "Resolver requires an instance of EncryptionConfigurationCriterion");
        Predicate<String> includeExcludePredicate = this.getIncludeExcludePredicate(criteria);
        EncryptionParameters params = new EncryptionParameters();
        this.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, includeExcludePredicate);
        if (params.getDataEncryptionCredential() != null) {
            params.setDataKeyInfoGenerator(this.resolveDataKeyInfoGenerator(criteria, params.getDataEncryptionCredential()));
        }
        if (params.getKeyTransportEncryptionCredential() != null) {
            params.setKeyTransportKeyInfoGenerator(this.resolveKeyTransportKeyInfoGenerator(criteria, params.getKeyTransportEncryptionCredential()));
        }
        boolean encryptionOptional = false;
        EncryptionOptionalCriterion encryptionOptionalCrit = criteria.get(EncryptionOptionalCriterion.class);
        if (encryptionOptionalCrit != null) {
            encryptionOptional = encryptionOptionalCrit.isEncryptionOptional();
        }
        if (this.validate(params, encryptionOptional)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void logResult(@Nonnull EncryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            Key dataKey;
            KeyInfoGenerator generator;
            Key keyTransportKey;
            this.log.debug("Resolved EncryptionParameters:");
            Credential keyTransportCred = params.getKeyTransportEncryptionCredential();
            Key key = keyTransportKey = keyTransportCred != null ? CredentialSupport.extractEncryptionKey(keyTransportCred) : null;
            if (keyTransportKey != null) {
                this.log.debug("\tKey transport credential with key algorithm: {}", (Object)keyTransportKey.getAlgorithm());
            } else {
                this.log.debug("\tKey transport credential: null");
            }
            this.log.debug("\tKey transport algorithm URI: {}", (Object)params.getKeyTransportEncryptionAlgorithm());
            RSAOAEPParameters oaep = params.getRSAOAEPParameters();
            if (oaep != null) {
                this.log.debug("\t\tKey transport RSA OAEP digest method URI: {}", (Object)oaep.getDigestMethod());
                this.log.debug("\t\tKey transport RSA OAEP MGF URI: {}", (Object)oaep.getMaskGenerationFunction());
                this.log.debug("\t\tKey transport RSA OAEP OAEPparams: {}", (Object)oaep.getOAEPParams());
            }
            this.log.debug("\tKey transport KeyInfoGenerator: {}", (Object)((generator = params.getKeyTransportKeyInfoGenerator()) != null ? generator.getClass().getName() : "null"));
            Credential dataEncryptionCred = params.getDataEncryptionCredential();
            Key key2 = dataKey = dataEncryptionCred != null ? CredentialSupport.extractEncryptionKey(dataEncryptionCred) : null;
            if (dataKey != null) {
                this.log.debug("\tData encryption credential with key algorithm: {}", (Object)dataKey.getAlgorithm());
            } else {
                this.log.debug("\tData encryption credential: null");
            }
            this.log.debug("\tData encryption algorithm URI: {}", (Object)params.getDataEncryptionAlgorithm());
            generator = params.getDataKeyInfoGenerator();
            this.log.debug("\tData encryption KeyInfoGenerator: {}", (Object)(generator != null ? generator.getClass().getName() : "null"));
        }
    }

    protected boolean validate(@Nonnull EncryptionParameters params, boolean encryptionOptional) {
        if (params.getKeyTransportEncryptionCredential() == null && params.getDataEncryptionCredential() == null) {
            String msg = "Validation failure: Failed to resolve an encryption key";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Failed to resolve an encryption key");
            } else {
                this.log.warn("Validation failure: Failed to resolve an encryption key");
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getKeyTransportEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve key encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve key encryption algorithm URI for credential");
            } else {
                this.log.warn("Validation failure: Unable to resolve key encryption algorithm URI for credential");
            }
            return false;
        }
        if (params.getDataEncryptionCredential() != null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve data encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve data encryption algorithm URI for credential");
            } else {
                this.log.warn("Validation failure: Unable to resolve data encryption algorithm URI for credential");
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getDataEncryptionCredential() == null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key");
            } else {
                this.log.warn("Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key");
            }
            return false;
        }
        return true;
    }

    @Nonnull
    protected Predicate<String> getIncludeExcludePredicate(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        return this.resolveIncludeExcludePredicate(criteria, criterion.getConfigurations());
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        List<Credential> keyTransportCredentials = this.getEffectiveKeyTransportCredentials(criteria);
        List<String> keyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective key transport algorithms: {}", keyTransportAlgorithms);
        List<Credential> dataEncryptionCredentials = this.getEffectiveDataEncryptionCredentials(criteria);
        List<String> dataEncryptionAlgorithms = this.getEffectiveDataEncryptionAlgorithms(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective data encryption algorithms: {}", dataEncryptionAlgorithms);
        if (dataEncryptionCredentials.isEmpty()) {
            params.setDataEncryptionAlgorithm(this.resolveDataEncryptionAlgorithm(null, dataEncryptionAlgorithms));
        } else {
            for (Credential dataEncryptionCredential : dataEncryptionCredentials) {
                assert (dataEncryptionCredential != null);
                if (this.checkAndProcessKeyAgreement(params, criteria, dataEncryptionCredential, dataEncryptionAlgorithms, CollectionSupport.emptyList())) {
                    return;
                }
                String dataEncryptionAlgorithm = this.resolveDataEncryptionAlgorithm(dataEncryptionCredential, dataEncryptionAlgorithms);
                if (dataEncryptionAlgorithm != null) {
                    params.setDataEncryptionCredential(dataEncryptionCredential);
                    params.setDataEncryptionAlgorithm(dataEncryptionAlgorithm);
                    break;
                }
                if (!this.log.isDebugEnabled()) continue;
                Key key = CredentialSupport.extractEncryptionKey(dataEncryptionCredential);
                this.log.debug("Unable to resolve data encryption algorithm for credential with key type '{}', considering other credentials", (Object)(key != null ? key.getAlgorithm() : null));
            }
        }
        KeyTransportAlgorithmPredicate keyTransportPredicate = this.resolveKeyTransportAlgorithmPredicate(criteria);
        for (Credential keyTransportCredential : keyTransportCredentials) {
            assert (keyTransportCredential != null);
            if (this.checkAndProcessKeyAgreement(params, criteria, keyTransportCredential, dataEncryptionAlgorithms, keyTransportAlgorithms)) {
                return;
            }
            String keyTransportAlgorithm = this.resolveKeyTransportAlgorithm(keyTransportCredential, keyTransportAlgorithms, params.getDataEncryptionAlgorithm(), keyTransportPredicate);
            if (keyTransportAlgorithm != null) {
                params.setKeyTransportEncryptionCredential(keyTransportCredential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm);
                break;
            }
            if (!this.log.isDebugEnabled()) continue;
            Key key = CredentialSupport.extractEncryptionKey(keyTransportCredential);
            this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)(key != null ? key.getAlgorithm() : null));
        }
        this.resolveAndPopulateRSAOAEPParams(params, criteria, includeExcludePredicate);
        this.processDataEncryptionCredentialAutoGeneration(params);
    }

    protected boolean checkAndProcessKeyAgreement(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Credential credential, @Nonnull List<String> dataEncryptionAlgorithms, @Nonnull List<String> keyTransportAlgorithms) {
        if (!KeyAgreementSupport.supportsKeyAgreement(credential)) {
            this.log.trace("Specified Credential does not support key agreement");
            return false;
        }
        PublicKey publicKey = credential.getPublicKey();
        this.log.debug("Processing key agreement for credential with key type: {}", (Object)(publicKey != null ? publicKey.getAlgorithm() : null));
        KeyAgreementEncryptionConfiguration config = this.getEffectiveKeyAgreementConfiguration(criteria, credential);
        if (config == null) {
            this.log.warn("Unable to get effective KeyAgreementEncryptionConfiguration for credential with key type: {}", (Object)(publicKey != null ? publicKey.getAlgorithm() : null));
            return false;
        }
        String dataEncryptionAlgorithm = dataEncryptionAlgorithms.stream().filter(AlgorithmSupport::isBlockEncryption).findFirst().orElse(null);
        if (dataEncryptionAlgorithm == null) {
            this.log.warn("Unable to resolve data encryption algorithm for key agreement, skipping");
            return false;
        }
        String keyTransportAlgorithm = keyTransportAlgorithms.stream().filter(AlgorithmSupport::isSymmetricKeyWrap).findFirst().orElse(null);
        String keyAlgorithm = keyTransportAlgorithm != null ? keyTransportAlgorithm : dataEncryptionAlgorithm;
        Collection<KeyAgreementParameter> keyAgreementConfigParams = config.getParameters();
        assert (keyAgreementConfigParams != null);
        KeyAgreementParameters parameters = new KeyAgreementParameters(keyAgreementConfigParams, true);
        try {
            parameters.initializeAll();
            parameters.forEach(p -> this.log.debug("Saw KeyAgreementParameter of type: {}", (Object)p.getClass().getName()));
        }
        catch (KeyAgreementException e) {
            this.log.warn("Fatal error initing configured parameters for key agreement", (Throwable)e);
            return false;
        }
        try {
            String keyAgreementAlg = config.getAlgorithm();
            assert (keyAgreementAlg != null);
            KeyAgreementProcessor processor = KeyAgreementSupport.getProcessor(keyAgreementAlg);
            KeyAgreementCredential agreementCredential = processor.execute(credential, keyAlgorithm, parameters);
            params.setDataEncryptionAlgorithm(dataEncryptionAlgorithm);
            if (keyTransportAlgorithm != null) {
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm);
                params.setKeyTransportEncryptionCredential(agreementCredential);
            } else {
                params.setDataEncryptionCredential(agreementCredential);
            }
            this.processDataEncryptionCredentialAutoGeneration(params);
            this.log.debug("Successfully processed key agreement for credential with key type: {}", (Object)(publicKey != null ? publicKey.getAlgorithm() : null));
            return true;
        }
        catch (KeyAgreementException e) {
            this.log.warn("Fatal error processing key agreement for credential", (Throwable)e);
            return false;
        }
    }

    @Nullable
    protected KeyAgreementEncryptionConfiguration getEffectiveKeyAgreementConfiguration(@Nonnull CriteriaSet criteria, @Nonnull Credential credential) {
        String keyType;
        PublicKey publicKey = credential.getPublicKey();
        String string = keyType = publicKey != null ? publicKey.getAlgorithm() : null;
        if (keyType == null) {
            this.log.warn("Unable to extract public key from credential");
            return null;
        }
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        List<EncryptionConfiguration> encConfigs = criterion.getConfigurations();
        KeyAgreementEncryptionConfiguration config = new KeyAgreementEncryptionConfiguration();
        config.setAlgorithm(encConfigs.stream().map(c -> c.getKeyAgreementConfigurations().get(keyType)).filter(Objects::nonNull).map(KeyAgreementEncryptionConfiguration::getAlgorithm).filter(Objects::nonNull).findFirst().orElse(null));
        config.setParameters(encConfigs.stream().map(c -> c.getKeyAgreementConfigurations().get(keyType)).filter(Objects::nonNull).map(KeyAgreementEncryptionConfiguration::getParameters).filter(Objects::nonNull).findFirst().orElse(CollectionSupport.emptySet()));
        if (config.getAlgorithm() == null) {
            this.log.warn("Failed to resolve a key agreement algorithm for key type: {}", (Object)keyType);
            return null;
        }
        return config;
    }

    protected void resolveAndPopulateRSAOAEPParams(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        String alg = params.getKeyTransportEncryptionAlgorithm();
        if (alg == null || !AlgorithmSupport.isRSAOAEP(alg)) {
            return;
        }
        RSAOAEPParameters oaep = params.getRSAOAEPParameters();
        if (oaep == null) {
            oaep = new RSAOAEPParameters();
            params.setRSAOAEPParameters(oaep);
        }
        this.populateRSAOAEPParams(oaep, criteria, includeExcludePredicate);
    }

    protected void populateRSAOAEPParams(@Nonnull RSAOAEPParameters rsaParams, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        if (rsaParams.isComplete()) {
            return;
        }
        Predicate<String> algoSupportPredicate = this.getAlgorithmRuntimeSupportedPredicate();
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            RSAOAEPParameters rsaConfig = config.getRSAOAEPParameters();
            if (rsaConfig != null) {
                if (rsaParams.getDigestMethod() == null && rsaConfig.getDigestMethod() != null && includeExcludePredicate.test(rsaConfig.getDigestMethod()) && algoSupportPredicate.test(rsaConfig.getDigestMethod())) {
                    rsaParams.setDigestMethod(rsaConfig.getDigestMethod());
                }
                if (rsaParams.getMaskGenerationFunction() == null && rsaConfig.getMaskGenerationFunction() != null && includeExcludePredicate.test(rsaConfig.getMaskGenerationFunction())) {
                    rsaParams.setMaskGenerationFunction(rsaConfig.getMaskGenerationFunction());
                }
                if (rsaParams.getOAEPParams() == null && rsaConfig.getOAEPParams() != null) {
                    rsaParams.setOAEPparams(rsaConfig.getOAEPParams());
                }
            }
            if (!rsaParams.isComplete() && config.isRSAOAEPParametersMerge()) continue;
            return;
        }
    }

    @Nullable
    protected KeyTransportAlgorithmPredicate resolveKeyTransportAlgorithmPredicate(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            if (config.getKeyTransportAlgorithmPredicate() == null) continue;
            return config.getKeyTransportAlgorithmPredicate();
        }
        return null;
    }

    @Nullable
    protected String resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull List<String> keyTransportAlgorithms, @Nullable String dataEncryptionAlgorithm, @Nullable KeyTransportAlgorithmPredicate keyTransportPredicate) {
        if (this.log.isTraceEnabled()) {
            Key key = CredentialSupport.extractEncryptionKey(keyTransportCredential);
            this.log.trace("Evaluating key transport encryption credential of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
        }
        for (String algorithm : keyTransportAlgorithms) {
            assert (algorithm != null);
            this.log.trace("Evaluating key transport credential against algorithm: {}", (Object)algorithm);
            if (!this.credentialSupportsAlgorithm(keyTransportCredential, algorithm) || !this.isKeyTransportAlgorithm(algorithm)) continue;
            if (keyTransportPredicate != null) {
                if (!keyTransportPredicate.test(new KeyTransportAlgorithmPredicate.SelectionInput(algorithm, dataEncryptionAlgorithm, keyTransportCredential))) continue;
                return algorithm;
            }
            return algorithm;
        }
        return null;
    }

    @Nullable
    protected String resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate, @Nullable String dataEncryptionAlgorithm) {
        return this.resolveKeyTransportAlgorithm(keyTransportCredential, this.getEffectiveKeyTransportAlgorithms(criteria, includeExcludePredicate), dataEncryptionAlgorithm, this.resolveKeyTransportAlgorithmPredicate(criteria));
    }

    @Nullable
    protected String resolveDataEncryptionAlgorithm(@Nullable Credential dataEncryptionCredential, @Nonnull List<String> dataEncryptionAlgorithms) {
        if (this.log.isTraceEnabled()) {
            Key key = dataEncryptionCredential != null ? CredentialSupport.extractEncryptionKey(dataEncryptionCredential) : null;
            this.log.trace("Evaluating data encryption credential of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
        }
        if (dataEncryptionCredential == null) {
            this.log.trace("Data encryption credential was null, selecting algorithm based on effective algorithms alone");
            if (!dataEncryptionAlgorithms.isEmpty()) {
                return dataEncryptionAlgorithms.get(0);
            }
            return null;
        }
        for (String algorithm : dataEncryptionAlgorithms) {
            assert (algorithm != null);
            this.log.trace("Evaluating data encryption credential against algorithm: {}", (Object)algorithm);
            if (!this.credentialSupportsAlgorithm(dataEncryptionCredential, algorithm) || !this.isDataEncryptionAlgorithm(algorithm)) continue;
            return algorithm;
        }
        return null;
    }

    @Nullable
    protected String resolveDataEncryptionAlgorithm(@Nullable Credential dataEncryptionCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        return this.resolveDataEncryptionAlgorithm(dataEncryptionCredential, this.getEffectiveDataEncryptionAlgorithms(criteria, includeExcludePredicate));
    }

    @Nonnull
    protected List<Credential> getEffectiveDataEncryptionCredentials(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            accumulator.addAll(config.getDataEncryptionCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveDataEncryptionAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<String> accumulator = new ArrayList<String>();
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            config.getDataEncryptionAlgorithms().stream().filter(PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate)).forEach(accumulator::add);
        }
        return accumulator;
    }

    @Nonnull
    protected List<Credential> getEffectiveKeyTransportCredentials(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            accumulator.addAll(config.getKeyTransportEncryptionCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveKeyTransportAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        ArrayList<String> accumulator = new ArrayList<String>();
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            config.getKeyTransportEncryptionAlgorithms().stream().filter(PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate)).forEach(accumulator::add);
        }
        return accumulator;
    }

    @Nullable
    protected KeyInfoGenerator resolveDataKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nullable Credential dataEncryptionCredential) {
        if (dataEncryptionCredential == null) {
            return null;
        }
        KeyInfoGenerationProfileCriterion keyInfoGenerationProfileCriterion = criteria.get(KeyInfoGenerationProfileCriterion.class);
        String name = keyInfoGenerationProfileCriterion != null ? keyInfoGenerationProfileCriterion.getName() : null;
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            KeyInfoGenerator kig = this.lookupKeyInfoGenerator(dataEncryptionCredential, config.getDataKeyInfoGeneratorManager(), name);
            if (kig == null) continue;
            return kig;
        }
        return null;
    }

    @Nullable
    protected KeyInfoGenerator resolveKeyTransportKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nullable Credential keyTransportEncryptionCredential) {
        if (keyTransportEncryptionCredential == null) {
            return null;
        }
        KeyInfoGenerationProfileCriterion keyInfoGenerationProfileCriterion = criteria.get(KeyInfoGenerationProfileCriterion.class);
        String name = keyInfoGenerationProfileCriterion != null ? keyInfoGenerationProfileCriterion.getName() : null;
        EncryptionConfigurationCriterion criterion = criteria.get(EncryptionConfigurationCriterion.class);
        assert (criterion != null);
        for (EncryptionConfiguration config : criterion.getConfigurations()) {
            KeyInfoGenerator kig = this.lookupKeyInfoGenerator(keyTransportEncryptionCredential, config.getKeyTransportKeyInfoGeneratorManager(), name);
            if (kig == null) continue;
            return kig;
        }
        return null;
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    protected boolean credentialSupportsAlgorithm(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        return AlgorithmSupport.credentialSupportsAlgorithmForEncryption(credential, this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean isKeyTransportAlgorithm(@Nonnull String algorithm) {
        return AlgorithmSupport.isKeyEncryptionAlgorithm(this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean isDataEncryptionAlgorithm(String algorithm) {
        return AlgorithmSupport.isDataEncryptionAlgorithm(this.getAlgorithmRegistry().get(algorithm));
    }

    @Nullable
    protected Credential generateDataEncryptionCredential(@Nonnull String dataEncryptionAlgorithm) {
        try {
            return AlgorithmSupport.generateSymmetricKeyAndCredential(dataEncryptionAlgorithm);
        }
        catch (KeyException | NoSuchAlgorithmException e) {
            this.log.warn("Error generating a symmetric key credential using algorithm URI: " + dataEncryptionAlgorithm, (Throwable)e);
            return null;
        }
    }

    protected void processDataEncryptionCredentialAutoGeneration(@Nonnull EncryptionParameters params) {
        String dataEncryptionAlg = params.getDataEncryptionAlgorithm();
        if (this.isAutoGenerateDataEncryptionCredential() && params.getKeyTransportEncryptionCredential() != null && params.getDataEncryptionCredential() == null && dataEncryptionAlg != null) {
            this.log.debug("Auto-generating data encryption credential using algorithm URI: {}", (Object)dataEncryptionAlg);
            params.setDataEncryptionCredential(this.generateDataEncryptionCredential(dataEncryptionAlg));
        }
    }
}

