/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.action;

import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.binary.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/opensearch/commons/alerting/model/action/Throttle;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "value", "", "unit", "Ljava/time/temporal/ChronoUnit;", "<init>", "(ILjava/time/temporal/ChronoUnit;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getValue", "()I", "getUnit", "()Ljava/time/temporal/ChronoUnit;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "common-utils"})
public final class Throttle
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    @NotNull
    private final ChronoUnit unit;
    @NotNull
    public static final String VALUE_FIELD = "value";
    @NotNull
    public static final String UNIT_FIELD = "unit";

    public Throttle(int value, @NotNull ChronoUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)UNIT_FIELD);
        this.value = value;
        this.unit = unit;
    }

    public final int getValue() {
        return this.value;
    }

    @NotNull
    public final ChronoUnit getUnit() {
        return this.unit;
    }

    public Throttle(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        int n = sin.readInt();
        Enum enum_ = sin.readEnum(ChronoUnit.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        this(n, (ChronoUnit)enum_);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field(VALUE_FIELD, this.value).field(UNIT_FIELD, this.unit.name()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.value);
        out.writeEnum((Enum)this.unit);
    }

    public final int component1() {
        return this.value;
    }

    @NotNull
    public final ChronoUnit component2() {
        return this.unit;
    }

    @NotNull
    public final Throttle copy(int value, @NotNull ChronoUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)UNIT_FIELD);
        return new Throttle(value, unit);
    }

    public static /* synthetic */ Throttle copy$default(Throttle throttle, int n, ChronoUnit chronoUnit, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = throttle.value;
        }
        if ((n2 & 2) != 0) {
            chronoUnit = throttle.unit;
        }
        return throttle.copy(n, chronoUnit);
    }

    @NotNull
    public String toString() {
        return "Throttle(value=" + this.value + ", unit=" + this.unit + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.value);
        result = result * 31 + this.unit.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Throttle)) {
            return false;
        }
        Throttle throttle = (Throttle)other;
        if (this.value != throttle.value) {
            return false;
        }
        return this.unit == throttle.unit;
    }

    @JvmStatic
    @NotNull
    public static final Throttle parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final Throttle readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/commons/alerting/model/action/Throttle$Companion;", "", "<init>", "()V", "VALUE_FIELD", "", "UNIT_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/action/Throttle;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    @SourceDebugExtension(value={"SMAP\nThrottle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Throttle.kt\norg/opensearch/commons/alerting/model/action/Throttle$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Throttle parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            int value = 0;
            ChronoUnit unit = ChronoUnit.MINUTES;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)Throttle.UNIT_FIELD)) {
                    String unitString;
                    String string2;
                    Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                    Intrinsics.checkNotNullExpressionValue((Object)string2.toUpperCase(locale), (String)"toUpperCase(...)");
                    if (!StringUtils.equals((CharSequence)unitString, (CharSequence)"MINUTES")) {
                        boolean $i$a$-require-Throttle$Companion$parse$42 = false;
                        String $i$a$-require-Throttle$Companion$parse$42 = "Only support MINUTES throttle unit currently";
                        throw new IllegalArgumentException($i$a$-require-Throttle$Companion$parse$42.toString());
                    }
                    unit = ChronoUnit.valueOf(unitString);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)Throttle.VALUE_FIELD)) {
                    XContentParser.Token currentToken = xcp.currentToken();
                    if (!(currentToken != XContentParser.Token.VALUE_NULL)) {
                        boolean $i$a$-require-Throttle$Companion$parse$52 = false;
                        String $i$a$-require-Throttle$Companion$parse$52 = "Throttle value can't be null";
                        throw new IllegalArgumentException($i$a$-require-Throttle$Companion$parse$52.toString());
                    }
                    if (currentToken.isValue()) {
                        value = xcp.intValue();
                        if (value > 0) continue;
                        boolean bl = false;
                        String string3 = "Can only set positive throttle period";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)currentToken, (XContentLocation)xcp.getTokenLocation());
                    continue;
                }
                throw new IllegalStateException("Unexpected field: " + fieldName + ", while parsing action");
            }
            ChronoUnit chronoUnit = unit;
            if (chronoUnit == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Throttle(value, chronoUnit);
        }

        @JvmStatic
        @NotNull
        public final Throttle readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Throttle(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

