/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.util;

import java.util.Locale;

public class ProtobufEnumUtils {
    private ProtobufEnumUtils() {
    }

    public static String convertToString(Enum<?> protobufEnum) {
        String messageName;
        String prefix;
        if (protobufEnum == null) {
            return null;
        }
        String enumName = protobufEnum.name();
        if (enumName.startsWith(prefix = ProtobufEnumUtils.camelCaseToSnakeCase(messageName = protobufEnum.getClass().getSimpleName()).toUpperCase(Locale.ROOT) + "_")) {
            return enumName.substring(prefix.length()).toLowerCase(Locale.ROOT);
        }
        return enumName.toLowerCase(Locale.ROOT);
    }

    private static String camelCaseToSnakeCase(String camelCase) {
        return camelCase.replaceAll("([a-z])([A-Z])", "$1_$2");
    }
}

