/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.common;

import java.util.ArrayList;
import org.opensearch.core.common.Strings;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.SearchRequest;
import org.opensearch.protobufs.SourceConfig;
import org.opensearch.protobufs.SourceConfigParam;
import org.opensearch.protobufs.SourceFilter;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class FetchSourceContextProtoUtils {
    private FetchSourceContextProtoUtils() {
    }

    public static FetchSourceContext parseFromProtoRequest(BulkRequest request) {
        Boolean fetchSource = null;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        if (request.hasXSource()) {
            switch (request.getXSource().getSourceConfigParamCase()) {
                case FETCH: {
                    fetchSource = request.getXSource().getFetch();
                    break;
                }
                case FIELDS: {
                    sourceIncludes = (String[])request.getXSource().getFields().getStringArrayList().toArray((Object[])new String[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid sourceConfig provided.");
                }
            }
        }
        if (request.getXSourceIncludesCount() > 0) {
            sourceIncludes = (String[])request.getXSourceIncludesList().toArray((Object[])new String[0]);
        }
        if (request.getXSourceExcludesCount() > 0) {
            sourceExcludes = (String[])request.getXSourceExcludesList().toArray((Object[])new String[0]);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext parseFromProtoRequest(SearchRequest request) {
        Boolean fetchSource = null;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        if (request.hasXSource()) {
            SourceConfigParam source = request.getXSource();
            if (source.hasFetch()) {
                fetchSource = source.getFetch();
            } else {
                sourceIncludes = (String[])source.getFields().getStringArrayList().toArray((Object[])new String[0]);
            }
        }
        if (request.getXSourceIncludesCount() > 0) {
            sourceIncludes = (String[])request.getXSourceIncludesList().toArray((Object[])new String[0]);
        }
        if (request.getXSourceExcludesCount() > 0) {
            sourceExcludes = (String[])request.getXSourceExcludesList().toArray((Object[])new String[0]);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext fromProto(SourceConfig sourceConfig) {
        boolean fetchSource = true;
        String[] includes = Strings.EMPTY_ARRAY;
        String[] excludes = Strings.EMPTY_ARRAY;
        if (sourceConfig.getSourceConfigCase() == SourceConfig.SourceConfigCase.FETCH) {
            fetchSource = sourceConfig.getFetch();
        } else if (sourceConfig.hasFilter()) {
            SourceFilter sourceFilter = sourceConfig.getFilter();
            if (sourceFilter.getIncludesCount() > 0) {
                ArrayList<String> includesList = new ArrayList<String>();
                for (String s : sourceFilter.getIncludesList()) {
                    includesList.add(s);
                }
                includes = includesList.toArray(new String[0]);
            }
            if (sourceFilter.getExcludesCount() > 0) {
                ArrayList<String> excludesList = new ArrayList<String>();
                for (String s : sourceFilter.getExcludesList()) {
                    excludesList.add(s);
                }
                excludes = excludesList.toArray(new String[0]);
            }
        }
        return new FetchSourceContext(fetchSource, includes, excludes);
    }
}

