/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.ingest.GetPipelineRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ingest.PipelineConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.transport.client.Client;

public final class MemoryContainerSharedIndexValidator {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryContainerSharedIndexValidator.class);

    public static void validateSharedIndexCompatibility(MemoryConfiguration requestedConfig, String longTermIndexName, Client client, ActionListener<ValidationResult> listener) {
        if (requestedConfig.getStrategies() == null || requestedConfig.getStrategies().isEmpty()) {
            listener.onResponse((Object)ValidationResult.builder().indexExists(false).compatible(true).build());
            return;
        }
        log.debug("Validating shared index compatibility for: {}", (Object)longTermIndexName);
        client.admin().indices().getMappings((GetMappingsRequest)new GetMappingsRequest().indices(new String[]{longTermIndexName}), ActionListener.wrap(mappingResponse -> MemoryContainerSharedIndexValidator.validateExistingIndex(requestedConfig, longTermIndexName, mappingResponse, client, listener), error -> MemoryContainerSharedIndexValidator.handleMappingError(longTermIndexName, error, listener)));
    }

    private static void validateExistingIndex(MemoryConfiguration requestedConfig, String longTermIndexName, GetMappingsResponse mappingResponse, Client client, ActionListener<ValidationResult> listener) {
        MappingMetadata metadata = (MappingMetadata)mappingResponse.getMappings().get(longTermIndexName);
        if (metadata == null) {
            log.error("Index '{}' exists but mapping metadata is null", (Object)longTermIndexName);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
        Map mappingMap = metadata.getSourceAsMap();
        Map properties = MemoryConfiguration.asMap(mappingMap.get("properties"));
        if (properties == null) {
            log.error("Index '{}' mapping 'properties' field is null or not a Map", (Object)longTermIndexName);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
        MemoryConfiguration.EmbeddingConfig existingConfig = MemoryConfiguration.extractEmbeddingConfigFromMapping((Map)properties);
        if (existingConfig == null) {
            log.error("Index '{}' exists but has no embedding field in mapping. This indicates a malformed or incompatible index structure.", (Object)longTermIndexName);
            listener.onFailure((Exception)new IllegalArgumentException("Cannot create memory container: Index '" + longTermIndexName + "' already exists but the mapping is malformed or missing embedding configuration. This index may have been created by another process or is corrupted. Please use a different index_prefix to create your memory container."));
            return;
        }
        MemoryContainerSharedIndexValidator.validatePipeline(requestedConfig, longTermIndexName, existingConfig, client, listener);
    }

    private static void validatePipeline(MemoryConfiguration requestedConfig, String longTermIndexName, MemoryConfiguration.EmbeddingConfig existingConfig, Client client, ActionListener<ValidationResult> listener) {
        String pipelineName = longTermIndexName + "-embedding";
        client.admin().cluster().getPipeline(new GetPipelineRequest(new String[]{pipelineName}), ActionListener.wrap(pipelineResponse -> {
            if (pipelineResponse.pipelines().isEmpty()) {
                log.error("Index '{}' exists but pipeline '{}' not found. Index and pipeline are out of sync.", (Object)longTermIndexName, (Object)pipelineName);
                listener.onFailure((Exception)new IllegalArgumentException("Cannot create memory container: Index '" + longTermIndexName + "' exists but the required ingest pipeline '" + pipelineName + "' is missing. This indicates an incomplete or corrupted setup. Please use a different index_prefix to create your memory container."));
                return;
            }
            Map pipelineSource = ((PipelineConfiguration)pipelineResponse.pipelines().get(0)).getConfigAsMap();
            String existingModelId = MemoryConfiguration.extractModelIdFromPipeline((Map)pipelineSource);
            if (existingModelId == null) {
                log.error("Pipeline '{}' exists but has no model_id configured. Pipeline definition: {}", (Object)pipelineName, (Object)pipelineSource);
                listener.onFailure((Exception)new IllegalArgumentException("Cannot create memory container: Ingest pipeline '" + pipelineName + "' exists but is not configured correctly (missing model_id in processor). This indicates a malformed pipeline configuration. Please use a different index_prefix to create your memory container."));
                return;
            }
            MemoryContainerSharedIndexValidator.compareConfigurations(requestedConfig, longTermIndexName, existingModelId, existingConfig, listener);
        }, error -> MemoryContainerSharedIndexValidator.handlePipelineError(pipelineName, error, listener)));
    }

    private static void compareConfigurations(MemoryConfiguration requestedConfig, String longTermIndexName, String existingModelId, MemoryConfiguration.EmbeddingConfig existingConfig, ActionListener<ValidationResult> listener) {
        try {
            MemoryConfiguration.compareEmbeddingConfig((MemoryConfiguration)requestedConfig, (String)existingModelId, (MemoryConfiguration.EmbeddingConfig)existingConfig);
            log.info("Validated compatibility with existing shared index '{}' (model: {}, type: {}, dimension: {})", (Object)longTermIndexName, (Object)existingModelId, (Object)existingConfig.getType(), (Object)existingConfig.getDimension());
            listener.onResponse((Object)ValidationResult.builder().indexExists(true).compatible(true).existingModelId(existingModelId).existingConfig(existingConfig).build());
        }
        catch (IllegalArgumentException e) {
            log.error("Container creation failed: embedding configuration mismatch. Index: {}, Existing: [{}, {}, {}], Requested: [{}, {}, {}]. Error: {}", (Object)longTermIndexName, (Object)existingModelId, (Object)existingConfig.getType(), (Object)existingConfig.getDimension(), (Object)requestedConfig.getEmbeddingModelId(), (Object)requestedConfig.getEmbeddingModelType(), (Object)requestedConfig.getDimension(), (Object)e.getMessage());
            listener.onFailure((Exception)e);
        }
    }

    private static void handleMappingError(String indexName, Exception error, ActionListener<ValidationResult> listener) {
        if (error instanceof IndexNotFoundException) {
            log.debug("Long-term memory index '{}' does not exist, proceeding with creation", (Object)indexName);
            listener.onResponse((Object)ValidationResult.builder().indexExists(false).compatible(true).build());
            return;
        }
        log.error("Failed to retrieve mapping for index '{}'. Exception type: {}, Message: {}", (Object)indexName, (Object)error.getClass().getSimpleName(), (Object)error.getMessage(), (Object)error);
        listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    private static void handlePipelineError(String pipelineName, Exception error, ActionListener<ValidationResult> listener) {
        log.error("Failed to retrieve pipeline '{}' for validation", (Object)pipelineName, (Object)error);
        listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    @Generated
    private MemoryContainerSharedIndexValidator() {
    }

    public static class ValidationResult {
        private final boolean indexExists;
        private final boolean compatible;
        private final String existingModelId;
        private final MemoryConfiguration.EmbeddingConfig existingConfig;

        @Generated
        public static ValidationResultBuilder builder() {
            return new ValidationResultBuilder();
        }

        @Generated
        public boolean isIndexExists() {
            return this.indexExists;
        }

        @Generated
        public boolean isCompatible() {
            return this.compatible;
        }

        @Generated
        public String getExistingModelId() {
            return this.existingModelId;
        }

        @Generated
        public MemoryConfiguration.EmbeddingConfig getExistingConfig() {
            return this.existingConfig;
        }

        @Generated
        public ValidationResult(boolean indexExists, boolean compatible, String existingModelId, MemoryConfiguration.EmbeddingConfig existingConfig) {
            this.indexExists = indexExists;
            this.compatible = compatible;
            this.existingModelId = existingModelId;
            this.existingConfig = existingConfig;
        }

        @Generated
        public static class ValidationResultBuilder {
            @Generated
            private boolean indexExists;
            @Generated
            private boolean compatible;
            @Generated
            private String existingModelId;
            @Generated
            private MemoryConfiguration.EmbeddingConfig existingConfig;

            @Generated
            ValidationResultBuilder() {
            }

            @Generated
            public ValidationResultBuilder indexExists(boolean indexExists) {
                this.indexExists = indexExists;
                return this;
            }

            @Generated
            public ValidationResultBuilder compatible(boolean compatible) {
                this.compatible = compatible;
                return this;
            }

            @Generated
            public ValidationResultBuilder existingModelId(String existingModelId) {
                this.existingModelId = existingModelId;
                return this;
            }

            @Generated
            public ValidationResultBuilder existingConfig(MemoryConfiguration.EmbeddingConfig existingConfig) {
                this.existingConfig = existingConfig;
                return this;
            }

            @Generated
            public ValidationResult build() {
                return new ValidationResult(this.indexExists, this.compatible, this.existingModelId, this.existingConfig);
            }

            @Generated
            public String toString() {
                return "MemoryContainerSharedIndexValidator.ValidationResult.ValidationResultBuilder(indexExists=" + this.indexExists + ", compatible=" + this.compatible + ", existingModelId=" + this.existingModelId + ", existingConfig=" + String.valueOf(this.existingConfig) + ")";
            }
        }
    }
}

