/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerGetRequest;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerGetResponse;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetMemoryContainerAction
extends HandledTransportAction<ActionRequest, MLMemoryContainerGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportGetMemoryContainerAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportGetMemoryContainerAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/get", transportService, actionFilters, MLMemoryContainerGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMemoryContainerGetResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLMemoryContainerGetRequest mlMemoryContainerGetRequest = MLMemoryContainerGetRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = mlMemoryContainerGetRequest.getMemoryContainerId();
        String tenantId = mlMemoryContainerGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-am-memory-container")).id(memoryContainerId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> this.handleResponse((GetDataObjectResponse)r, (Throwable)throwable, memoryContainerId, tenantId, user, (ActionListener<MLMemoryContainerGetResponse>)wrappedListener));
        }
        catch (Exception e) {
            log.error("Failed to get ML memory container {}", (Object)memoryContainerId, (Object)e);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void handleResponse(GetDataObjectResponse getDataObjectResponse, Throwable throwable, String memoryContainerId, String tenantId, User user, ActionListener<MLMemoryContainerGetResponse> wrappedListener) {
        log.debug("Completed Get Memory Container Request, id:{}", (Object)memoryContainerId);
        if (throwable != null) {
            this.handleThrowable(throwable, memoryContainerId, wrappedListener);
        } else {
            this.processResponse(getDataObjectResponse, memoryContainerId, tenantId, user, wrappedListener);
        }
    }

    private void handleThrowable(Throwable throwable, String memoryContainerId, ActionListener<MLMemoryContainerGetResponse> wrappedListener) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to find memory container index", (Throwable)cause);
            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find memory container index", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            log.error("Failed to get ML memory container {}", (Object)memoryContainerId, (Object)cause);
            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void processResponse(GetDataObjectResponse getDataObjectResponse, String memoryContainerId, String tenantId, User user, ActionListener<MLMemoryContainerGetResponse> wrappedListener) {
        block12: {
            try {
                GetResponse gr = getDataObjectResponse.getResponse();
                if (gr != null && gr.isExists()) {
                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLMemoryContainer mlMemoryContainer = MLMemoryContainer.parse((XContentParser)parser);
                        if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlMemoryContainer.getTenantId(), wrappedListener)) {
                            this.validateMemoryContainerAccess(user, memoryContainerId, mlMemoryContainer, wrappedListener);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml memory container {}", (Object)getDataObjectResponse.id(), (Object)e);
                        wrappedListener.onFailure(e);
                    }
                    break block12;
                }
                wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find memory container with the provided memory container id: " + memoryContainerId, RestStatus.NOT_FOUND, new Object[0]));
            }
            catch (Exception e) {
                wrappedListener.onFailure(e);
            }
        }
    }

    private void validateMemoryContainerAccess(User user, String memoryContainerId, MLMemoryContainer mlMemoryContainer, ActionListener<MLMemoryContainerGetResponse> wrappedListener) {
        boolean hasAccess = this.memoryContainerHelper.checkMemoryContainerAccess(user, mlMemoryContainer);
        if (!hasAccess) {
            wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this memory container", RestStatus.FORBIDDEN, new Object[0]));
        } else {
            wrappedListener.onResponse((Object)MLMemoryContainerGetResponse.builder().mlMemoryContainer(mlMemoryContainer).build());
        }
    }
}

