/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.filecache;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class NodePruneFileCacheResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private final long prunedBytes;
    private final long cacheCapacity;

    public NodePruneFileCacheResponse(StreamInput in) throws IOException {
        super(in);
        this.prunedBytes = in.readLong();
        this.cacheCapacity = in.readLong();
    }

    public NodePruneFileCacheResponse(DiscoveryNode node, long prunedBytes, long cacheCapacity) {
        super(node);
        this.prunedBytes = prunedBytes;
        this.cacheCapacity = cacheCapacity;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.prunedBytes);
        out.writeLong(this.cacheCapacity);
    }

    public long getPrunedBytes() {
        return this.prunedBytes;
    }

    public long getCacheCapacity() {
        return this.cacheCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePruneFileCacheResponse)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodePruneFileCacheResponse that = (NodePruneFileCacheResponse)((Object)o);
        return this.prunedBytes == that.prunedBytes && this.cacheCapacity == that.cacheCapacity;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prunedBytes, this.cacheCapacity);
    }

    public String toString() {
        return "NodePruneFileCacheResponse{node=" + this.getNode().getId() + ", prunedBytes=" + this.prunedBytes + ", cacheCapacity=" + this.cacheCapacity + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.getNode().getName());
        builder.field("transport_address", this.getNode().getAddress().toString());
        builder.field("host", this.getNode().getHostName());
        builder.field("ip", this.getNode().getHostAddress());
        builder.field("pruned_bytes", this.prunedBytes);
        builder.field("cache_capacity", this.cacheCapacity);
        return builder;
    }
}

