/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.transport.health_stats;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsNodeResponse;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsRequest;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

public class TransportHealthStatsAction
extends TransportNodesAction<HealthStatsRequest, HealthStatsResponse, NodeRequest, HealthStatsNodeResponse> {
    private final QueryInsightsService queryInsightsService;

    @Inject
    public TransportHealthStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, QueryInsightsService queryInsightsService, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/insights/health_stats", threadPool, clusterService, transportService, actionFilters, HealthStatsRequest::new, NodeRequest::new, "generic", HealthStatsNodeResponse.class);
        this.queryInsightsService = queryInsightsService;
    }

    protected HealthStatsResponse newResponse(HealthStatsRequest healthStatsRequest, List<HealthStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new HealthStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeRequest newNodeRequest(HealthStatsRequest request) {
        return new NodeRequest(request);
    }

    protected HealthStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new HealthStatsNodeResponse(in);
    }

    protected HealthStatsNodeResponse nodeOperation(NodeRequest nodeRequest) {
        HealthStatsRequest request = nodeRequest.request;
        return new HealthStatsNodeResponse(this.clusterService.localNode(), this.queryInsightsService.getHealthStats());
    }

    public static class NodeRequest
    extends TransportRequest {
        final HealthStatsRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new HealthStatsRequest(in);
        }

        public NodeRequest(HealthStatsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

