/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;

public final class TypeNameClassifier {
    private TypeNameClassifier() {
    }

    static Optional<Integer> typePrefixLength(List<String> nameParts) {
        TyParseState state = TyParseState.START;
        Optional<Integer> typeLength = Optional.empty();
        for (int i = 0; i < nameParts.size() && (state = state.next(JavaCaseFormat.from(nameParts.get(i)))) != TyParseState.REJECT; ++i) {
            if (!state.isSingleUnit()) continue;
            typeLength = Optional.of(i);
        }
        return typeLength;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TyParseState {
        START(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return switch (n) {
                    default -> throw new IncompatibleClassChangeError();
                    case JavaCaseFormat.UPPERCASE -> AMBIGUOUS;
                    case JavaCaseFormat.LOWER_CAMEL -> REJECT;
                    case JavaCaseFormat.LOWERCASE -> START;
                    case JavaCaseFormat.UPPER_CAMEL -> TYPE;
                };
            }
        }
        ,
        TYPE(true){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return switch (n) {
                    default -> throw new IncompatibleClassChangeError();
                    case JavaCaseFormat.UPPERCASE, JavaCaseFormat.LOWER_CAMEL, JavaCaseFormat.LOWERCASE -> FIRST_STATIC_MEMBER;
                    case JavaCaseFormat.UPPER_CAMEL -> TYPE;
                };
            }
        }
        ,
        FIRST_STATIC_MEMBER(true){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return REJECT;
            }
        }
        ,
        REJECT(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return REJECT;
            }
        }
        ,
        AMBIGUOUS(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return switch (n) {
                    default -> throw new IncompatibleClassChangeError();
                    case JavaCaseFormat.UPPERCASE -> AMBIGUOUS;
                    case JavaCaseFormat.LOWER_CAMEL, JavaCaseFormat.LOWERCASE -> REJECT;
                    case JavaCaseFormat.UPPER_CAMEL -> TYPE;
                };
            }
        };

        private final boolean isSingleUnit;

        private TyParseState(boolean isSingleUnit) {
            this.isSingleUnit = isSingleUnit;
        }

        public boolean isSingleUnit() {
            return this.isSingleUnit;
        }

        public abstract TyParseState next(JavaCaseFormat var1);
    }

    public static enum JavaCaseFormat {
        UPPERCASE,
        LOWERCASE,
        UPPER_CAMEL,
        LOWER_CAMEL;


        static JavaCaseFormat from(String name) {
            Verify.verify((!name.isEmpty() ? 1 : 0) != 0);
            boolean firstUppercase = false;
            boolean hasUppercase = false;
            boolean hasLowercase = false;
            boolean first = true;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isAlphabetic(c)) continue;
                if (first) {
                    firstUppercase = Character.isUpperCase(c);
                    first = false;
                }
                hasUppercase |= Character.isUpperCase(c);
                hasLowercase |= Character.isLowerCase(c);
            }
            if (firstUppercase) {
                return hasLowercase || name.length() == 1 ? UPPER_CAMEL : UPPERCASE;
            }
            return hasUppercase ? LOWER_CAMEL : LOWERCASE;
        }
    }
}

